// $Id: OperationFactoryFilter.java,v 1.5 1998/04/11 10:28:40 oliva Exp $

package BR.unicamp.Guarana;

import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

/** An instance of this class delegates all methods to another
    OperationFactory.  It is intended to be used as a base class for
    classes that prevent certain kinds of Operations from being
    created.

    @author Alexandre Oliva
    @version $Revision: 1.5 $ */
public abstract class OperationFactoryFilter extends OperationFactory {
    /** The OperationFactory this filter delegates requests to.  */
    private final OperationFactory factory;

    /** Creates an OperationFactory that delegates all requests to the
	given OperationFactory, except the ones overridden by
	subclasses.

	@param factory the OperationFactory it delegates to.  */
    public OperationFactoryFilter(final OperationFactory factory)
    { this.factory = factory; }

    /** Should return the Object this OperationFactory creates
	Operations for.  For static Operations, it will be the target
	class.

	@return the target Object for this class.  */
    public final Object getObject() {
	return factory.getObject();
    }

    /** Asks the OperationFactoryFilter specified in the constructor
	to create a do-nothing Operation.

	@return the new Operation.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation nop() throws IllegalAccessException {
	return factory.nop();
    }

    /** Asks the OperationFactoryFilter specified in the constructor
	to create a Method invocation Operation.

	@param method the Method to be invoked.

	@param arguments the argument list to be passed to the Method.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the Method return type
	is not compatible with the expected type of the replaced
	Operation.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation invoke(final Method method,
			    final Object[] arguments,
			    final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.invoke(method, arguments, operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create a Constructor invocation Operation.

	@param constructor the Constructor to be invoked.

	@param arguments the argument list to be passed to the
	Constructor.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the expected type of the
	replaced Operation is not void.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation construct(final Constructor constructor,
			       final Object[] arguments,
			       final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.construct(constructor, arguments, operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create a start-of-synchronization Operation.
	@param operation an Operation that should be replaced.  If it
	is null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the expected type of the
	replaced Operation is not void.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation monitorEnter(final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.monitorEnter(operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create an end-of-synchronization Operation.
	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the expected type of the
	replaced Operation is not void.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation monitorExit(final Operation operation)
	throws IllegalArgumentException, IllegalAccessException{
	return factory.monitorExit(operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create a Field read Operation.
	@param field the Field whose value is to be obtained.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.
      
	@exception IllegalArgumentException if the Field type is not
	compatible with the expected Result type of the replaced
	Operation.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation read(final Field field,
			  final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.read(field, operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create a Field write Operation.

	@param field the Field whose value is to be changed.

	@param value the value to be stored in the Field.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the replaced Operation
	did not have type void.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation write(final Field field,
			   final Object value,
			   final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.write(field, value, operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create an Array length Operation.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the replaced Operation
	did not have type int.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation length(final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.length(operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create an Array element read Operation.

	@param element the element whose value is to be obtained.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.
      
	@exception IllegalArgumentException if the element type is not
	compatible with the expected type of the replaced Operation.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation readElement(final int element,
				 final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.readElement(element, operation);
    }

    /** Asks the OperationFactoryFilter specified in the constructor to
	create an Array element write Operation.

	@param element the element whose value is to be changed.

	@param value the value to be stored in the element.

	@param operation an Operation that should be replaced.  If it is
	null, a non-replacement Operation is created.
      
	@return the new Operation.

	@exception IllegalArgumentException if the replaced Operation
	did not have type void.

	@exception IllegalAccessException if the OperationFactory
	refuses to create the requested Operation.  */
    public Operation writeElement(final int element,
				  final Object value,
				  final Operation operation)
	throws IllegalArgumentException, IllegalAccessException {
	return factory.writeElement(element, value, operation);
    }
}
