// $Id: HashWrapper.java,v 1.1 1998/04/11 09:55:07 oliva Exp $

package BR.unicamp.Guarana;

/** This class is to be used for wrapping base-level Objects, when
    they are used as keys in meta-level HashTables.  The memory
    address of the Object is used as its hashCode, and only references
    are compared for equality.

    @author Alexandre Oliva
    @version $Revision: 1.1 $  */
public class HashWrapper {
    /** The Object wrapped by this HashWrapper.  */
    public final Object object;
    
    /** Constructs a HashWrapper object that wraps the given Object.

	@param the base-level Object to be wrapped.  */
    public HashWrapper(final Object object) {
	this.object = object;
    }

    /** Returns the memory address of the Object.

	@return the result of <tt>Guarana.hashCode(this.object)</tt>.

	@see Guarana#hashCode */
    public int hashCode() {
	return Guarana.hashCode(object);
    }

    /** Returns a String representing the base-level Object.

	@return the result of <tt>Guarana.toString(this.object)</tt>.

	@see Guarana#toString */
    public String toString() {
	return Guarana.toString(object);
    }

    /** Compares the references of the wrapped Object with the given
	Object, assuming it may be a HashWrapper too.

	@param wrapper a HashWrapper or any Object

	@return true if the given Object is either the wrapped Object
	or a HashWrapper that wraps it.  */
    public boolean equals(final Object wrapper) {
	return object == wrapper ||
	    (wrapper instanceof HashWrapper &&
	     ((HashWrapper)wrapper).object == object);
    }
}
