// $Id: OperationFactoryInternal.java,v 1.3 1998/02/05 14:05:08 oliva Exp $

package BR.unicamp.Guarana;

import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

/** The native and only implementation of an OperationFactory that
    actually creates Operation objects.  It will only be instantiated
    by the internals of Guarana, and it will be given to the
    MetaObject directly associated with an Object by invoking the
    Initialize method.

    Operations created by OperationFactories are not validated: one
    can create arbitrary Operations.  However, Operations will only be
    delivered to the target Object if they are valid Java Operations.

    @see MetaObject#initialize
    @see Operation#validate

    @author Alexandre Oliva
    @version $Revision: 1.3 $ */
final class OperationFactoryInternal extends OperationFactory {
  /** Must not be instantiated in Java.  */
  private OperationFactoryInternal() {}

  /** Should return the Object this OperationFactory creates
      Operations for.  For static Operations, it will be the target
      class.

      @return the target Object for this class.  */
  public native Object getObject();

  /** Creates a Method invocation Operation.

      @param method the Method to be invoked.

      @param arguments the argument list to be passed to the Method.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the Method return type
      is not compatible with the expected type of the replaced
      Operation.  */
  public native Operation invoke(final Method method,
				 final Object[] arguments,
				 final Operation operation)
    throws IllegalArgumentException;

  /** Creates a Constructor invocation Operation.

      @param constructor the Constructor to be invoked.

      @param arguments the argument list to be passed to the
      Constructor.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the expected type of the
      replaced Operation is not void.  */
  public native Operation construct(final Constructor constructor,
				    final Object[] arguments,
				    final Operation operation)
    throws IllegalArgumentException;

  /** Creates a start-of-synchronization Operation.

      @param operation an Operation that should be replaced.  If it
      is null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the expected type of the
      replaced Operation is not void.  */
  public native Operation monitorEnter(final Operation operation)
    throws IllegalArgumentException;

  /** Creates a replacement end-of-synchronization Operation.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the expected type of the
      replaced Operation is not void.  */
  public native Operation monitorExit(final Operation operation)
    throws IllegalArgumentException;

  /** Creates a Field read Operation.

      @param field the Field whose value is to be obtained.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.
      
      @exception IllegalArgumentException if the Field type is not
      compatible with the expected Result type of the replaced
      Operation.  */
  public native Operation read(final Field field,
			       final Operation operation)
    throws IllegalArgumentException;

  /** Creates a Field write Operation.

      @param field the Field whose value is to be changed.

      @param value the value to be stored in the Field.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the replaced Operation
      did not have type void.  */
  public native Operation write(final Field field,
				final Object value,
				final Operation operation)
    throws IllegalArgumentException;

  /** Creates an Array length Operation.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the replaced Operation
      did not have type int.  */
  public native Operation length(final Operation operation)
    throws IllegalArgumentException;

  /** Creates an Array element read Operation.

      @param element the element whose value is to be obtained.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.
      
      @exception IllegalArgumentException if the element type is not
      compatible with the expected type of the replaced Operation.  */
  public native Operation readElement(final int element,
				      final Operation operation)
    throws IllegalArgumentException;

  /** Creates an Array element write Operation.

      @param element the element whose value is to be changed.

      @param value the value to be stored in the element.

      @param operation an Operation that should be replaced.  If it is
      null, a non-replacement Operation is created.
      
      @return the new Operation.

      @exception IllegalArgumentException if the replaced Operation
      did not have type void.  */
  public native Operation writeElement(final int element,
				       final Object value,
				       final Operation operation)
    throws IllegalArgumentException;
}
