/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura;

import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.swixml.ConverterLibrary;
import org.swixml.SwingEngine;
import serpro.ppgd.formatosexternos.ListaRelatoriosIf;
import serpro.ppgd.gui.EditAlfa;
import serpro.ppgd.gui.EditCEP;
import serpro.ppgd.gui.EditCNPJ;
import serpro.ppgd.gui.EditCPF;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.EditCodigo;
import serpro.ppgd.gui.EditData;
import serpro.ppgd.gui.EditInteiro;
import serpro.ppgd.gui.EditMemo;
import serpro.ppgd.gui.EditNI;
import serpro.ppgd.gui.EditNIRF;
import serpro.ppgd.gui.EditNumeroRecibo;
import serpro.ppgd.gui.EditTelefone;
import serpro.ppgd.gui.EditValor;
import serpro.ppgd.gui.OpcaoDialog;
import serpro.ppgd.infraestrutura.converters.ActionConverter;
import serpro.ppgd.infraestrutura.converters.CellConstraintsConverter;
import serpro.ppgd.infraestrutura.converters.ConstructorConverter;
import serpro.ppgd.infraestrutura.converters.DimensaoArrConverter;
import serpro.ppgd.infraestrutura.converters.FormLayoutConverter;
import serpro.ppgd.infraestrutura.converters.InformacaoConverter;
import serpro.ppgd.infraestrutura.treeview.ArvoreGenerica;
import serpro.ppgd.infraestrutura.treeview.NoGenerico;
import serpro.ppgd.infraestrutura.util.HelpUtil;
import serpro.ppgd.infraestrutura.util.PPGDFormPanel;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class PlataformaPPGD {
    protected static PlataformaPPGD plataformaDefault = null;
    private SwingEngine swingEngine = null;
    protected Map listaPaineisInstanciados = new HashMap();
    private Collection colListaRelatorios = new ArrayList();
    private HelpUtil help;
    private static boolean emDesign = true;
    private boolean comportamentoPadraoSair = true;

    public PlataformaPPGD() {
        this.init();
    }

    public void init() {
        SwingEngine swingEngine = new SwingEngine(this);
        this.setSwingEngine(swingEngine);
        this.registraConverters();
        this.registraTags();
    }

    public void cadastraPainel(String string, JPanel jPanel) {
        this.listaPaineisInstanciados.put(string, jPanel);
    }

    public boolean existePainelCadastrado(String string) {
        return this.listaPaineisInstanciados.containsKey(string);
    }

    public JPanel getPainel(String string) {
        return (JPanel)this.listaPaineisInstanciados.get(string);
    }

    public HelpUtil getHelp() {
        return this.help;
    }

    public void setHelpID(Component component, String string) {
        if (this.help != null) {
            this.help.setHelpID(component, string);
        }
    }

    public void habilitaHelp(JRootPane jRootPane, String string) {
        if (this.help != null) {
            this.help.enableHelpKey(jRootPane, string);
        }
    }

    public void habilitaHelp(JPanel jPanel, String string) {
        if (this.help != null) {
            this.help.enableHelpKey(jPanel, string);
        }
    }

    public void setHelpID(String string, String string2) {
        if (this.help != null) {
            JComponent jComponent = (JComponent)this.getComponent(string);
            this.help.setHelpID(jComponent, string2);
        }
    }

    public void setHelpID(EditCampo editCampo, String string) {
        if (this.help != null) {
            this.help.setHelpID(editCampo.getComponenteFoco(), string);
        }
    }

    public void setHelpID(String string) {
        if (this.help != null) {
            JComponent jComponent = (JComponent)this.getComponent(string);
            String string2 = jComponent.getClientProperty("helpID").toString();
            this.help.setHelpID(jComponent, string2);
        }
    }

    protected void registraTags() {
        this.getSwingEngine().getTaglib().registerTag("arvore", ArvoreGenerica.class);
        this.getSwingEngine().getTaglib().registerTag("nodo", NoGenerico.class);
        this.getSwingEngine().getTaglib().registerTag("debugpanel", FormDebugPanel.class);
        this.getSwingEngine().getTaglib().registerTag("formpanel", PPGDFormPanel.class);
        this.getSwingEngine().getTaglib().registerTag("editCodigo", EditCodigo.class);
        this.getSwingEngine().getTaglib().registerTag("editMemo", EditMemo.class);
        this.getSwingEngine().getTaglib().registerTag("editValor", EditValor.class);
        this.getSwingEngine().getTaglib().registerTag("editAlfa", EditAlfa.class);
        this.getSwingEngine().getTaglib().registerTag("editCpf", EditCPF.class);
        this.getSwingEngine().getTaglib().registerTag("editCnpj", EditCNPJ.class);
        this.getSwingEngine().getTaglib().registerTag("editCEP", EditCEP.class);
        this.getSwingEngine().getTaglib().registerTag("editData", EditData.class);
        this.getSwingEngine().getTaglib().registerTag("editInteiro", EditInteiro.class);
        this.getSwingEngine().getTaglib().registerTag("editNI", EditNI.class);
        this.getSwingEngine().getTaglib().registerTag("editNIRF", EditNIRF.class);
        this.getSwingEngine().getTaglib().registerTag("editNumeroRecibo", EditNumeroRecibo.class);
        this.getSwingEngine().getTaglib().registerTag("editTelefone", EditTelefone.class);
        this.getSwingEngine().getTaglib().registerTag("comando", Object.class);
    }

    protected void registraConverters() {
        ConverterLibrary.getInstance().register(CellConstraints.class, new CellConstraintsConverter());
        ConverterLibrary.getInstance().register(LayoutManager.class, new FormLayoutConverter());
        ConverterLibrary.getInstance().register(Constructor.class, new ConstructorConverter());
        ConverterLibrary.getInstance().register(Action.class, new ActionConverter());
        ConverterLibrary.getInstance().register(Dimension[].class, new DimensaoArrConverter());
        ConverterLibrary.getInstance().register(Informacao.class, new InformacaoConverter());
    }

    public static void setPlataforma(PlataformaPPGD plataformaPPGD) {
        plataformaDefault = plataformaPPGD;
    }

    public static PlataformaPPGD getPlataforma() {
        if (plataformaDefault == null) {
            plataformaDefault = new PlataformaPPGD();
        }
        return plataformaDefault;
    }

    public void carrega() {
        try {
            PlataformaPPGD.setEmDesign(false);
            if (System.getProperty("os.name").toUpperCase().startsWith("LINUX")) {
                UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
            } else {
                UIManager.setLookAndFeel(Options.getSystemLookAndFeelClassName());
            }
            UIManager.put("OptionPane.yesButtonText", "Sim");
            UIManager.put("OptionPane.yesButtonMnemonic", "83");
            UIManager.put("OptionPane.noButtonText", "N\u00e3o");
            UIManager.put("OptionPane.noButtonMnemonic", "78");
            UIManager.put("OptionPane.okButtonText", "Ok");
            UIManager.put("OptionPane.okButtonMnemonic", "79");
            UIManager.put("OptionPane.cancelButtonText", "Cancelar");
            UIManager.put("OptionPane.cancelButtonMnemonic", "83");
            URL uRL = UtilitariosArquivo.localizaArquivoEmClasspath("/ppgd-default.xml");
            this.getSwingEngine().render(uRL);
            this.carregaHelp();
            this.getJanelaPrincipal().addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    if (PlataformaPPGD.this.isComportamentoPadraoSair()) {
                        PlataformaPPGD.this.exitPgd();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void exitPgd() {
        try {
            String string = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("getInstancia", null);
            PPGDFacade pPGDFacade = (PPGDFacade)method.invoke(null, null);
            Method method2 = clazz.getMethod("salvaUltimaDeclaracaoAberta", null);
            method2.invoke((Object)pPGDFacade, null);
        }
        catch (Exception exception) {}
        System.exit(0);
    }

    public void exibe() {
        Dimension dimension = this.obtemResolucao();
        if (dimension != null) {
            this.getJanelaPrincipal().setSize(dimension);
        }
        this.getJanelaPrincipal().setLocationRelativeTo(null);
        this.getJanelaPrincipal().setVisible(true);
    }

    private Dimension obtemResolucao() {
        String string = FabricaUtilitarios.getProperties().getProperty("resolucao", "");
        if (string.trim().length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        int n2 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        if (stringTokenizer.hasMoreTokens()) {
            n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        return new Dimension(n, n2);
    }

    public void refreshJanelaPrincipal() {
        Dimension dimension = this.getJanelaPrincipal().getSize();
        ++dimension.width;
        ++dimension.height;
        this.getJanelaPrincipal().setSize(dimension);
        --dimension.width;
        --dimension.height;
        this.getJanelaPrincipal().setSize(dimension);
    }

    public JFrame getJanelaPrincipal() {
        return (JFrame)this.getSwingEngine().find("mainframe");
    }

    public JPanel getPainelPrincipal() {
        return (JPanel)this.getSwingEngine().find("pnlPrincipal");
    }

    public Component getAreaPaineis() {
        return this.getSwingEngine().find("pnlPPGD");
    }

    public Component getScrollAreaPaineis() {
        return this.getSwingEngine().find("ppgdScrollPnlPPGD");
    }

    public Component getAreaArvore() {
        return this.getSwingEngine().find("ppgdAreaArvore");
    }

    public Component getArvore() {
        return this.getSwingEngine().find("ppgdarvore");
    }

    public Component getToolbar() {
        return this.getSwingEngine().find("tbPPGD");
    }

    public Component getPainelSplit() {
        return this.getSwingEngine().find("splitPPGD");
    }

    public void aplicaMenuBar(String string) {
        try {
            SwingEngine swingEngine = new SwingEngine();
            JMenuBar jMenuBar = (JMenuBar)swingEngine.render(string);
            this.getJanelaPrincipal().setJMenuBar(jMenuBar);
            this.getSwingEngine().getIdMap().putAll(swingEngine.getIdMap());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void aplicaArvore(String string) {
        JScrollPane jScrollPane = (JScrollPane)this.getAreaArvore();
        if (string.endsWith(".xml")) {
            ArvoreGenerica arvoreGenerica = new ArvoreGenerica();
            jScrollPane.setViewportView(arvoreGenerica);
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                jScrollPane.setViewportView((Component)clazz.newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Component getComponent(String string) {
        return this.getSwingEngine().find(string);
    }

    public void setSwingEngine(SwingEngine swingEngine) {
        this.swingEngine = swingEngine;
    }

    public SwingEngine getSwingEngine() {
        return this.swingEngine;
    }

    public void mudaPainelExibido(JPanel jPanel) {
        Container container = (Container)this.getAreaPaineis();
        container.removeAll();
        container.add(jPanel);
        container.validate();
        container.repaint();
        this.getScrollAreaPaineis().repaint();
        ((JScrollPane)this.getScrollAreaPaineis()).revalidate();
    }

    public void componentEnabled(String string, boolean bl) {
        this.getSwingEngine().find(string).setEnabled(bl);
    }

    public void componentVisible(String string, boolean bl) {
        this.getSwingEngine().find(string).setVisible(bl);
    }

    public void exibeDialog(JPanel jPanel, String string, boolean bl) {
        JDialog jDialog = new JDialog(this.getJanelaPrincipal(), string, bl);
        jDialog.getContentPane().add(jPanel);
        jDialog.setSize(jDialog.getPreferredSize());
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo(null);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public void exibeDialog(String string, String string2, boolean bl) {
        try {
            JPanel jPanel = (JPanel)this.swingEngine.render(this.getClass().getResource(string));
            this.exibeDialog(jPanel, string2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(exception);
        }
    }

    public int exibeDialogOpcoes(String string, String string2, String[] stringArray, boolean bl) {
        return new OpcaoDialog(this.getJanelaPrincipal(), string, string2, stringArray, bl).showDialog(string);
    }

    public Collection getListaRelatorios() {
        return this.colListaRelatorios;
    }

    public void registraListaRelatorio(ListaRelatoriosIf listaRelatoriosIf) {
        this.colListaRelatorios.add(listaRelatoriosIf);
    }

    public JPanel instanciaPainel(String string) throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        JPanel jPanel = null;
        if (string.endsWith(".xml")) {
            SwingEngine swingEngine = new SwingEngine();
            jPanel = (JPanel)swingEngine.render(string);
        } else if (string.trim().length() > 0) {
            Class<?> clazz = Class.forName(string);
            jPanel = (JPanel)clazz.newInstance();
        }
        return jPanel;
    }

    public void limpaPainelPrincipal() {
        this.componentVisible("splitPPGD", false);
    }

    public void mostraPainelPrincipal() {
        this.componentVisible("splitPPGD", true);
    }

    public void desabilitaComponentes(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.componentEnabled(stringArray[n], false);
            ++n;
        }
    }

    public void habilitaComponentes(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.componentEnabled(stringArray[n], true);
            ++n;
        }
    }

    public boolean temDeclaracoes() {
        boolean bl;
        try {
            String string = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("getInstancia", null);
            PPGDFacade pPGDFacade = (PPGDFacade)method.invoke(null, null);
            Method method2 = clazz.getMethod("existeDeclaracoes", null);
            bl = (Boolean)method2.invoke((Object)pPGDFacade, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    protected void carregaHelp() {
        String string = FabricaUtilitarios.getProperties().getProperty("help", "");
        String string2 = FabricaUtilitarios.getProperties().getProperty("help.default.id", "");
        if (!string.equals("")) {
            this.help = new HelpUtil(this.getJanelaPrincipal().getRootPane(), string2);
            String string3 = FabricaUtilitarios.getPathCompletoDirAplicacao();
            string3 = null;
            this.help.setHelpSet(string, string3);
            String string4 = String.valueOf(string3) + FabricaUtilitarios.getProperties().getProperty("help.icon", "");
            ImageIcon imageIcon = new ImageIcon(string4);
            this.help.setIcon(imageIcon);
        }
    }

    public static void setEmDesign(boolean bl) {
        emDesign = bl;
    }

    public static boolean isEmDesign() {
        return emDesign;
    }

    public void setComportamentoPadraoSair(boolean bl) {
        this.comportamentoPadraoSair = bl;
    }

    public boolean isComportamentoPadraoSair() {
        return this.comportamentoPadraoSair;
    }
}

