/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int n = 0;
            int n2 = this.expressions.length;
            while (n < n2) {
                flowInfo = this.expressions[n].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n;
            }
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n;
        block13: {
            n = codeStream.position;
            int n2 = this.expressions == null ? 0 : this.expressions.length;
            codeStream.generateInlinedValue(n2);
            codeStream.newArray(this.binding);
            if (this.expressions == null) break block13;
            int n3 = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            int n4 = 0;
            while (n4 < n2) {
                block15: {
                    Expression expression;
                    block14: {
                        expression = this.expressions[n4];
                        if (expression.constant == Constant.NotAConstant) break block14;
                        switch (n3) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 10: {
                                if (expression.constant.longValue() != 0L) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n4);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n3, false);
                                    break;
                                }
                                break block15;
                            }
                            case 8: 
                            case 9: {
                                double d = expression.constant.doubleValue();
                                if (d == -0.0 || d != 0.0) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n4);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n3, false);
                                    break;
                                }
                                break block15;
                            }
                            case 5: {
                                if (expression.constant.booleanValue()) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n4);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n3, false);
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                if (!(expression instanceof NullLiteral)) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n4);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n3, false);
                                    break;
                                }
                                break block15;
                            }
                        }
                        break block15;
                    }
                    if (!(expression instanceof NullLiteral)) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(n4);
                        expression.generateCode(blockScope, codeStream, true);
                        codeStream.arrayAtPut(n3, false);
                    }
                }
                ++n4;
            }
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('{');
        if (this.expressions != null) {
            int n2 = 20;
            int n3 = 0;
            while (n3 < this.expressions.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.expressions[n3].printExpression(0, stringBuffer);
                if (--n2 == 0) {
                    stringBuffer.append('\n');
                    ArrayInitializer.printIndent(n + 1, stringBuffer);
                    n2 = 20;
                }
                ++n3;
            }
        }
        return stringBuffer.append('}');
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        this.constant = Constant.NotAConstant;
        if (typeBinding instanceof ArrayBinding) {
            TypeBinding typeBinding2;
            if ((this.bits & 1) == 0 && !(typeBinding2 = typeBinding.leafComponentType()).isReifiable()) {
                blockScope.problemReporter().illegalGenericArray(typeBinding2, this);
            }
            this.binding = (ArrayBinding)typeBinding;
            this.resolvedType = this.binding;
            if (this.expressions == null) {
                return this.binding;
            }
            typeBinding2 = this.binding.elementsType();
            int n = 0;
            int n2 = this.expressions.length;
            while (n < n2) {
                TypeBinding typeBinding3;
                Expression expression = this.expressions[n];
                expression.setExpectedType(typeBinding2);
                TypeBinding typeBinding4 = typeBinding3 = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(blockScope, typeBinding2) : expression.resolveType(blockScope);
                if (typeBinding3 == null) {
                    return null;
                }
                if (typeBinding2 != typeBinding3) {
                    blockScope.compilationUnitScope().recordTypeConversion(typeBinding2, typeBinding3);
                }
                if (expression.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding2) || typeBinding2.isBaseType() && BaseTypeBinding.isWidening(typeBinding2.id, typeBinding3.id) || typeBinding3.isCompatibleWith(typeBinding2)) {
                    expression.computeConversion(blockScope, typeBinding2, typeBinding3);
                } else if (blockScope.isBoxingCompatibleWith(typeBinding3, typeBinding2) || typeBinding3.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding2.isBaseType() && expression.isConstantValueOfTypeAssignableToType(typeBinding3, blockScope.environment().computeBoxingType(typeBinding2))) {
                    expression.computeConversion(blockScope, typeBinding2, typeBinding3);
                } else {
                    blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding2, expression);
                    return null;
                }
                ++n;
            }
            return this.binding;
        }
        TypeBinding typeBinding5 = null;
        int n = 1;
        if (this.expressions == null) {
            typeBinding5 = blockScope.getJavaLangObject();
        } else {
            Expression expression = this.expressions[0];
            while (expression != null && expression instanceof ArrayInitializer) {
                ++n;
                Expression[] expressionArray = ((ArrayInitializer)expression).expressions;
                if (expressionArray == null) {
                    typeBinding5 = blockScope.getJavaLangObject();
                    expression = null;
                    break;
                }
                expression = ((ArrayInitializer)expression).expressions[0];
            }
            if (expression != null) {
                typeBinding5 = expression.resolveType(blockScope);
            }
            int n3 = 1;
            int n4 = this.expressions.length;
            while (n3 < n4) {
                expression = this.expressions[n3];
                if (expression != null) {
                    expression.resolveType(blockScope);
                }
                ++n3;
            }
        }
        if (typeBinding5 != null) {
            this.resolvedType = blockScope.createArrayType(typeBinding5, n);
            if (typeBinding != null) {
                blockScope.problemReporter().typeMismatchError(this.resolvedType, typeBinding, this);
            }
        }
        return null;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expressions != null) {
            int n = this.expressions.length;
            int n2 = 0;
            while (n2 < n) {
                this.expressions[n2].traverse(aSTVisitor, blockScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

