/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.List;
import java.util.Vector;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Bem
extends ObjetoNegocio {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoBens());
    private Codigo pais = new Codigo(this, "Localiza\u00e7\u00e3o(Pa\u00eds)", CadastroTabelasIRPF.recuperarPaises());
    private Alfa discriminacao = new Alfa(this, "Discrimina\u00e7\u00e3o", 510);
    private Valor valorExercicioAnterior = new Valor(this, NOME_CAMPO_VALOR_ANTERIOR);
    private Valor valorExercicioAtual = new Valor(this, NOME_CAMPO_VALOR_ATUAL);
    private Alfa logradouro = new Alfa(this, "Logradouro", 40);
    private Alfa numero = new Alfa(this, "N\u00famero", 6);
    private Alfa complemento = new Alfa(this, "N\u00famero", 40);
    private Alfa bairro = new Alfa(this, "Bairro", 40);
    private Codigo uf = new Codigo(this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo(this, "Munic\u00edpio", new Vector());
    private Alfa nomeMunicipio = new Alfa(this, "Munic\u00edpio", 40);
    private Alfa cidade = new Alfa(this, "Cidade", 40);
    private CEP cep = new CEP(this, "CEP");
    private Alfa registrado = new Alfa(this, "Registrado", 1);
    private Alfa matricula = new Alfa(this, "Matr\u00edcula", 40);
    private Valor areaTotal = new Valor(this, "\u00c1rea Total");
    private Alfa unidade = new Alfa(this, "Unidade da \u00c1rea", 1);
    private Alfa nomeCartorio = new Alfa(this, "Nome do Cart\u00f3rio", 60);
    private Data dataAquisicao = new Data(this, "Data de aquisi\u00e7\u00e3o");
    private Alfa IPTU = new Alfa(this, "N\u00famero do IPTU", 30);
    private Alfa NIRF = new Alfa(this, "N\u00famero do NIRF", 8);
    private Alfa Renavan = new Alfa(this, "N\u00famero do RENAVAN", 30);
    private Alfa RegAviaCivil = new Alfa(this, "N\u00famero do Registro na Avia\u00e7\u00e3o Civil", 30);
    private Alfa RegCapPortos = new Alfa(this, "N\u00famero do Registro na Capitania de Portos", 30);
    private Codigo banco = new Codigo(this, "Banco", CadastroTabelasIRPF.recuperarBancos());
    private Alfa agencia = new Alfa(this, "N\u00famero da Ag\u00eancia Banc\u00e1ria", 4);
    private Alfa conta = new Alfa(this, "N\u00famero da Conta Banc\u00e1ria", 13);
    private Alfa contaDV = new Alfa(this, "D\u00edgito Verificador da Conta Banc\u00e1ria", 2);
    private NI CPFCNPJ = new NI(this, "CPF ou CNPJ do Benefici\u00e1rio");
    private CPF CPFTitDep = new CPF(this, "CPF do Titular ou do Dependente ao qual o registro se refere");
    private static final int[] requer_TD = new int[]{31, 32, 39, 41, 45, 53, 54, 59, 61, 69, 71, 72, 73, 74, 79, 95, 96, 97};
    public static final String BRASIL = "0";
    public static final String EXTERIOR = "1";

    public Bem(final DeclaracaoIRPF declaracaoIRPF) {
        final IdentificadorDeclaracao identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.getCodigo().setColunaFiltro(1);
        this.getPais().setColunaFiltro(1);
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_codigo")));
        this.getDiscriminacao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_discriminacao")));
        this.getPais().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_pais_branco")));
        this.getPais().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Bem.this.getPais().getConteudoFormatado().equals("105") ? Bem.this.getCodigo().getConteudoAtual(0).equals("62") : Bem.this.getCodigo().getConteudoAtual(0).equals("61")) {
                    return new RetornoValidacao(tab.msg("bem_pais_imcompativel"), 3);
                }
                return null;
            }
        });
        this.getCPFCNPJ().addValidador(new ValidadorNI(3));
        this.getCPFTitDep().addValidador(new ValidadorDefault(3){

            private boolean requerTD(int n) {
                int[] nArray = requer_TD;
                int n2 = 0;
                int n3 = nArray.length - 1;
                while (n2 <= n3) {
                    int n4 = (n2 + n3) / 2;
                    int n5 = nArray[n4];
                    if (n5 == n) {
                        return true;
                    }
                    if (n5 < n) {
                        n2 = n4 + 1;
                        continue;
                    }
                    n3 = n4 - 1;
                }
                return false;
            }

            public RetornoValidacao validarImplementado() {
                CPF cPF = Bem.this.getCPFTitDep();
                boolean bl = this.requerTD(Bem.this.getCodigo().asInteger());
                if (cPF.asString().trim().length() > 0) {
                    if (!bl) {
                        return new RetornoValidacao(tab.msg("bem_dispensa_td"), 3);
                    }
                    if (identificadorDeclaracao.getCpf().asString().equals(cPF.asString())) {
                        return null;
                    }
                    if (declaracaoIRPF.getDependentes().getDependenteByCPF(cPF) == null) {
                        return new RetornoValidacao(tab.msg("bem_dependente_sem_ficha"), 3);
                    }
                } else if (bl) {
                    return new RetornoValidacao(tab.msg("bem_requer_td"), 3);
                }
                return null;
            }
        });
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Localiza\u00e7\u00e3o(Pa\u00eds)")) continue;
            return false;
        }
        return true;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public Alfa getCidade() {
        return this.cidade;
    }

    public CEP getCep() {
        return this.cep;
    }

    public Alfa getRegistrado() {
        return this.registrado;
    }

    public Alfa getMatricula() {
        return this.matricula;
    }

    public Valor getAreaTotal() {
        return this.areaTotal;
    }

    public Alfa getUnidade() {
        return this.unidade;
    }

    public Alfa getNomeCartorio() {
        return this.nomeCartorio;
    }

    public Data getDataAquisicao() {
        return this.dataAquisicao;
    }

    public Alfa getIPTU() {
        return this.IPTU;
    }

    public Alfa getNIRF() {
        return this.NIRF;
    }

    public Alfa getRenavan() {
        return this.Renavan;
    }

    public Alfa getRegAviaCivil() {
        return this.RegAviaCivil;
    }

    public Alfa getRegCapPortos() {
        return this.RegCapPortos;
    }

    public Codigo getBanco() {
        return this.banco;
    }

    public Alfa getAgencia() {
        return this.agencia;
    }

    public Alfa getConta() {
        return this.conta;
    }

    public Alfa getContaDV() {
        return this.contaDV;
    }

    public NI getCPFCNPJ() {
        return this.CPFCNPJ;
    }

    public CPF getCPFTitDep() {
        return this.CPFTitDep;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.pais);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        list.add(this.CPFCNPJ);
        list.add(this.CPFTitDep);
        return list;
    }

    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), this.tab.msg("bem_valor_nao_informado"), n);
            list.add(pendencia);
        }
        return list;
    }
}

