/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.IteratorColecaoPPGD;
import serpro.ppgd.negocio.ListIteratorColecaoPPGD;
import serpro.ppgd.negocio.util.LogPPGD;

public class ListaPPGD
implements List {
    private Vector implementacao = new Vector();
    private Colecao owner;

    public ListaPPGD(Colecao colecao) {
        this.owner = colecao;
    }

    private void objetoInserido(Object object) {
        this.owner.objetoInserido(object);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoInserido", "alterou", object);
        }
    }

    private void objetoARemover(Object object) {
        this.owner.objetoARemover(object);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoAremover", "alterou", object);
        }
    }

    private void objetoRemovido(Object object) {
        this.owner.objetoRemovido(object);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoRemovido", "alterou", object);
        }
    }

    private void verificaTipoInserido(Object object) {
        if (this.owner.getTipoItens() != null && !this.owner.getTipoItens().isInstance(object)) {
            String string = "Tentativa inv\u00e1lida de inser\u00e7\u00e3o do elemento " + object + " na cole\u00e7\u00e3o " + this.owner;
            LogPPGD.erro(string);
            throw new IllegalArgumentException(string);
        }
    }

    private void verificaTamanho(int n) {
        if (this.owner.getTamanho() != 0 && n >= this.owner.getTamanho()) {
            String string = "A cole\u00e7\u00e3o " + this.owner.getClass().getName() + "ultrapassou o tamanho limite de " + this.owner.getTamanho() + ", foi requerido o index " + n;
            LogPPGD.erro(string);
            throw new IllegalArgumentException(string);
        }
    }

    public void add(int n, Object object) {
        this.verificaTipoInserido(object);
        this.verificaTamanho(this.size());
        this.implementacao.add(n, object);
        this.objetoInserido(object);
    }

    @Override
    public boolean add(Object object) {
        this.verificaTipoInserido(object);
        this.verificaTamanho(this.size());
        if (this.implementacao.add(object)) {
            this.objetoInserido(object);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.verificaTipoInserido(iterator.next());
        }
        if (this.implementacao.addAll(collection)) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.objetoInserido(iterator.next());
            }
            return true;
        }
        return false;
    }

    public boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        if (collection.size() + this.size() > this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
        while (iterator.hasNext()) {
            this.verificaTipoInserido(iterator.next());
        }
        if (this.implementacao.addAll(n, collection)) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.objetoInserido(iterator.next());
            }
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        if (this.owner.getTamanho() > 0 && collection.size() + this.size() > this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
        while (iterator.hasNext()) {
            this.verificaTipoInserido(iterator.next());
        }
        if (this.implementacao.addAll(collection)) {
            if (bl) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.objetoInserido(iterator.next());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Iterator iterator = this.implementacao.iterator();
        while (iterator.hasNext()) {
            this.objetoARemover(iterator.next());
        }
        this.implementacao.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.implementacao.contains(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.implementacao.containsAll(collection);
    }

    public Object get(int n) {
        return this.implementacao.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.implementacao.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.implementacao.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new IteratorColecaoPPGD(this.implementacao.iterator(), this.owner);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.implementacao.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return new ListIteratorColecaoPPGD(this.implementacao.listIterator(), this.owner, this);
    }

    public ListIterator listIterator(int n) {
        return new ListIteratorColecaoPPGD(this.implementacao.listIterator(n), this.owner, this);
    }

    public Object remove(int n) {
        Object var2_2 = null;
        if (n >= 0 && n < this.implementacao.size()) {
            var2_2 = this.implementacao.get(n);
            this.objetoARemover(var2_2);
        }
        Object e = this.implementacao.remove(n);
        this.objetoRemovido(var2_2);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        if (this.implementacao.contains(object)) {
            this.objetoARemover(object);
            bl = this.implementacao.remove(object);
            this.objetoRemovido(object);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.implementacao.contains(e)) continue;
            this.objetoARemover(e);
        }
        bl = this.implementacao.removeAll(collection);
        if (bl) {
            for (Object e : collection) {
                if (!this.implementacao.contains(e)) continue;
                this.objetoRemovido(e);
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        for (Object e : this.implementacao) {
            if (collection.contains(e)) continue;
            this.objetoARemover(e);
        }
        boolean bl = this.implementacao.retainAll(collection);
        for (Object e : this.implementacao) {
            if (collection.contains(e)) continue;
            this.objetoRemovido(e);
        }
        return bl;
    }

    public Object set(int n, Object object) {
        this.verificaTipoInserido(object);
        this.verificaTamanho(n);
        Object var3_3 = null;
        if (n >= 0 && n < this.implementacao.size()) {
            var3_3 = this.implementacao.get(n);
            this.objetoARemover(var3_3);
        }
        Object object2 = this.implementacao.set(n, object);
        if (n >= 0 && n < this.implementacao.size()) {
            this.objetoRemovido(var3_3);
        }
        this.owner.objetoInserido(object);
        return object2;
    }

    @Override
    public int size() {
        return this.implementacao.size();
    }

    public List subList(int n, int n2) {
        return this.implementacao.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.implementacao.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.implementacao.toArray(objectArray);
    }
}

