/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDFormattedTextField;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditMascara
extends EditCampo {
    protected boolean retornaConteudoAposTeclaEsc = true;
    private static Alfa vazio = new Alfa("EditMascara");
    protected JFormattedTextField componente;
    private MaskFormatter formatador;
    private boolean sobrescreve = false;
    private String mascara;

    public EditMascara() {
        super(vazio);
    }

    public EditMascara(Informacao informacao) {
        super(informacao);
    }

    public EditMascara(Informacao informacao, int n) {
        super(informacao, n);
    }

    public void setMascara(String string) {
        try {
            this.mascara = string;
            if (this.formatador == null) {
                this.formatador = new MaskFormatter(this.mascara);
                this.componente.setFormatterFactory(new DefaultFormatterFactory(this.formatador));
            } else {
                this.formatador.setMask(string);
            }
            this.componente.setValue(null);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
        this.implementacaoPropertyChange(null);
    }

    public void setCaracteresValidos(String string) {
        this.formatador.setValidCharacters(string);
    }

    public void setCaracteresInvalidos(String string) {
        this.formatador.setInvalidCharacters(string);
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (this.componente == null) {
            this.componente = new PPGDFormattedTextField();
            this.setMascara(UtilitariosString.expandeString(this.d[0].width, "*"));
            this.componente.setHorizontalAlignment(0);
            this.componente.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (EditMascara.this.isSelecionaTextoOnFocusGained()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EditMascara.this.componente.selectAll();
                            }
                        });
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() != null) {
                        EditMascara.this.setIdentificacaoFoco(false);
                        if (EditMascara.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || EditMascara.this.verificaValidacoesImpeditivas(EditMascara.this.componente.getText())) {
                            EditMascara.this.setarCampo();
                            EditMascara.this.chamaValidacao();
                        }
                    }
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    EditMascara.this.trataEventoKeyTyped(keyEvent);
                }
            });
        }
        ((PPGDFormattedTextField)this.componente).setInformacao(this.getInformacao());
        this.setMascara(this.mascara);
        this.setTamanho(this.mascara.length());
        this.implementacaoPropertyChange(null);
    }

    @Override
    public void removeTransfereFocoEnter() {
        this.componente.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "Focus.nextComponent");
        this.componente.getActionMap().put("Focus.nextComponent", null);
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = this.campo.asString();
        String string2 = UtilitariosString.retornaComMascara(string, this.getFormatador().getMask());
        if (string.trim().equals("")) {
            ((PPGDFormattedTextField)this.componente).setText(string2);
            ((PPGDFormattedTextField)this.componente).setValue(null);
        } else {
            ((PPGDFormattedTextField)this.componente).setText(string2);
        }
        this.componente.setCaretPosition(0);
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.componente;
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        if (bl) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        this.componente.setEnabled(bl);
        this.labelCampo.setEnabled(bl);
    }

    public void setarCampo() {
        String string = this.componente.getText();
        String string2 = UtilitariosString.retiraMascara(string, this.formatador.getMask());
        if (string.length() > this.d[0].width) {
            string = string.substring(0, this.d[0].width);
        }
        this.getInformacao().setConteudo(string2);
    }

    public String getConteudoComMascara() {
        String string = UtilitariosString.retiraMascara(this.getInformacao().getConteudoFormatado());
        return UtilitariosString.retornaComMascara(string, this.formatador.getMask());
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public boolean isSobrescreve() {
        return this.sobrescreve;
    }

    public void setSobrescreve(boolean bl) {
        this.sobrescreve = bl;
    }

    public MaskFormatter getFormatador() {
        return this.formatador;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
        this.isPerdeFocoComEnter = bl;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }

    public boolean isRetornaConteudoAposTeclaEsc() {
        return this.retornaConteudoAposTeclaEsc;
    }

    public void setRetornaConteudoAposTeclaEsc(boolean bl) {
        this.retornaConteudoAposTeclaEsc = bl;
    }

    public String getMascara() {
        return this.mascara;
    }

    protected void trataEventoKeyTyped(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\b' || keyEvent.getKeyChar() == '\u007f' || keyEvent.getKeyChar() == '%' || keyEvent.getKeyChar() == '\'';
        if (this.getFormatador().getValidCharacters() != null && this.getFormatador().getValidCharacters().indexOf(" ") == -1 && keyEvent.getKeyChar() == ' ') {
            keyEvent.setKeyChar('\uffff');
            keyEvent.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
        } else if (!bl) {
            char c = keyEvent.getKeyChar();
            boolean bl3 = c != '\t' && c != '\n' && c != '\b' && c != '\u007f' && c != '%' && c != '\'';
            int n = this.componente.getText().trim().length();
            if (this.sobrescreve && this.componente.getCaret().getDot() <= this.d[0].width && bl3 && n >= this.d[0].width && this.componente.getSelectedText() == null) {
                this.componente.select(this.componente.getCaret().getDot(), this.componente.getCaret().getDot() + 1);
            }
            if (n >= this.d[0].width && bl3 && this.componente.getSelectedText() == null) {
                keyEvent.setKeyChar('\uffff');
                keyEvent.consume();
                UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
            }
        }
    }
}

