/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;

public class CampoTXT {
    private String fNome;
    private String fTipo;
    private String fConteudo;
    private int fTamanho;
    private int fDecimais;
    private boolean fAutomatico;
    private String atributoObjetoNegocio = null;

    public CampoTXT(String string, String string2) throws GeracaoTxtException {
        int n = 0;
        String string3 = "CcAaNnIiDd";
        this.fNome = string;
        this.fTamanho = 0;
        if (string3.indexOf(string2.charAt(0)) != -1) {
            // empty if block
        }
        this.fTipo = string2.substring(0, 1);
        if (this.fTipo.equals("I")) {
            this.fTamanho = 1;
        } else if (this.fTipo.equals("C") || this.fTipo.equals("A")) {
            this.fTamanho = Integer.parseInt(string2.substring(1, string2.length()));
        } else if (this.fTipo.equals("N")) {
            int n2 = string2.indexOf(",");
            if (n2 < 0) {
                n2 = string2.length();
            } else {
                n = Integer.parseInt(string2.substring(n2 + 1, string2.length()));
            }
            String string4 = string2.substring(1, n2);
            this.fTamanho = Integer.parseInt(string4);
            if (n > this.fTamanho) {
                throw new GeracaoTxtException("Erro de layout - Campo " + this.fNome + " com n\u00famero de decimais maior que tamanho.");
            }
            this.fDecimais = n;
        } else {
            this.fTamanho = 8;
        }
    }

    public CampoTXT(String string, String string2, boolean bl) throws GeracaoTxtException {
        this(string, string2);
        this.fAutomatico = bl;
    }

    private boolean getBoolean() {
        if ("SsNn10".indexOf(this.fConteudo) != -1) {
            // empty if block
        }
        return this.fConteudo.equals("S") || this.fConteudo.equals("1");
    }

    private int getInteger() {
        int n = 0;
        if (this.fTipo.equals("N")) {
            n = Integer.parseInt(this.fConteudo);
        } else if (this.fTipo.equals("C")) {
            if (this.fConteudo.trim().length() != 0) {
                // empty if block
            }
            n = Integer.parseInt(this.fConteudo);
        } else if (this.fTipo.equals("D")) {
            if (this.fConteudo.trim().length() != 0) {
                // empty if block
            }
            n = Integer.parseInt(this.fConteudo);
        } else if (this.fTipo.equals("I")) {
            n = this.fConteudo == "S" ? 1 : 0;
        }
        return n;
    }

    private String getString() {
        if (this.fConteudo == null) {
            return "";
        }
        return this.fConteudo;
    }

    private void setBoolean(boolean bl) {
        this.fConteudo = this.fTipo.equals("I") || this.fTipo.equals("C") ? (bl ? "S" : "N") : (bl ? "1" : "0");
    }

    private void setInteger(int n) throws GeracaoTxtException {
        String string;
        if (this.fTipo.equals("I")) {
            if (n == 1) {
                this.fConteudo = "S";
            } else if (n == 0) {
                this.fConteudo = "N";
            } else {
                throw new GeracaoTxtException("Erro atribuindo conte\u00fado a campo do tipo Indicador " + this.fNome + ".");
            }
        }
        if ((string = String.valueOf(n)).length() > this.fTamanho) {
            throw new GeracaoTxtException("Erro atribuindo conte\u00fado a campo do tipo Indicador " + this.fNome + ".");
        }
        this.fConteudo = string;
    }

    protected void setString(String string) throws GeracaoTxtException {
        String string2 = string.trim();
        if (this.fTipo.equals("D")) {
            while (string2.indexOf("/") > 0) {
                string2 = string2.substring(0, string2.indexOf("/")) + string2.substring(string2.indexOf("/") + 1);
            }
            if (string2.length() > this.fTamanho) {
                throw new GeracaoTxtException("Erro atribuindo conte\u00fado maior que o tamanho do campo " + this.fNome + ".");
            }
            this.fConteudo = string2;
        } else {
            if (string2.length() > this.fTamanho) {
                throw new GeracaoTxtException("Erro atribuindo conte\u00fado maior que o tamanho do campo " + this.fNome + ".");
            }
            if (this.fTipo.equals("C") || this.fTipo.equals("A")) {
                this.fConteudo = string2;
            } else if (this.fTipo.equals("N")) {
                if (string2.length() == 0) {
                    this.fConteudo = "0";
                    string2 = "0";
                }
                if (this.fDecimais == 0) {
                    try {
                        Long.parseLong(string2);
                        this.fConteudo = string2;
                    }
                    catch (Exception exception) {
                        throw new GeracaoTxtException("Erro atribuindo conte\u00fado inv\u00e1lido ao campo " + this.fNome + ".");
                    }
                } else {
                    if (this.fDecimais > 0 & string2.indexOf(".") > 0 && this.fDecimais < string2.substring(string2.indexOf(".") + 1).length()) {
                        throw new GeracaoTxtException("Quantidade de decimais maior que o permitido no campo " + this.fNome + ".");
                    }
                    Double.parseDouble(string2);
                    this.fConteudo = string2;
                }
            } else if (this.fTipo.equals("I")) {
                if (string2.length() > 1) {
                    string2 = string2.substring(0, 0);
                }
                if (string2.equalsIgnoreCase("S") || string2.equalsIgnoreCase("N")) {
                    this.fConteudo = string2.toUpperCase();
                } else if (string2.length() == 0) {
                    this.fConteudo = " ";
                }
            } else {
                throw new GeracaoTxtException("<html>Quantidade de decimais maior que o<br>definido para o campo " + this.fNome + ".</html>");
            }
        }
    }

    private String getTxt() throws GeracaoTxtException {
        String string = this.getString().trim();
        if (this.fTipo.equals("C") | this.fTipo.equals("I") | this.fTipo.equals("D") | this.fTipo.equals("A")) {
            if (string.length() > this.fTamanho) {
                string = string.substring(1, this.fTamanho);
            }
            while (string.length() < this.fTamanho) {
                string = string.concat(" ");
            }
        } else if (this.fTipo.equals("N")) {
            string.replaceAll("[,.]", "");
            int n = string.length();
            if (n > this.fTamanho + this.fDecimais) {
                throw new GeracaoTxtException("Erro atribuindo conte\u00fado (" + string + ") maior que o tamanho do campo " + this.fNome + ".");
            }
            while (string.length() < this.fTamanho) {
                string = "0".concat(string);
            }
            if (string.indexOf("-") >= 0) {
                string = string.replaceAll("-", "");
                string = "-".concat(string);
            }
        }
        return string;
    }

    private void setLogico(Logico logico) {
        this.fConteudo = logico.asString();
    }

    public boolean estaPreenchido() throws NumberFormatException, GeracaoTxtException {
        if (this.fAutomatico) {
            return false;
        }
        if (this.getString().length() == 0) {
            return false;
        }
        return !this.fTipo.equals("N") || Double.parseDouble(this.getTxt()) != 0.0;
    }

    public String getNome() {
        return this.fNome;
    }

    public String getTipo() {
        return this.fTipo;
    }

    public int getTamanho() {
        return this.fTamanho;
    }

    public int getDecimais() {
        return this.fDecimais;
    }

    public String asString() {
        return this.getString();
    }

    public boolean asBoolean() {
        return this.getBoolean();
    }

    public int asInteger() {
        return this.getInteger();
    }

    public Valor asValor() {
        Valor valor = new Valor();
        valor.setCasasDecimais(this.getDecimais());
        valor.setConteudo(new Long(this.asString()));
        return valor;
    }

    public String asTxt() throws GeracaoTxtException {
        return this.getTxt();
    }

    public void set(String string) throws GeracaoTxtException {
        this.setString(string);
    }

    public void setLimitado(String string) throws GeracaoTxtException {
        if (string.length() > this.getTamanho()) {
            string = string.substring(0, this.getTamanho());
        }
        this.setString(string);
    }

    public void set(boolean bl) {
        this.setBoolean(bl);
    }

    public void set(int n) throws GeracaoTxtException {
        this.setInteger(n);
    }

    public void set(Valor valor) throws GeracaoTxtException {
        boolean bl;
        Valor valor2 = valor;
        if (valor.getCasasDecimais() != this.getDecimais()) {
            valor2 = new Valor();
            valor2.setConteudo(valor);
            valor2.converteQtdCasasDecimais(this.getDecimais());
        }
        String string = valor2.asTxt();
        String string2 = "";
        int n = this.getTamanho();
        boolean bl2 = bl = valor.getConteudo() < 0L;
        if (bl) {
            --n;
            string = string.replaceAll("-", "");
        }
        if (string.length() < n) {
            for (int i = 0; i < n - string.length(); ++i) {
                string2 = string2 + "0";
            }
        }
        if (bl) {
            string2 = "-" + string2;
        }
        this.set(string2 + string);
    }

    public void set(Logico logico) {
        this.setLogico(logico);
    }

    public String getAtributoObjetoNegocio() {
        if (this.atributoObjetoNegocio == null) {
            this.atributoObjetoNegocio = "";
        }
        return this.atributoObjetoNegocio;
    }

    public void setAtributoObjetoNegocio(String string) {
        this.atributoObjetoNegocio = string;
    }

    public static void main(String[] stringArray) throws GeracaoTxtException {
    }
}

