/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.labels.ContourToolTipGenerator;
import org.jfree.data.contour.ContourDataset;

public class StandardContourToolTipGenerator
implements ContourToolTipGenerator,
Serializable {
    private static final long serialVersionUID = -1881659351247502711L;
    private DecimalFormat valueForm = new DecimalFormat("##.###");

    @Override
    public String generateToolTip(ContourDataset contourDataset, int n) {
        double d = contourDataset.getXValue(0, n);
        double d2 = contourDataset.getYValue(0, n);
        double d3 = contourDataset.getZValue(0, n);
        String string = null;
        if (contourDataset.isDateAxis(0)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = simpleDateFormat.format(new Date((long)d), stringBuffer, new FieldPosition(0));
            string = stringBuffer.toString();
        } else {
            string = this.valueForm.format(d);
        }
        if (!Double.isNaN(d3)) {
            return "X: " + string + ", Y: " + this.valueForm.format(d2) + ", Z: " + this.valueForm.format(d3);
        }
        return "X: " + string + ", Y: " + this.valueForm.format(d2) + ", Z: no data";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardContourToolTipGenerator)) {
            return false;
        }
        StandardContourToolTipGenerator standardContourToolTipGenerator = (StandardContourToolTipGenerator)object;
        if (this.valueForm != null) {
            return this.valueForm.equals(standardContourToolTipGenerator.valueForm);
        }
        return false;
    }
}

