/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.AbstractFilter;

public class ElementFilter
extends AbstractFilter {
    private static final String CVS_ID = "@(#) $RCSfile: ElementFilter.java,v $ $Revision: 1.18 $ $Date: 2004/09/07 06:37:20 $ $Name: jdom_1_0 $";
    private String name;
    private transient Namespace namespace;

    public ElementFilter() {
    }

    public ElementFilter(String string) {
        this.name = string;
    }

    public ElementFilter(Namespace namespace) {
        this.namespace = namespace;
    }

    public ElementFilter(String string, Namespace namespace) {
        this.name = string;
        this.namespace = namespace;
    }

    @Override
    public boolean matches(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            return !(this.name != null && !this.name.equals(element.getName()) || this.namespace != null && !this.namespace.equals(element.getNamespace()));
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElementFilter)) {
            return false;
        }
        ElementFilter elementFilter = (ElementFilter)object;
        if (this.name != null ? !this.name.equals(elementFilter.name) : elementFilter.name != null) {
            return false;
        }
        return !(this.namespace != null ? !this.namespace.equals(elementFilter.namespace) : elementFilter.namespace != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 29 * n + (this.namespace != null ? this.namespace.hashCode() : 0);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
    }
}

