/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UpdatedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public abstract class Scope
implements TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public int kind;
    public Scope parent;

    public static int compareTypes(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding.isCompatibleWith(typeBinding2)) {
            return -1;
        }
        if (typeBinding2.isCompatibleWith(typeBinding)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding getBaseType(char[] cArray) {
        int n = cArray.length;
        if (n > 2 && n < 8) {
            switch (cArray[0]) {
                case 'i': {
                    if (n != 3 || cArray[1] != 'n' || cArray[2] != 't') break;
                    return TypeBinding.INT;
                }
                case 'v': {
                    if (n != 4 || cArray[1] != 'o' || cArray[2] != 'i' || cArray[3] != 'd') break;
                    return TypeBinding.VOID;
                }
                case 'b': {
                    if (n == 7 && cArray[1] == 'o' && cArray[2] == 'o' && cArray[3] == 'l' && cArray[4] == 'e' && cArray[5] == 'a' && cArray[6] == 'n') {
                        return TypeBinding.BOOLEAN;
                    }
                    if (n != 4 || cArray[1] != 'y' || cArray[2] != 't' || cArray[3] != 'e') break;
                    return TypeBinding.BYTE;
                }
                case 'c': {
                    if (n != 4 || cArray[1] != 'h' || cArray[2] != 'a' || cArray[3] != 'r') break;
                    return TypeBinding.CHAR;
                }
                case 'd': {
                    if (n != 6 || cArray[1] != 'o' || cArray[2] != 'u' || cArray[3] != 'b' || cArray[4] != 'l' || cArray[5] != 'e') break;
                    return TypeBinding.DOUBLE;
                }
                case 'f': {
                    if (n != 5 || cArray[1] != 'l' || cArray[2] != 'o' || cArray[3] != 'a' || cArray[4] != 't') break;
                    return TypeBinding.FLOAT;
                }
                case 'l': {
                    if (n != 4 || cArray[1] != 'o' || cArray[2] != 'n' || cArray[3] != 'g') break;
                    return TypeBinding.LONG;
                }
                case 's': {
                    if (n != 5 || cArray[1] != 'h' || cArray[2] != 'o' || cArray[3] != 'r' || cArray[4] != 't') break;
                    return TypeBinding.SHORT;
                }
            }
        }
        return null;
    }

    public static ReferenceBinding[] greaterLowerBound(ReferenceBinding[] referenceBindingArray) {
        ReferenceBinding referenceBinding;
        int n;
        if (referenceBindingArray == null) {
            return null;
        }
        int n2 = referenceBindingArray.length;
        if (n2 == 0) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ReferenceBinding referenceBinding2 = referenceBindingArray2[i];
            if (referenceBinding2 == null) continue;
            for (n = 0; n < n2; ++n) {
                if (i == n || (referenceBinding = referenceBindingArray2[n]) == null || !referenceBinding2.isCompatibleWith(referenceBinding)) continue;
                if (referenceBindingArray2 == referenceBindingArray) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n2];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 0, n2);
                }
                referenceBindingArray2[n] = null;
                ++n3;
            }
        }
        if (n3 == 0) {
            return referenceBindingArray2;
        }
        if (n2 == n3) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray4 = new ReferenceBinding[n2 - n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            referenceBinding = referenceBindingArray2[i];
            if (referenceBinding == null) continue;
            referenceBindingArray4[n++] = referenceBinding;
        }
        return referenceBindingArray4;
    }

    public static TypeBinding[] greaterLowerBound(TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding;
        int n;
        if (typeBindingArray == null) {
            return null;
        }
        int n2 = typeBindingArray.length;
        if (n2 == 0) {
            return null;
        }
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding2 = typeBindingArray2[i];
            if (typeBinding2 == null) continue;
            for (n = 0; n < n2; ++n) {
                if (i == n || (typeBinding = typeBindingArray2[n]) == null || !typeBinding2.isCompatibleWith(typeBinding)) continue;
                if (typeBindingArray2 == typeBindingArray) {
                    TypeBinding[] typeBindingArray3 = typeBindingArray2;
                    typeBindingArray2 = new TypeBinding[n2];
                    System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
                }
                typeBindingArray2[n] = null;
                ++n3;
            }
        }
        if (n3 == 0) {
            return typeBindingArray2;
        }
        if (n2 == n3) {
            return null;
        }
        TypeBinding[] typeBindingArray4 = new TypeBinding[n2 - n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            typeBinding = typeBindingArray2[i];
            if (typeBinding == null) continue;
            typeBindingArray4[n++] = typeBinding;
        }
        return typeBindingArray4;
    }

    public static ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] referenceBindingArray) {
        if (referenceBindingArray == null) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
        int n = referenceBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            ReferenceBinding referenceBinding2 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
            if (referenceBinding2 != referenceBinding) {
                if (referenceBindingArray2 == referenceBindingArray) {
                    referenceBindingArray2 = new ReferenceBinding[n];
                    System.arraycopy(referenceBindingArray, 0, referenceBindingArray2, 0, i);
                }
                referenceBindingArray2[i] = referenceBinding2;
                continue;
            }
            if (referenceBindingArray2 == referenceBindingArray) continue;
            referenceBindingArray2[i] = referenceBinding;
        }
        return referenceBindingArray2;
    }

    public static TypeBinding substitute(Substitution substitution, TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        switch (typeBinding.kind()) {
            case 4100: {
                return substitution.substitute((TypeVariableBinding)typeBinding);
            }
            case 260: {
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                ReferenceBinding referenceBinding2 = referenceBinding = typeBinding.enclosingType();
                if (referenceBinding != null) {
                    referenceBinding2 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                }
                TypeBinding[] typeBindingArray2 = typeBindingArray = parameterizedTypeBinding.arguments;
                if (typeBindingArray != null) {
                    if (substitution.isRawSubstitution()) {
                        return parameterizedTypeBinding.environment.createRawType(parameterizedTypeBinding.type, referenceBinding2);
                    }
                    typeBindingArray2 = Scope.substitute(substitution, typeBindingArray);
                }
                if (typeBindingArray2 == typeBindingArray && referenceBinding2 == referenceBinding) break;
                return parameterizedTypeBinding.environment.createParameterizedType(parameterizedTypeBinding.type, typeBindingArray2, referenceBinding2);
            }
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                TypeBinding typeBinding2 = arrayBinding.leafComponentType;
                TypeBinding typeBinding3 = Scope.substitute(substitution, typeBinding2);
                if (typeBinding3 == typeBinding2) break;
                return arrayBinding.environment.createArrayType(typeBinding3.leafComponentType(), typeBinding3.dimensions() + typeBinding.dimensions());
            }
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                if (wildcardBinding.boundKind == 0) break;
                TypeBinding typeBinding4 = wildcardBinding.bound;
                TypeBinding typeBinding5 = Scope.substitute(substitution, typeBinding4);
                TypeBinding[] typeBindingArray = wildcardBinding.otherBounds;
                TypeBinding[] typeBindingArray3 = Scope.substitute(substitution, typeBindingArray);
                if (typeBinding5 == typeBinding4 && typeBindingArray == typeBindingArray3) break;
                return wildcardBinding.environment.createWildcard(wildcardBinding.genericType, wildcardBinding.rank, typeBinding5, typeBindingArray3, wildcardBinding.boundKind);
            }
            case 4: {
                ReferenceBinding referenceBinding;
                if (!typeBinding.isMemberType()) break;
                ReferenceBinding referenceBinding3 = (ReferenceBinding)typeBinding;
                ReferenceBinding referenceBinding4 = referenceBinding = typeBinding.enclosingType();
                if (referenceBinding != null) {
                    referenceBinding4 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                }
                if (referenceBinding4 == referenceBinding) break;
                return substitution.isRawSubstitution() ? substitution.environment().createRawType(referenceBinding3, referenceBinding4) : substitution.environment().createParameterizedType(referenceBinding3, null, referenceBinding4);
            }
            case 2052: {
                ReferenceBinding referenceBinding;
                ReferenceBinding referenceBinding5 = (ReferenceBinding)typeBinding;
                ReferenceBinding referenceBinding6 = referenceBinding = typeBinding.enclosingType();
                if (referenceBinding != null) {
                    referenceBinding6 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                }
                if (substitution.isRawSubstitution()) {
                    return substitution.environment().createRawType(referenceBinding5, referenceBinding6);
                }
                TypeBinding[] typeBindingArray = referenceBinding5.typeVariables();
                TypeBinding[] typeBindingArray4 = Scope.substitute(substitution, typeBindingArray);
                return substitution.environment().createParameterizedType(referenceBinding5, typeBindingArray4, referenceBinding6);
            }
        }
        return typeBinding;
    }

    public static TypeBinding[] substitute(Substitution substitution, TypeBinding[] typeBindingArray) {
        if (typeBindingArray == null) {
            return null;
        }
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            TypeBinding typeBinding2 = Scope.substitute(substitution, typeBinding);
            if (typeBinding2 != typeBinding) {
                if (typeBindingArray2 == typeBindingArray) {
                    typeBindingArray2 = new TypeBinding[n];
                    System.arraycopy(typeBindingArray, 0, typeBindingArray2, 0, i);
                }
                typeBindingArray2[i] = typeBinding2;
                continue;
            }
            if (typeBindingArray2 == typeBindingArray) continue;
            typeBindingArray2[i] = typeBinding;
        }
        return typeBindingArray2;
    }

    protected Scope(int n, Scope scope) {
        this.kind = n;
        this.parent = scope;
    }

    public TypeBinding boxing(TypeBinding typeBinding) {
        if (typeBinding.isBaseType()) {
            return this.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public final ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope scope = null;
        Scope scope2 = this;
        do {
            scope = scope2;
        } while ((scope2 = scope2.parent) != null);
        return (CompilationUnitScope)scope;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        TypeBinding[] typeBindingArray2 = invocationSite.genericTypeArguments();
        TypeBinding[] typeBindingArray3 = methodBinding.parameters;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (typeBindingArray3 == typeBindingArray && (methodBinding.returnType.tagBits & 0x20000000L) == 0L && typeBindingArray2 == null && typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            return methodBinding;
        }
        int n = typeBindingArray.length;
        int n2 = typeBindingArray3.length;
        boolean bl = methodBinding.isVarargs();
        if (!(n == n2 || bl && n >= n2 - 1)) {
            return null;
        }
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            TypeBinding[] typeBindingArray4 = null;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding;
                TypeBinding typeBinding2 = typeBinding = i < n2 ? typeBindingArray3[i] : typeBindingArray3[n2 - 1];
                if (typeBindingArray[i].isBaseType() == typeBinding.isBaseType()) continue;
                if (typeBindingArray4 == null) {
                    typeBindingArray4 = new TypeBinding[n];
                    System.arraycopy(typeBindingArray, 0, typeBindingArray4, 0, n);
                }
                typeBindingArray4[i] = this.environment().computeBoxingType(typeBindingArray[i]);
            }
            if (typeBindingArray4 != null) {
                typeBindingArray = typeBindingArray4;
            }
            if ((methodBinding = ParameterizedGenericMethodBinding.computeCompatibleMethod(methodBinding, typeBindingArray, this, invocationSite)) == null) {
                return null;
            }
            if (!methodBinding.isValidBinding()) {
                return methodBinding;
            }
            typeBindingArray3 = methodBinding.parameters;
        } else if (typeBindingArray2 != null) {
            if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                if (!((ParameterizedGenericMethodBinding)methodBinding).wasInferred) {
                    return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 13);
                }
            } else {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 11);
            }
        }
        if (this.parameterCompatibilityLevel(methodBinding, typeBindingArray) > -1) {
            return methodBinding;
        }
        if (typeBindingArray2 != null) {
            return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray, 12);
        }
        return null;
    }

    protected boolean connectTypeVariables(TypeParameter[] typeParameterArray, boolean bl) {
        if (typeParameterArray == null || this.compilerOptions().sourceLevel < 0x310000L) {
            return true;
        }
        boolean bl2 = true;
        HashMap hashMap = new HashMap(2);
        block0: for (TypeParameter typeParameter : typeParameterArray) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding;
            TypeVariableBinding typeVariableBinding = typeParameter.binding;
            if (typeVariableBinding == null) {
                return false;
            }
            typeVariableBinding.superclass = this.getJavaLangObject();
            typeVariableBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
            typeVariableBinding.firstBound = null;
            TypeReference typeReference = typeParameter.type;
            if (typeReference == null) continue;
            TypeBinding typeBinding2 = typeBinding = this.kind == 2 ? typeReference.resolveType((BlockScope)this, false) : typeReference.resolveType((ClassScope)this);
            if (typeBinding == null) {
                typeVariableBinding.tagBits |= 0x20000L;
                bl2 = false;
                continue;
            }
            typeReference.resolvedType = typeBinding;
            if (typeBinding.isArrayType()) {
                this.problemReporter().boundCannotBeArray(typeReference, typeBinding);
                continue;
            }
            boolean bl3 = typeBinding.isTypeVariable();
            if (bl3) {
                referenceBinding = (TypeVariableBinding)typeBinding;
                if (((TypeVariableBinding)referenceBinding).rank >= typeVariableBinding.rank && ((TypeVariableBinding)referenceBinding).declaringElement == typeVariableBinding.declaringElement) {
                    this.problemReporter().forwardTypeVariableReference(typeParameter, (TypeVariableBinding)referenceBinding);
                    typeVariableBinding.tagBits |= 0x20000L;
                    bl2 = false;
                    continue;
                }
            }
            if ((referenceBinding = (ReferenceBinding)typeBinding).isFinal()) {
                this.problemReporter().finalVariableBound(typeVariableBinding, typeReference);
            }
            if (!typeBinding.isInterface()) {
                typeVariableBinding.superclass = referenceBinding;
            } else {
                typeVariableBinding.superInterfaces = new ReferenceBinding[]{referenceBinding};
            }
            typeVariableBinding.firstBound = referenceBinding;
            TypeReference[] typeReferenceArray = typeParameter.bounds;
            if (typeReferenceArray == null) continue;
            int n = typeReferenceArray.length;
            for (int i = 0; i < n; ++i) {
                typeReference = typeReferenceArray[i];
                TypeBinding typeBinding3 = typeBinding = this.kind == 2 ? typeReference.resolveType((BlockScope)this, false) : typeReference.resolveType((ClassScope)this);
                if (typeBinding == null) {
                    typeVariableBinding.tagBits |= 0x20000L;
                    bl2 = false;
                    continue block0;
                }
                typeReference.resolvedType = typeBinding;
                if (bl3 && i == 0) {
                    this.problemReporter().noAdditionalBoundAfterTypeVariable(typeReference);
                }
                if (typeBinding.isArrayType()) {
                    this.problemReporter().boundCannotBeArray(typeReference, typeBinding);
                    continue block0;
                }
                referenceBinding = (ReferenceBinding)typeBinding;
                if (!typeBinding.isInterface()) {
                    this.problemReporter().boundMustBeAnInterface(typeReference, typeBinding);
                    typeVariableBinding.tagBits |= 0x20000L;
                    bl2 = false;
                    continue block0;
                }
                if (bl && typeVariableBinding.firstBound == typeVariableBinding.superclass && this.hasErasedCandidatesCollisions(typeBinding, typeVariableBinding.superclass, hashMap, typeVariableBinding, typeReference)) {
                    bl2 = false;
                    continue block0;
                }
                int n2 = typeVariableBinding.superInterfaces.length;
                while (--n2 >= 0) {
                    ReferenceBinding referenceBinding2 = typeVariableBinding.superInterfaces[n2];
                    if (referenceBinding2 == referenceBinding) {
                        this.problemReporter().duplicateBounds(typeReference, typeBinding);
                        typeVariableBinding.tagBits |= 0x20000L;
                        bl2 = false;
                        continue block0;
                    }
                    if (!bl || !this.hasErasedCandidatesCollisions(typeBinding, referenceBinding2, hashMap, typeVariableBinding, typeReference)) continue;
                    bl2 = false;
                    continue block0;
                }
                n2 = typeVariableBinding.superInterfaces.length;
                typeVariableBinding.superInterfaces = new ReferenceBinding[n2 + 1];
                System.arraycopy(typeVariableBinding.superInterfaces, 0, typeVariableBinding.superInterfaces, 0, n2);
                typeVariableBinding.superInterfaces[n2] = referenceBinding;
            }
        }
        return bl2;
    }

    public ArrayBinding createArrayType(TypeBinding typeBinding, int n) {
        if (typeBinding.isValidBinding()) {
            return this.environment().createArrayType(typeBinding, n);
        }
        return new ArrayBinding(typeBinding, n, this.environment());
    }

    public TypeVariableBinding[] createTypeVariables(TypeParameter[] typeParameterArray, Binding binding) {
        if (typeParameterArray == null || this.compilerOptions().sourceLevel < 0x310000L) {
            return Binding.NO_TYPE_VARIABLES;
        }
        TypeVariableBinding[] typeVariableBindingArray = Binding.NO_TYPE_VARIABLES;
        PackageBinding packageBinding = this.compilationUnitScope().fPackage;
        int n = typeParameterArray.length;
        typeVariableBindingArray = new TypeVariableBinding[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TypeParameter typeParameter = typeParameterArray[i];
            TypeVariableBinding typeVariableBinding = new TypeVariableBinding(typeParameter.name, binding, i);
            typeVariableBinding.fPackage = packageBinding;
            typeParameter.binding = typeVariableBinding;
            for (int j = 0; j < n2; ++j) {
                TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray[j];
                if (!CharOperation.equals(typeVariableBinding2.sourceName, typeParameter.name)) continue;
                this.problemReporter().duplicateTypeParameterInType(typeParameter);
            }
            typeVariableBindingArray[n2++] = typeVariableBinding;
        }
        if (n2 != n) {
            TypeVariableBinding[] typeVariableBindingArray2 = typeVariableBindingArray;
            typeVariableBindingArray = new TypeVariableBinding[n2];
            System.arraycopy(typeVariableBindingArray2, 0, typeVariableBindingArray, 0, n2);
        }
        return typeVariableBindingArray;
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final ReferenceBinding enclosingReceiverType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return this.environment().convertToParameterizedType(((ClassScope)scope).referenceContext.binding);
        } while ((scope = scope.parent) != null);
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            switch (scope.kind) {
                case 2: {
                    return ((MethodScope)scope).referenceContext;
                }
                case 3: {
                    return ((ClassScope)scope).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)scope).referenceContext;
                }
            }
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        return ((CompilationUnitScope)scope2).environment;
    }

    protected MethodBinding findDefaultAbstractMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite, ReferenceBinding referenceBinding2, ObjectVector objectVector, MethodBinding methodBinding) {
        int n = objectVector.size;
        for (ReferenceBinding referenceBinding3 = referenceBinding2; referenceBinding3 != null; referenceBinding3 = referenceBinding3.superclass()) {
            this.findMethodInSuperInterfaces(referenceBinding3, cArray, objectVector);
        }
        MethodBinding[] methodBindingArray = null;
        int n2 = 0;
        MethodBinding methodBinding2 = null;
        int n3 = objectVector.size;
        if (n3 > n) {
            for (int i = n; i < n3; ++i) {
                MethodBinding methodBinding3 = (MethodBinding)objectVector.elementAt(i);
                MethodBinding methodBinding4 = this.computeCompatibleMethod(methodBinding3, typeBindingArray, invocationSite);
                if (methodBinding4 == null) continue;
                if (methodBinding4.isValidBinding()) {
                    if (n2 == 0) {
                        methodBindingArray = new MethodBinding[n3 - n + 1];
                        if (methodBinding != null) {
                            methodBindingArray[n2++] = methodBinding;
                        }
                    }
                    methodBindingArray[n2++] = methodBinding4;
                    continue;
                }
                if (methodBinding2 != null) continue;
                methodBinding2 = methodBinding4;
            }
        }
        if (n2 < 2) {
            if (methodBinding == null) {
                if (n2 == 0) {
                    return methodBinding2;
                }
                methodBinding = methodBindingArray[0];
            }
            this.compilationUnitScope().recordTypeReferences(methodBinding.thrownExceptions);
            return methodBinding;
        }
        if (this.compilerOptions().complianceLevel >= 0x300000L) {
            return this.mostSpecificMethodBinding(methodBindingArray, n2, typeBindingArray, invocationSite, referenceBinding);
        }
        return this.mostSpecificInterfaceMethodBinding(methodBindingArray, n2, invocationSite);
    }

    public ReferenceBinding findDirectMemberType(char[] cArray, ReferenceBinding referenceBinding) {
        if ((referenceBinding.tagBits & 0x10000L) != 0L) {
            return null;
        }
        ReferenceBinding referenceBinding2 = this.enclosingReceiverType();
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordReference(referenceBinding, cArray);
        ReferenceBinding referenceBinding3 = referenceBinding.getMemberType(cArray);
        if (referenceBinding3 != null) {
            compilationUnitScope.recordTypeReference(referenceBinding3);
            if (referenceBinding2 == null ? referenceBinding3.canBeSeenBy(this.getCurrentPackage()) : referenceBinding3.canBeSeenBy(referenceBinding, referenceBinding2)) {
                return referenceBinding3;
            }
            return new ProblemReferenceBinding(cArray, referenceBinding3, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordTypeReferences(typeBindingArray);
        MethodBinding methodBinding = referenceBinding.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
        if (methodBinding != null && methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && !methodBinding.isBridge()) {
            compilationUnitScope.recordTypeReferences(methodBinding.thrownExceptions);
            if (referenceBinding.isInterface() || methodBinding.canBeSeenBy(referenceBinding, invocationSite, this)) {
                if (referenceBinding.id != 1 && typeBindingArray == Binding.NO_PARAMETERS && CharOperation.equals(cArray, GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                    return ParameterizedMethodBinding.instantiateGetClass(referenceBinding, methodBinding, this);
                }
                if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES || invocationSite.genericTypeArguments() != null) {
                    MethodBinding methodBinding2 = this.computeCompatibleMethod(methodBinding, typeBindingArray, invocationSite);
                    if (!methodBinding2.isValidBinding() && methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        return null;
                    }
                    methodBinding = methodBinding2;
                }
                return methodBinding;
            }
        }
        return null;
    }

    public FieldBinding findField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite, boolean bl) {
        int n;
        Object object;
        int n2;
        Object object2;
        Binding binding;
        CompilationUnitScope compilationUnitScope;
        block31: {
            TypeBinding typeBinding2;
            compilationUnitScope = this.compilationUnitScope();
            compilationUnitScope.recordTypeReference(typeBinding);
            switch (typeBinding.kind()) {
                case 132: {
                    return null;
                }
                case 516: 
                case 4100: {
                    binding = typeBinding.erasure();
                    if (((TypeBinding)binding).isArrayType()) {
                        typeBinding2 = ((TypeBinding)binding).leafComponentType();
                        break;
                    }
                    break block31;
                }
                case 68: {
                    typeBinding2 = typeBinding.leafComponentType();
                    break;
                }
                default: {
                    break block31;
                }
            }
            if (typeBinding2 instanceof ReferenceBinding && !((ReferenceBinding)typeBinding2).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)typeBinding2, cArray, 8);
            }
            if (CharOperation.equals(cArray, LENGTH)) {
                return ArrayBinding.ArrayLength;
            }
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (!referenceBinding.canBeSeenBy(this)) {
            return new ProblemFieldBinding(referenceBinding, cArray, 8);
        }
        binding = referenceBinding.getField(cArray, bl);
        if (binding != null) {
            if (invocationSite == null ? ((FieldBinding)binding).canBeSeenBy(this.getCurrentPackage()) : ((FieldBinding)binding).canBeSeenBy(referenceBinding, invocationSite, this)) {
                return binding;
            }
            return new ProblemFieldBinding((FieldBinding)binding, ((FieldBinding)binding).declaringClass, cArray, 2);
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n3 = 0;
        Binding binding2 = null;
        boolean bl2 = true;
        Binding binding3 = null;
        while (bl2) {
            object2 = referenceBinding.superInterfaces();
            if (object2 == null) {
                ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchy();
                object2 = referenceBinding.superInterfaces();
            }
            if (object2 != null && object2 != Binding.NO_SUPERINTERFACES) {
                if (referenceBindingArray == null) {
                    referenceBindingArray = object2;
                    n3 = referenceBindingArray.length;
                } else {
                    n2 = ((ReferenceBinding[])object2).length;
                    if (n3 + n2 >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n3 + n2 + 5];
                        System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n3);
                    }
                    block6: for (int i = 0; i < n2; ++i) {
                        object = object2[i];
                        for (n = 0; n < n3; ++n) {
                            if (object == referenceBindingArray[n]) continue block6;
                        }
                        referenceBindingArray[n3++] = object;
                    }
                }
            }
            if ((referenceBinding = referenceBinding.superclass()) == null) break;
            compilationUnitScope.recordTypeReference(referenceBinding);
            binding = referenceBinding.getField(cArray, bl);
            if (binding == null) continue;
            bl2 = false;
            if (((FieldBinding)binding).canBeSeenBy(typeBinding, invocationSite, this)) {
                if (binding2 == null) {
                    binding2 = binding;
                    continue;
                }
                return new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, cArray, 3);
            }
            if (binding3 != null) continue;
            binding3 = binding;
        }
        if (referenceBindingArray != null) {
            object2 = null;
            for (n2 = 0; n2 < n3; ++n2) {
                void var15_18 = referenceBindingArray[n2];
                compilationUnitScope.recordTypeReference((TypeBinding)var15_18);
                binding = var15_18.getField(cArray, true);
                if (binding != null) {
                    if (binding2 == null) {
                        binding2 = binding;
                        continue;
                    }
                    object2 = new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, cArray, 3);
                    break;
                }
                object = var15_18.superInterfaces();
                if (object == null || object == Binding.NO_SUPERINTERFACES) continue;
                n = ((ReferenceBinding[])object).length;
                if (n3 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n3);
                }
                block9: for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding2 = object[i];
                    for (int j = 0; j < n3; ++j) {
                        if (referenceBinding2 == referenceBindingArray[j]) continue block9;
                    }
                    referenceBindingArray[n3++] = referenceBinding2;
                }
            }
            if (object2 != null) {
                return object2;
            }
        }
        if (binding2 != null) {
            return binding2;
        }
        if (binding3 != null) {
            return new ProblemFieldBinding((FieldBinding)binding3, referenceBinding, cArray, 2);
        }
        return null;
    }

    public ReferenceBinding findMemberType(char[] cArray, ReferenceBinding referenceBinding) {
        int n;
        Object object;
        Object object2;
        if ((referenceBinding.tagBits & 0x10000L) != 0L) {
            return null;
        }
        SourceTypeBinding sourceTypeBinding = this.enclosingSourceType();
        PackageBinding packageBinding = this.getCurrentPackage();
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordReference(referenceBinding, cArray);
        ReferenceBinding referenceBinding2 = referenceBinding.getMemberType(cArray);
        if (referenceBinding2 != null) {
            compilationUnitScope.recordTypeReference(referenceBinding2);
            if (sourceTypeBinding == null ? referenceBinding2.canBeSeenBy(packageBinding) : referenceBinding2.canBeSeenBy(referenceBinding, sourceTypeBinding)) {
                return referenceBinding2;
            }
            return new ProblemReferenceBinding(cArray, referenceBinding2, 2);
        }
        ReferenceBinding referenceBinding3 = referenceBinding;
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding4 = null;
        boolean bl = true;
        ReferenceBinding referenceBinding5 = null;
        while (bl) {
            object2 = referenceBinding3.superInterfaces();
            if (object2 == null) {
                ReferenceBinding referenceBinding6;
                ReferenceBinding referenceBinding7 = referenceBinding6 = referenceBinding3.isParameterizedType() ? ((ParameterizedTypeBinding)referenceBinding).type : referenceBinding3;
                if (referenceBinding6.isHierarchyBeingConnected()) {
                    return null;
                }
                ((SourceTypeBinding)referenceBinding6).scope.connectTypeHierarchy();
                object2 = referenceBinding3.superInterfaces();
            }
            if (object2 != null && object2 != Binding.NO_SUPERINTERFACES) {
                if (referenceBindingArray == null) {
                    referenceBindingArray = object2;
                    n2 = referenceBindingArray.length;
                } else {
                    int n3 = ((ReferenceBinding[])object2).length;
                    if (n2 + n3 >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                        System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
                    }
                    block1: for (int i = 0; i < n3; ++i) {
                        object = object2[i];
                        for (n = 0; n < n2; ++n) {
                            if (object == referenceBindingArray[n]) continue block1;
                        }
                        referenceBindingArray[n2++] = object;
                    }
                }
            }
            if ((referenceBinding3 = referenceBinding3.superclass()) == null) break;
            compilationUnitScope.recordReference(referenceBinding3, cArray);
            referenceBinding2 = referenceBinding3.getMemberType(cArray);
            if (referenceBinding2 == null) continue;
            compilationUnitScope.recordTypeReference(referenceBinding2);
            bl = false;
            if (sourceTypeBinding == null ? referenceBinding2.canBeSeenBy(packageBinding) : referenceBinding2.canBeSeenBy(referenceBinding, sourceTypeBinding)) {
                if (referenceBinding4 == null) {
                    referenceBinding4 = referenceBinding2;
                    continue;
                }
                return new ProblemReferenceBinding(cArray, null, 3);
            }
            referenceBinding5 = referenceBinding2;
        }
        if (referenceBindingArray != null) {
            object2 = null;
            for (int i = 0; i < n2; ++i) {
                void var15_19 = referenceBindingArray[i];
                compilationUnitScope.recordReference((ReferenceBinding)var15_19, cArray);
                referenceBinding2 = var15_19.getMemberType(cArray);
                if (referenceBinding2 != null) {
                    compilationUnitScope.recordTypeReference(referenceBinding2);
                    if (referenceBinding4 == null) {
                        referenceBinding4 = referenceBinding2;
                        continue;
                    }
                    object2 = new ProblemReferenceBinding(cArray, null, 3);
                    break;
                }
                object = var15_19.superInterfaces();
                if (object == null || object == Binding.NO_SUPERINTERFACES) continue;
                n = ((ReferenceBinding[])object).length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
                }
                block4: for (int j = 0; j < n; ++j) {
                    ReferenceBinding referenceBinding8 = object[j];
                    for (int k = 0; k < n2; ++k) {
                        if (referenceBinding8 == referenceBindingArray[k]) continue block4;
                    }
                    referenceBindingArray[n2++] = referenceBinding8;
                }
            }
            if (object2 != null) {
                return object2;
            }
        }
        if (referenceBinding4 != null) {
            return referenceBinding4;
        }
        if (referenceBinding5 != null) {
            return new ProblemReferenceBinding(cArray, referenceBinding5, 2);
        }
        return null;
    }

    public MethodBinding findMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        int n;
        int n2;
        long l;
        ReferenceBinding referenceBinding2 = referenceBinding;
        ObjectVector objectVector = new ObjectVector(3);
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordTypeReferences(typeBindingArray);
        if (referenceBinding2.isInterface()) {
            compilationUnitScope.recordTypeReference(referenceBinding2);
            Object[] objectArray = referenceBinding2.getMethods(cArray);
            if (objectArray.length > 0) {
                objectVector.addAll(objectArray);
            }
            this.findMethodInSuperInterfaces(referenceBinding2, cArray, objectVector);
            referenceBinding2 = this.getJavaLangObject();
        }
        boolean bl = (l = this.compilerOptions().complianceLevel) >= 0x300000L;
        boolean bl2 = l >= 0x310000L;
        ReferenceBinding referenceBinding3 = referenceBinding2;
        boolean bl3 = referenceBinding.isInterface();
        while (referenceBinding2 != null) {
            compilationUnitScope.recordTypeReference(referenceBinding2);
            Object[] objectArray = referenceBinding2.getMethods(cArray);
            int n3 = objectArray.length;
            if (n3 > 0) {
                if (bl && (bl3 || objectVector.size > 0)) {
                    int n4 = n3;
                    block1: for (n2 = 0; n2 < n4; ++n2) {
                        Object object = objectArray[n2];
                        if (object == null) continue;
                        if (bl3 && !((MethodBinding)object).isPublic()) {
                            --n3;
                            objectArray[n2] = null;
                            continue;
                        }
                        int n5 = objectVector.size;
                        for (int i = 0; i < n5; ++i) {
                            MethodBinding methodBinding = (MethodBinding)objectVector.elementAt(i);
                            if (!((MethodBinding)object).areParametersEqual(methodBinding)) continue;
                            if (bl2 && (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES && invocationSite.genericTypeArguments() == null || methodBinding.hasSubstitutedParameters() && !((MethodBinding)object).original().areParametersEqual(methodBinding.original()) || methodBinding.isBridge() && !((MethodBinding)object).isBridge())) continue block1;
                            --n3;
                            objectArray[n2] = null;
                            continue block1;
                        }
                    }
                }
                if (n3 > 0) {
                    if (objectArray.length == n3) {
                        objectVector.addAll(objectArray);
                    } else {
                        for (Object object : objectArray) {
                            if (object == null) continue;
                            objectVector.add(object);
                        }
                    }
                }
            }
            referenceBinding2 = referenceBinding2.superclass();
        }
        int n6 = objectVector.size;
        MethodBinding[] methodBindingArray = null;
        n2 = 0;
        MethodBinding methodBinding = null;
        if (n6 > 0) {
            for (int i = 0; i < n6; ++i) {
                MethodBinding methodBinding2 = (MethodBinding)objectVector.elementAt(i);
                MethodBinding methodBinding3 = this.computeCompatibleMethod(methodBinding2, typeBindingArray, invocationSite);
                if (methodBinding3 == null) continue;
                if (methodBinding3.isValidBinding()) {
                    if (n6 == 1 && methodBinding3.canBeSeenBy(referenceBinding, invocationSite, this)) {
                        if (bl && (referenceBinding.isAbstract() || referenceBinding.isTypeVariable())) {
                            return this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, methodBinding3);
                        }
                        compilationUnitScope.recordTypeReferences(methodBinding3.thrownExceptions);
                        return methodBinding3;
                    }
                    if (n2 == 0) {
                        methodBindingArray = new MethodBinding[n6];
                    }
                    methodBindingArray[n2++] = methodBinding3;
                    continue;
                }
                if (methodBinding != null) continue;
                methodBinding = methodBinding3;
            }
        }
        if (n2 == 0) {
            MethodBinding methodBinding4 = this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, null);
            if (methodBinding4 != null) {
                return methodBinding4;
            }
            if (objectVector.size == 0) {
                return null;
            }
            if (methodBinding != null) {
                return methodBinding;
            }
            int n7 = -1;
            MethodBinding methodBinding5 = (MethodBinding)objectVector.elementAt(0);
            int n8 = typeBindingArray.length;
            n6 = objectVector.size;
            for (int i = 0; i < n6; ++i) {
                int n9;
                int n10;
                MethodBinding methodBinding6 = (MethodBinding)objectVector.elementAt(i);
                TypeBinding[] typeBindingArray2 = methodBinding6.parameters;
                int n11 = typeBindingArray2.length;
                int n12 = 0;
                block6: for (n10 = 0; n10 < n8; ++n10) {
                    TypeBinding typeBinding = typeBindingArray[n10];
                    int n13 = n9 = n10 == 0 ? 0 : n10 - 1;
                    while (n9 < n11 && n9 < n10 + 1) {
                        if (typeBindingArray2[n9] == typeBinding) {
                            ++n12;
                            continue block6;
                        }
                        ++n9;
                    }
                }
                if (n12 < n7) continue;
                if (n12 == n7) {
                    n10 = n11 < n8 ? 2 * (n8 - n11) : n11 - n8;
                    int n14 = methodBinding5.parameters.length;
                    int n15 = n9 = n14 < n8 ? 2 * (n8 - n14) : n14 - n8;
                    if (n10 >= n9) continue;
                }
                n7 = n12;
                methodBinding5 = methodBinding6;
            }
            return new ProblemMethodBinding(methodBinding5, methodBinding5.selector, typeBindingArray, 1);
        }
        int n16 = 0;
        for (n = 0; n < n2; ++n) {
            void var20_37 = methodBindingArray[n];
            if (!var20_37.canBeSeenBy(referenceBinding, invocationSite, this)) continue;
            if (n16 != n) {
                methodBindingArray[n] = null;
                methodBindingArray[n16] = var20_37;
            }
            ++n16;
        }
        if (n16 == 1) {
            if (bl && (referenceBinding.isAbstract() || referenceBinding.isTypeVariable())) {
                return this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, (MethodBinding)methodBindingArray[0]);
            }
            compilationUnitScope.recordTypeReferences(methodBindingArray[0].thrownExceptions);
            return methodBindingArray[0];
        }
        if (n16 == 0) {
            MethodBinding methodBinding7 = this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, null);
            if (methodBinding7 != null) {
                return methodBinding7;
            }
            return new ProblemMethodBinding(methodBindingArray[0], methodBindingArray[0].selector, methodBindingArray[0].parameters, 2);
        }
        if (l <= 0x2F0000L) {
            ReferenceBinding referenceBinding4 = methodBindingArray[0].declaringClass;
            return !referenceBinding4.isInterface() ? this.mostSpecificClassMethodBinding(methodBindingArray, n16, invocationSite) : this.mostSpecificInterfaceMethodBinding(methodBindingArray, n16, invocationSite);
        }
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            for (n = 0; n < n16; ++n) {
                MethodBinding methodBinding8 = methodBindingArray[n];
                if (methodBinding8 instanceof ParameterizedGenericMethodBinding) {
                    methodBinding8 = ((ParameterizedGenericMethodBinding)methodBinding8).originalMethod;
                }
                if (!(methodBinding8 instanceof ParameterizedMethodBinding)) continue;
                for (int i = n + 1; i < n16; ++i) {
                    if (methodBinding8.declaringClass != methodBindingArray[i].declaringClass || !methodBinding8.areParametersEqual(methodBindingArray[i])) continue;
                    return new ProblemMethodBinding(methodBindingArray[n].selector, methodBindingArray[n].parameters, 3);
                }
            }
        }
        MethodBinding methodBinding9 = this.mostSpecificMethodBinding(methodBindingArray, n16, typeBindingArray, invocationSite, referenceBinding);
        if (bl2 && methodBinding9.isValidBinding() && this.parameterCompatibilityLevel(methodBinding9, typeBindingArray) > 0) {
            return this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, methodBinding9);
        }
        return methodBinding9;
    }

    public MethodBinding findMethodForArray(ArrayBinding arrayBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        TypeBinding typeBinding = arrayBinding.leafComponentType();
        if (typeBinding instanceof ReferenceBinding && !((ReferenceBinding)typeBinding).canBeSeenBy(this)) {
            return new ProblemMethodBinding(cArray, Binding.NO_PARAMETERS, (ReferenceBinding)typeBinding, 8);
        }
        ReferenceBinding referenceBinding = this.getJavaLangObject();
        MethodBinding methodBinding = referenceBinding.getExactMethod(cArray, typeBindingArray, null);
        if (methodBinding != null) {
            if (typeBindingArray == Binding.NO_PARAMETERS) {
                switch (cArray[0]) {
                    case 'c': {
                        if (!CharOperation.equals(cArray, CLONE)) break;
                        return new UpdatedMethodBinding(this.compilerOptions().targetJDK >= 0x300000L ? arrayBinding : referenceBinding, methodBinding.modifiers & 0xFFFFFFFB | 1, CLONE, methodBinding.returnType, typeBindingArray, null, referenceBinding);
                    }
                    case 'g': {
                        if (!CharOperation.equals(cArray, GETCLASS) || !methodBinding.returnType.isParameterizedType()) break;
                        return ParameterizedMethodBinding.instantiateGetClass(arrayBinding, methodBinding, this);
                    }
                }
            }
            if (methodBinding.canBeSeenBy(arrayBinding, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(referenceBinding, cArray, typeBindingArray, invocationSite)) == null) {
            return new ProblemMethodBinding(cArray, typeBindingArray, 1);
        }
        return methodBinding;
    }

    protected void findMethodInSuperInterfaces(ReferenceBinding referenceBinding, char[] cArray, ObjectVector objectVector) {
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
            ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
            int n = referenceBindingArray2.length;
            for (int i = 0; i < n; ++i) {
                referenceBinding = referenceBindingArray2[i];
                this.compilationUnitScope().recordTypeReference(referenceBinding);
                Object[] objectArray = referenceBinding.getMethods(cArray);
                if (objectArray.length > 0) {
                    objectVector.addAll(objectArray);
                }
                if ((referenceBindingArray = referenceBinding.superInterfaces()) == null || referenceBindingArray == Binding.NO_SUPERINTERFACES) continue;
                int n2 = referenceBindingArray.length;
                if (n + n2 >= referenceBindingArray2.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n + n2 + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 0, n);
                }
                block1: for (int j = 0; j < n2; ++j) {
                    ReferenceBinding referenceBinding2 = referenceBindingArray[j];
                    for (int k = 0; k < n; ++k) {
                        if (referenceBinding2 == referenceBindingArray2[k]) continue block1;
                    }
                    referenceBindingArray2[n++] = referenceBinding2;
                }
            }
        }
    }

    public ReferenceBinding findType(char[] cArray, PackageBinding packageBinding, PackageBinding packageBinding2) {
        this.compilationUnitScope().recordReference(packageBinding.compoundName, cArray);
        ReferenceBinding referenceBinding = packageBinding.getType(cArray);
        if (referenceBinding == null) {
            return null;
        }
        if (referenceBinding.isValidBinding() && packageBinding != packageBinding2 && !referenceBinding.canBeSeenBy(packageBinding2)) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 2);
        }
        return referenceBinding;
    }

    public LocalVariableBinding findVariable(char[] cArray) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] cArray, int n, InvocationSite invocationSite, boolean bl) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            Binding binding = null;
            Binding binding2 = null;
            if ((n & 3) != 0) {
                Binding binding3;
                ImportBinding[] importBindingArray;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                Binding binding4 = null;
                FieldBinding fieldBinding = null;
                Scope scope = this;
                int n2 = 0;
                int n3 = 0;
                ReferenceBinding referenceBinding = null;
                block27: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            importBindingArray = (MethodScope)scope;
                            bl2 |= importBindingArray.isStatic;
                            bl3 |= importBindingArray.isConstructorCall;
                            bl4 = importBindingArray.insideTypeAnnotation;
                        }
                        case 1: {
                            Object object;
                            LocalVariableBinding localVariableBinding = scope.findVariable(cArray);
                            if (localVariableBinding == null) break;
                            if (binding4 != null && binding4.isValidBinding()) {
                                object = new ProblemFieldBinding((FieldBinding)binding4, ((FieldBinding)binding4).declaringClass, cArray, 5);
                                return object;
                            }
                            if (n2 > 0) {
                                invocationSite.setDepth(n2);
                            }
                            object = localVariableBinding;
                            return object;
                        }
                        case 3: {
                            FieldBinding fieldBinding2;
                            Object object = (ClassScope)scope;
                            ReferenceBinding referenceBinding2 = ((Scope)object).enclosingReceiverType();
                            if (!bl4 && (fieldBinding2 = ((Scope)object).findField(referenceBinding2, cArray, invocationSite, bl)) != null) {
                                if (fieldBinding2.problemId() == 3) {
                                    if (binding4 != null && binding4.problemId() != 2) {
                                        binding3 = new ProblemFieldBinding((FieldBinding)binding4, ((FieldBinding)binding4).declaringClass, cArray, 5);
                                        return binding3;
                                    }
                                    binding3 = fieldBinding2;
                                    return binding3;
                                }
                                binding3 = null;
                                if (fieldBinding2.isValidBinding()) {
                                    if (!fieldBinding2.isStatic()) {
                                        if (bl3) {
                                            binding3 = new ProblemFieldBinding(fieldBinding2, fieldBinding2.declaringClass, cArray, 6);
                                        } else if (bl2) {
                                            binding3 = new ProblemFieldBinding(fieldBinding2, fieldBinding2.declaringClass, cArray, 7);
                                        }
                                    }
                                    if (referenceBinding2 == fieldBinding2.declaringClass || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (binding4 == null) {
                                            if (n2 > 0) {
                                                invocationSite.setDepth(n2);
                                                invocationSite.setActualReceiverType(referenceBinding2);
                                            }
                                            FieldBinding fieldBinding3 = binding3 == null ? fieldBinding2 : binding3;
                                            return fieldBinding3;
                                        }
                                        if (binding4.isValidBinding() && ((FieldBinding)binding4).declaringClass != fieldBinding2.declaringClass) {
                                            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)binding4, ((FieldBinding)binding4).declaringClass, cArray, 5);
                                            return problemFieldBinding;
                                        }
                                    }
                                }
                                if (binding4 == null || binding4.problemId() == 2 && fieldBinding2.problemId() != 2) {
                                    n3 = n2;
                                    referenceBinding = referenceBinding2;
                                    fieldBinding = binding3;
                                    binding4 = fieldBinding2;
                                }
                            }
                            bl4 = false;
                            ++n2;
                            bl2 |= referenceBinding2.isStatic();
                            MethodScope methodScope = scope.methodScope();
                            bl3 = methodScope == null ? false : methodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block27;
                        }
                    }
                    scope = scope.parent;
                }
                if (fieldBinding != null) {
                    importBindingArray = fieldBinding;
                    return importBindingArray;
                }
                if (binding4 != null) {
                    if (binding4.isValidBinding()) {
                        if (n3 > 0) {
                            invocationSite.setDepth(n3);
                            invocationSite.setActualReceiverType(referenceBinding);
                        }
                        importBindingArray = binding4;
                        return importBindingArray;
                    }
                    binding2 = binding4;
                    binding4 = null;
                }
                if (this.compilerOptions().sourceLevel >= 0x310000L && (importBindingArray = compilationUnitScope.imports) != null) {
                    for (ImportBinding importBinding : importBindingArray) {
                        if (!importBinding.isStatic() || importBinding.onDemand || !CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], cArray) || compilationUnitScope.resolveSingleImport(importBinding) == null || !(importBinding.resolvedImport instanceof FieldBinding)) continue;
                        binding4 = (FieldBinding)importBinding.resolvedImport;
                        ImportReference importReference = importBinding.reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        invocationSite.setActualReceiverType(((FieldBinding)binding4).declaringClass);
                        if (binding4.isValidBinding()) {
                            binding3 = binding4;
                            return binding3;
                        }
                        if (binding2 != null) continue;
                        binding2 = binding4;
                    }
                    int n4 = 0;
                    for (ImportBinding importBinding : importBindingArray) {
                        FieldBinding fieldBinding4;
                        if (!importBinding.isStatic() || !importBinding.onDemand || !((binding3 = importBinding.resolvedImport) instanceof ReferenceBinding) || (fieldBinding4 = this.findField((ReferenceBinding)binding3, cArray, invocationSite, bl)) == null) continue;
                        if (!fieldBinding4.isValidBinding()) {
                            if (binding2 != null) continue;
                            binding2 = fieldBinding4;
                            continue;
                        }
                        if (!fieldBinding4.isStatic() || binding4 == fieldBinding4) continue;
                        ImportReference importReference = importBinding.reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        if (n4 != 0) {
                            ProblemReferenceBinding problemReferenceBinding = new ProblemReferenceBinding(cArray, null, 3);
                            return problemReferenceBinding;
                        }
                        binding4 = fieldBinding4;
                        n4 = 1;
                    }
                    if (binding4 != null) {
                        invocationSite.setActualReceiverType(((FieldBinding)binding4).declaringClass);
                        Binding binding5 = binding4;
                        return binding5;
                    }
                }
            }
            if ((n & 4) != 0) {
                binding = Scope.getBaseType(cArray);
                if (binding != null) {
                    TypeBinding typeBinding = binding;
                    return typeBinding;
                }
                binding = this.getTypeOrPackage(cArray, (n & 0x10) == 0 ? 4 : 20);
                if (binding.isValidBinding() || n == 4) {
                    Binding binding6 = binding;
                    return binding6;
                }
            } else if ((n & 0x10) != 0) {
                compilationUnitScope.recordSimpleReference(cArray);
                binding = lookupEnvironment.getTopLevelPackage(cArray);
                if (binding != null) {
                    Binding binding7 = binding;
                    return binding7;
                }
            }
            if (binding2 != null) {
                Binding binding8 = binding2;
                return binding8;
            }
            if (binding != null && binding.problemId() != 1) {
                Binding binding9 = binding;
                return binding9;
            }
            ProblemBinding problemBinding = new ProblemBinding(cArray, (ReferenceBinding)this.enclosingSourceType(), 1);
            return problemBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public MethodBinding getConstructor(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            compilationUnitScope.recordTypeReference(referenceBinding);
            compilationUnitScope.recordTypeReferences(typeBindingArray);
            MethodBinding methodBinding = referenceBinding.getExactConstructor(typeBindingArray);
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, typeBindingArray, invocationSite);
                }
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(TypeConstants.INIT);
            if (methodBindingArray == Binding.NO_METHODS) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(TypeConstants.INIT, typeBindingArray, 1);
                return problemMethodBinding;
            }
            MethodBinding[] methodBindingArray2 = new MethodBinding[methodBindingArray.length];
            int n = 0;
            MethodBinding methodBinding3 = null;
            int n2 = methodBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                MethodBinding methodBinding4 = this.computeCompatibleMethod(methodBindingArray[i], typeBindingArray, invocationSite);
                if (methodBinding4 == null) continue;
                if (methodBinding4.isValidBinding()) {
                    methodBindingArray2[n++] = methodBinding4;
                    continue;
                }
                if (methodBinding3 != null) continue;
                methodBinding3 = methodBinding4;
            }
            if (n == 0) {
                if (methodBinding3 == null) {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(TypeConstants.INIT, typeBindingArray, 1);
                    return problemMethodBinding;
                }
                MethodBinding methodBinding5 = methodBinding3;
                return methodBinding5;
            }
            MethodBinding[] methodBindingArray3 = new MethodBinding[n];
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                MethodBinding methodBinding6 = methodBindingArray2[i];
                if (!methodBinding6.canBeSeenBy(invocationSite, this)) continue;
                methodBindingArray3[n2++] = methodBinding6;
            }
            if (n2 == 1) {
                MethodBinding methodBinding7 = methodBindingArray3[0];
                return methodBinding7;
            }
            if (n2 == 0) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(methodBindingArray2[0], TypeConstants.INIT, methodBindingArray2[0].parameters, 2);
                return problemMethodBinding;
            }
            MethodBinding methodBinding8 = this.mostSpecificMethodBinding(methodBindingArray3, n2, typeBindingArray, invocationSite, referenceBinding);
            return methodBinding8;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        return ((CompilationUnitScope)scope2).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (methodBinding == null) break;
                    return methodBinding.modifiers;
                }
                SourceTypeBinding sourceTypeBinding = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (sourceTypeBinding == null) break;
                return sourceTypeBinding.modifiers;
            }
            case 3: {
                SourceTypeBinding sourceTypeBinding = ((ClassScope)this).referenceType().binding;
                if (sourceTypeBinding == null) break;
                return sourceTypeBinding.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite) {
        LookupEnvironment lookupEnvironment = this.environment();
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            FieldBinding fieldBinding = this.findField(typeBinding, cArray, invocationSite, true);
            if (fieldBinding != null) {
                FieldBinding fieldBinding2 = fieldBinding;
                return fieldBinding2;
            }
            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding(typeBinding instanceof ReferenceBinding ? (ReferenceBinding)typeBinding : null, cArray, 1);
            return problemFieldBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public MethodBinding getImplicitMethod(char[] var1_1, TypeBinding[] var2_2, InvocationSite var3_3) {
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = null;
        var8_8 = null;
        var9_9 = this;
        var10_10 = 0;
        block5: while (true) {
            switch (var9_9.kind) {
                case 2: {
                    var11_11 = (MethodScope)var9_9;
                    var4_4 |= var11_11.isStatic;
                    var5_5 |= var11_11.isConstructorCall;
                    var6_6 = var11_11.insideTypeAnnotation;
                    ** GOTO lbl58
                }
                case 3: {
                    var12_12 = (ImportBinding[])var9_9;
                    var13_13 = var12_12.enclosingReceiverType();
                    if (!var6_6) {
                        var14_14 = var12_12.findExactMethod((ReferenceBinding)var13_13, var1_1, var2_2, var3_3);
                        if (var14_14 == null) {
                            var14_14 = var12_12.findMethod((ReferenceBinding)var13_13, var1_1, var2_2, var3_3);
                        }
                        if (var14_14 != null) {
                            if (var7_7 == null) {
                                if (var14_14.isValidBinding()) {
                                    if (!var14_14.isStatic() && (var5_5 || var4_4)) {
                                        if (var8_8 != null && var8_8.problemId() != 2) {
                                            return var8_8;
                                        }
                                        return new ProblemMethodBinding((MethodBinding)var14_14, var14_14.selector, var14_14.parameters, var5_5 != false ? 6 : 7);
                                    }
                                    if (var13_13 == var14_14.declaringClass || (var8_8 == null || var8_8.problemId() != 2) && this.compilerOptions().complianceLevel >= 0x300000L || var13_13.getMethods(var1_1) != Binding.NO_METHODS) {
                                        if (var8_8 != null && var8_8.problemId() != 2) {
                                            return var8_8;
                                        }
                                        if (var10_10 > 0) {
                                            var3_3.setDepth(var10_10);
                                            var3_3.setActualReceiverType((ReferenceBinding)var13_13);
                                        }
                                        return var14_14;
                                    }
                                    if (var8_8 == null) {
                                        if (var10_10 > 0) {
                                            var3_3.setDepth(var10_10);
                                            var3_3.setActualReceiverType((ReferenceBinding)var13_13);
                                        }
                                        var7_7 = var14_14;
                                    }
                                } else {
                                    if (var14_14.problemId() != 2 && var14_14.problemId() != 1) {
                                        return var14_14;
                                    }
                                    if (var8_8 == null || var8_8.problemId() == 2 && var14_14.problemId() == 1) {
                                        var8_8 = var14_14;
                                    }
                                }
                            } else if (var14_14.problemId() == 3 || var7_7.declaringClass != var14_14.declaringClass && (var13_13 == var14_14.declaringClass || var13_13.getMethods(var1_1) != Binding.NO_METHODS)) {
                                return new ProblemMethodBinding((MethodBinding)var14_14, var1_1, var2_2, 5);
                            }
                        }
                    }
                    var6_6 = false;
                    ++var10_10;
                    var4_4 |= var13_13.isStatic();
                    var14_14 = var9_9.methodScope();
                    var5_5 = var14_14 == null ? false : var14_14.isConstructorCall;
                    ** GOTO lbl58
                }
                case 4: {
                    break block5;
                }
lbl58:
                // 3 sources

                default: {
                    var9_9 = var9_9.parent;
                    continue block5;
                }
            }
            break;
        }
        if (var4_4 && this.compilerOptions().sourceLevel >= 0x310000L) {
            if (var8_8 != null) {
                if (var8_8.declaringClass != null && var8_8.declaringClass.id == 1) {
                    return var8_8;
                }
                if (var8_8.problemId() == 1 && (var11_11 = ((ProblemMethodBinding)var8_8).closestMatch) != null && var11_11.canBeSeenBy(var3_3, this)) {
                    return var8_8;
                }
            }
            var11_11 = (CompilationUnitScope)var9_9;
            var12_12 = var11_11.imports;
            if (var12_12 != null) {
                var13_13 = null;
                var14_15 = false;
                for (ImportBinding var17_19 : var12_12) {
                    if (!var17_19.isStatic()) continue;
                    var18_20 = var17_19.resolvedImport;
                    var19_21 = null;
                    if (var17_19.onDemand) {
                        if (!var14_15 && var18_20 instanceof ReferenceBinding) {
                            var19_21 = this.findMethod((ReferenceBinding)var18_20, var1_1, var2_2, var3_3);
                        }
                    } else if (var18_20 instanceof MethodBinding) {
                        var20_22 = (MethodBinding)var18_20;
                        if (CharOperation.equals(var20_22.selector, var1_1)) {
                            var19_21 = this.findMethod(var20_22.declaringClass, var1_1, var2_2, var3_3);
                        }
                    } else if (var18_20 instanceof FieldBinding) {
                        var20_22 = (FieldBinding)var18_20;
                        if (CharOperation.equals(var20_22.name, var1_1) && (var22_24 = this.getType(var21_23 /* !! */  = var17_19.reference.tokens, var21_23 /* !! */ .length - 1)) != null) {
                            var19_21 = this.findMethod((ReferenceBinding)var22_24, var1_1, var2_2, var3_3);
                        }
                    }
                    if (var19_21 == null || var19_21 == var8_8) continue;
                    if (!var19_21.isValidBinding()) {
                        if (var8_8 != null) continue;
                        var8_8 = var19_21;
                        continue;
                    }
                    if (!var19_21.isStatic()) continue;
                    var20_22 = this.computeCompatibleMethod((MethodBinding)var19_21, var2_2, var3_3);
                    if (var20_22 != null) {
                        if (var20_22.isValidBinding()) {
                            if (var20_22.canBeSeenBy(var11_11.fPackage)) {
                                if (var13_13 != null && var13_13.contains(var20_22)) continue;
                                var21_23 /* !! */  = (char[][])var17_19.reference;
                                if (var21_23 /* !! */  != null) {
                                    var21_23 /* !! */ .used = true;
                                }
                                if (!var14_15 && !var17_19.onDemand) {
                                    var13_13 = null;
                                    var14_15 = true;
                                }
                                if (var13_13 == null) {
                                    var13_13 = new ObjectVector(3);
                                }
                                var13_13.add(var20_22);
                                continue;
                            }
                            if (var8_8 != null) continue;
                            var8_8 = new ProblemMethodBinding((MethodBinding)var20_22, var1_1, var20_22.parameters, 2);
                            continue;
                        }
                        if (var8_8 != null) continue;
                        var8_8 = var20_22;
                        continue;
                    }
                    if (var8_8 != null) continue;
                    var8_8 = new ProblemMethodBinding((MethodBinding)var19_21, var1_1, var2_2, 1);
                }
                if (var13_13 != null) {
                    var15_17 = new MethodBinding[var13_13.size];
                    var13_13.copyInto(var15_17);
                    var7_7 = this.mostSpecificMethodBinding((MethodBinding[])var15_17, var15_17.length, var2_2, var3_3, null);
                }
            }
        }
        if (var7_7 != null) {
            var3_3.setActualReceiverType(var7_7.declaringClass);
            return var7_7;
        }
        if (var8_8 != null) {
            return var8_8;
        }
        return new ProblemMethodBinding(var1_1, var2_2, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_IO_SERIALIZABLE);
        return this.environment().getResolvedType(JAVA_IO_SERIALIZABLE, this);
    }

    public final ReferenceBinding getJavaLangAnnotationAnnotation() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ANNOTATION_ANNOTATION);
        return this.environment().getResolvedType(JAVA_LANG_ANNOTATION_ANNOTATION, this);
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ASSERTIONERROR);
        return this.environment().getResolvedType(JAVA_LANG_ASSERTIONERROR, this);
    }

    public final ReferenceBinding getJavaLangClass() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_CLASS);
        return this.environment().getResolvedType(JAVA_LANG_CLASS, this);
    }

    public final ReferenceBinding getJavaLangCloneable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_CLONEABLE);
        return this.environment().getResolvedType(JAVA_LANG_CLONEABLE, this);
    }

    public final ReferenceBinding getJavaLangEnum() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ENUM);
        return this.environment().getResolvedType(JAVA_LANG_ENUM, this);
    }

    public final ReferenceBinding getJavaLangIterable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ITERABLE);
        return this.environment().getResolvedType(JAVA_LANG_ITERABLE, this);
    }

    public final ReferenceBinding getJavaLangObject() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_OBJECT);
        return this.environment().getResolvedType(JAVA_LANG_OBJECT, this);
    }

    public final ReferenceBinding getJavaLangString() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_STRING);
        return this.environment().getResolvedType(JAVA_LANG_STRING, this);
    }

    public final ReferenceBinding getJavaLangThrowable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_THROWABLE);
        return this.environment().getResolvedType(JAVA_LANG_THROWABLE, this);
    }

    public final ReferenceBinding getJavaUtilIterator() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_UTIL_ITERATOR);
        return this.environment().getResolvedType(JAVA_UTIL_ITERATOR, this);
    }

    public final ReferenceBinding getMemberType(char[] cArray, ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2 = this.findMemberType(cArray, referenceBinding);
        if (referenceBinding2 != null) {
            return referenceBinding2;
        }
        return new ProblemReferenceBinding(cArray, null, 1);
    }

    public MethodBinding getMethod(TypeBinding typeBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            switch (typeBinding.kind()) {
                case 132: {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(cArray, typeBindingArray, 1);
                    return problemMethodBinding;
                }
                case 68: {
                    compilationUnitScope.recordTypeReference(typeBinding);
                    MethodBinding methodBinding = this.findMethodForArray((ArrayBinding)typeBinding, cArray, typeBindingArray, invocationSite);
                    return methodBinding;
                }
            }
            compilationUnitScope.recordTypeReference(typeBinding);
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
            if (!referenceBinding.canBeSeenBy(this)) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(cArray, typeBindingArray, 8);
                return problemMethodBinding;
            }
            MethodBinding methodBinding = this.findExactMethod(referenceBinding, cArray, typeBindingArray, invocationSite);
            if (methodBinding != null) {
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            methodBinding = this.findMethod(referenceBinding, cArray, typeBindingArray, invocationSite);
            if (methodBinding == null) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(cArray, typeBindingArray, 1);
                return problemMethodBinding;
            }
            if (!methodBinding.isValidBinding()) {
                MethodBinding methodBinding3 = methodBinding;
                return methodBinding3;
            }
            if (typeBinding.id != 1 && typeBindingArray == Binding.NO_PARAMETERS && CharOperation.equals(cArray, GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                ParameterizedMethodBinding parameterizedMethodBinding = ParameterizedMethodBinding.instantiateGetClass(typeBinding, methodBinding, this);
                return parameterizedMethodBinding;
            }
            MethodBinding methodBinding4 = methodBinding;
            return methodBinding4;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public final Binding getPackage(char[][] cArray) {
        this.compilationUnitScope().recordQualifiedReference(cArray);
        Binding binding = this.getTypeOrPackage(cArray[0], 20);
        if (binding == null) {
            return new ProblemReferenceBinding(cArray[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int n = 1;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (n < cArray.length) {
            if ((binding = packageBinding.getTypeOrPackage(cArray[n++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n), null, binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(cArray, null, 1);
    }

    public final TypeBinding getType(char[] cArray) {
        TypeBinding typeBinding = Scope.getBaseType(cArray);
        if (typeBinding != null) {
            return typeBinding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(cArray, 4);
    }

    public final TypeBinding getType(char[] cArray, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(cArray);
        }
        Binding binding = packageBinding.getTypeOrPackage(cArray);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, cArray), null, 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, cArray), null, binding.problemId());
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        if (!referenceBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, cArray), referenceBinding, 2);
        }
        return referenceBinding;
    }

    public final TypeBinding getType(char[][] cArray, int n) {
        Binding binding;
        Object object;
        if (n == 1 && (object = Scope.getBaseType(cArray[0])) != null) {
            return object;
        }
        object = this.compilationUnitScope();
        ((CompilationUnitScope)object).recordQualifiedReference(cArray);
        Binding binding2 = this.getTypeOrPackage(cArray[0], n == 1 ? 4 : 20);
        if (binding2 == null) {
            return new ProblemReferenceBinding(cArray[0], null, 1);
        }
        if (!binding2.isValidBinding()) {
            return (ReferenceBinding)binding2;
        }
        int n2 = 1;
        boolean bl = false;
        if (binding2 instanceof PackageBinding) {
            binding = (PackageBinding)binding2;
            while (n2 < n) {
                if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                }
                if (!binding2.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding2.problemId());
                }
                if (!(binding2 instanceof PackageBinding)) break;
                binding = (PackageBinding)binding2;
            }
            if (binding2 instanceof PackageBinding) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            bl = true;
        }
        binding = (ReferenceBinding)binding2;
        ((CompilationUnitScope)object).recordTypeReference((TypeBinding)binding);
        if (bl && !((ReferenceBinding)binding).canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
        }
        while (n2 < n) {
            if ((binding = this.getMemberType(cArray[n2++], (ReferenceBinding)binding)).isValidBinding()) continue;
            if (binding instanceof ProblemReferenceBinding) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)binding;
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), problemReferenceBinding.closestMatch, binding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding.problemId());
        }
        return binding;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] cArray, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Scope scope;
        Scope scope2 = this;
        Binding binding = null;
        boolean bl = false;
        boolean bl2 = false;
        if ((n & 4) == 0) {
            scope = scope2;
            while ((scope = scope2.parent) != null) {
                scope2 = scope;
            }
        } else {
            block7: while (true) {
                switch (scope2.kind) {
                    case 2: {
                        scope = (MethodScope)scope2;
                        object4 = ((MethodScope)scope).referenceMethod();
                        if (object4 != null && ((AbstractMethodDeclaration)object4).binding != null && (object3 = ((AbstractMethodDeclaration)object4).binding.getTypeVariable(cArray)) != null) {
                            return object3;
                        }
                        bl |= ((MethodScope)scope).isStatic;
                        bl2 = ((MethodScope)scope).insideTypeAnnotation;
                    }
                    case 1: {
                        object3 = ((BlockScope)scope2).findLocalType(cArray);
                        if (object3 == null) break;
                        if (binding != null && binding != object3) {
                            return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 5);
                        }
                        return object3;
                    }
                    case 3: {
                        TypeVariableBinding typeVariableBinding;
                        object2 = ((ClassScope)scope2).referenceContext.binding;
                        if (scope2 == this && (((SourceTypeBinding)object2).tagBits & 0x40000L) == 0L) {
                            typeVariableBinding = ((ReferenceBinding)object2).getTypeVariable(cArray);
                            if (typeVariableBinding != null) {
                                return typeVariableBinding;
                            }
                            if (CharOperation.equals(cArray, ((SourceTypeBinding)object2).sourceName)) {
                                return object2;
                            }
                            bl |= ((ReferenceBinding)object2).isStatic();
                            break;
                        }
                        typeVariableBinding = ((ReferenceBinding)object2).getTypeVariable(cArray);
                        if (typeVariableBinding != null) {
                            if (bl) {
                                return new ProblemReferenceBinding(cArray, (ReferenceBinding)typeVariableBinding, 7);
                            }
                            return typeVariableBinding;
                        }
                        if (!bl2 && (object = this.findMemberType(cArray, (ReferenceBinding)object2)) != null) {
                            if (((Binding)object).problemId() == 3) {
                                if (binding != null && binding.problemId() != 2) {
                                    return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 5);
                                }
                                return object;
                            }
                            if (((Binding)object).isValidBinding() && (object2 == ((TypeBinding)object).enclosingType() || this.compilerOptions().complianceLevel >= 0x300000L)) {
                                if (bl && !((ReferenceBinding)object).isStatic() && ((SourceTypeBinding)object2).isGenericType()) {
                                    return new ProblemReferenceBinding(cArray, (ReferenceBinding)object, 7);
                                }
                                if (binding == null) {
                                    return object;
                                }
                                if (binding.isValidBinding() && binding != object) {
                                    return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 5);
                                }
                            }
                            if (binding == null || binding.problemId() == 2 && ((Binding)object).problemId() != 2) {
                                binding = object;
                            }
                        }
                        bl2 = false;
                        bl |= ((ReferenceBinding)object2).isStatic();
                        if (!CharOperation.equals(((SourceTypeBinding)object2).sourceName, cArray)) break;
                        if (binding != null && binding != object2 && binding.problemId() != 2) {
                            return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 5);
                        }
                        return object2;
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope2 = scope2.parent;
            }
            if (binding != null && binding.problemId() != 2) {
                return binding;
            }
        }
        scope = (CompilationUnitScope)scope2;
        object4 = ((CompilationUnitScope)scope).typeOrPackageCache;
        if (object4 != null && (object3 = (Binding)((HashtableOfObject)object4).get(cArray)) != null) {
            if (object3 instanceof ImportBinding) {
                object2 = ((ImportBinding)object3).reference;
                if (object2 != null) {
                    ((ImportReference)object2).used = true;
                }
                if (object3 instanceof ImportConflictBinding) {
                    object3 = ((ImportConflictBinding)object3).conflictingTypeBinding;
                    ((HashtableOfObject)object4).put(cArray, object3);
                } else {
                    object3 = ((ImportBinding)object3).resolvedImport;
                    ((HashtableOfObject)object4).put(cArray, object3);
                }
            }
            if ((n & 4) != 0) {
                if (binding != null && binding.problemId() != 2 && ((Binding)object3).problemId() != 3) {
                    return binding;
                }
                if (object3 instanceof ReferenceBinding) {
                    return object3;
                }
            }
            if ((n & 0x10) != 0 && object3 instanceof PackageBinding) {
                return object3;
            }
        }
        if ((n & 4) != 0) {
            Binding binding2;
            object3 = ((CompilationUnitScope)scope).imports;
            if (object3 != null && object4 == null) {
                int n2 = ((ImportBinding[])object3).length;
                for (int i = 0; i < n2; ++i) {
                    object = object3[i];
                    if (((ImportBinding)object).onDemand || !CharOperation.equals(((ImportBinding)object).compoundName[((ImportBinding)object).compoundName.length - 1], cArray) || (binding2 = ((CompilationUnitScope)scope).resolveSingleImport((ImportBinding)object)) == null || binding2 instanceof MethodBinding && !(binding2 = this.getType(((ImportBinding)object).compoundName, ((ImportBinding)object).compoundName.length)).isValidBinding() || !(binding2 instanceof TypeBinding)) continue;
                    ImportReference importReference = ((ImportBinding)object).reference;
                    if (importReference != null) {
                        importReference.used = true;
                    }
                    return binding2;
                }
            }
            PackageBinding packageBinding = ((CompilationUnitScope)scope).fPackage;
            ((CompilationUnitScope)scope).recordReference(packageBinding.compoundName, cArray);
            Binding binding3 = packageBinding.getTypeOrPackage(cArray);
            if (binding3 instanceof ReferenceBinding) {
                if (object4 != null) {
                    ((HashtableOfObject)object4).put(cArray, binding3);
                }
                return binding3;
            }
            if (object3 != null) {
                boolean bl3 = false;
                binding2 = null;
                int n3 = ((Object)object3).length;
                for (int i = 0; i < n3; ++i) {
                    Object object5 = object3[i];
                    if (!((ImportBinding)object5).onDemand) continue;
                    Binding binding4 = ((ImportBinding)object5).resolvedImport;
                    ReferenceBinding referenceBinding = null;
                    if (binding4 instanceof PackageBinding) {
                        referenceBinding = this.findType(cArray, (PackageBinding)binding4, packageBinding);
                    } else if (((ImportBinding)object5).isStatic()) {
                        referenceBinding = this.findMemberType(cArray, (ReferenceBinding)binding4);
                        if (referenceBinding != null && !referenceBinding.isStatic()) {
                            referenceBinding = null;
                        }
                    } else {
                        referenceBinding = this.findDirectMemberType(cArray, (ReferenceBinding)binding4);
                    }
                    if (referenceBinding == binding2 || referenceBinding == null) continue;
                    if (referenceBinding.isValidBinding()) {
                        ImportReference importReference = ((ImportBinding)object5).reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        if (bl3) {
                            referenceBinding = new ProblemReferenceBinding(cArray, null, 3);
                            if (object4 != null) {
                                ((HashtableOfObject)object4).put(cArray, referenceBinding);
                            }
                            return referenceBinding;
                        }
                        binding2 = referenceBinding;
                        bl3 = true;
                        continue;
                    }
                    if (binding != null) continue;
                    binding = referenceBinding;
                }
                if (binding2 != null) {
                    if (object4 != null) {
                        ((HashtableOfObject)object4).put(cArray, binding2);
                    }
                    return binding2;
                }
            }
        }
        ((CompilationUnitScope)scope).recordSimpleReference(cArray);
        if ((n & 0x10) != 0 && (object3 = ((CompilationUnitScope)scope).environment.getTopLevelPackage(cArray)) != null) {
            if (object4 != null) {
                ((HashtableOfObject)object4).put(cArray, object3);
            }
            return object3;
        }
        if (binding == null) {
            binding = new ProblemReferenceBinding(cArray, null, 1);
            if (object4 != null && (n & 0x10) != 0) {
                ((HashtableOfObject)object4).put(cArray, binding);
            }
        }
        return binding;
    }

    public final Binding getTypeOrPackage(char[][] cArray) {
        Binding binding;
        Binding binding2;
        int n = cArray.length;
        if (n == 1 && (binding2 = Scope.getBaseType(cArray[0])) != null) {
            return binding2;
        }
        binding2 = this.getTypeOrPackage(cArray[0], 20);
        if (!binding2.isValidBinding()) {
            return binding2;
        }
        int n2 = 1;
        boolean bl = false;
        if (binding2 instanceof PackageBinding) {
            binding = (PackageBinding)binding2;
            while (n2 < n) {
                if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                }
                if (!binding2.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding2.problemId());
                }
                if (!(binding2 instanceof PackageBinding)) break;
                binding = (PackageBinding)binding2;
            }
            if (binding2 instanceof PackageBinding) {
                return binding2;
            }
            bl = true;
        }
        binding = (ReferenceBinding)binding2;
        Binding binding3 = (ReferenceBinding)this.environment().convertToRawType((TypeBinding)binding);
        if (bl && !((ReferenceBinding)binding).canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
        }
        while (n2 < n) {
            if (!(binding = this.getMemberType(cArray[n2++], (ReferenceBinding)binding)).isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding.problemId());
            }
            if (((TypeBinding)binding).isGenericType()) {
                binding3 = this.environment().createRawType((ReferenceBinding)binding, (ReferenceBinding)binding3);
                continue;
            }
            binding3 = binding3 != null && (((TypeBinding)binding3).isRawType() || ((TypeBinding)binding3).isParameterizedType()) ? this.environment().createParameterizedType((ReferenceBinding)binding, null, (ReferenceBinding)binding3) : binding;
        }
        return binding3;
    }

    protected boolean hasErasedCandidatesCollisions(TypeBinding typeBinding, TypeBinding typeBinding2, Map map, ReferenceBinding referenceBinding, ASTNode aSTNode) {
        map.clear();
        TypeBinding[] typeBindingArray = this.minimalErasedCandidates(new TypeBinding[]{typeBinding, typeBinding2}, map);
        if (typeBindingArray != null) {
            for (TypeBinding typeBinding3 : typeBindingArray) {
                Set set;
                int n;
                if (typeBinding3 == null || (n = (set = (Set)map.get(typeBinding3)).size()) <= 1) continue;
                TypeBinding[] typeBindingArray2 = new TypeBinding[n];
                set.toArray(typeBindingArray2);
                this.problemReporter().superinterfacesCollide(typeBindingArray2[0].erasure(), aSTNode, typeBindingArray2[0], typeBindingArray2[1]);
                referenceBinding.tagBits |= 0x20000L;
                return true;
            }
        }
        return false;
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected boolean isAcceptableMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        int n2 = typeBindingArray2.length;
        if (n == n2) {
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding;
                TypeBinding typeBinding2 = typeBindingArray[i];
                TypeBinding typeBinding3 = typeBindingArray2[i];
                if (typeBinding2 == typeBinding3) continue;
                if (typeBinding2.isRawType() && (typeBinding = typeBinding2.findSuperTypeWithSameErasure(typeBinding3)) != typeBinding3) {
                    return false;
                }
                if (typeBinding2.isCompatibleWith(typeBinding3)) continue;
                return i == n - 1 && methodBinding.isVarargs() && methodBinding2.isVarargs() && (typeBinding2 == (typeBinding = ((ArrayBinding)typeBinding3).elementsType()) || typeBinding2.isCompatibleWith(typeBinding));
            }
            return true;
        }
        if (methodBinding.isVarargs() && methodBinding2.isVarargs()) {
            if (n > n2 && ((ArrayBinding)typeBindingArray2[n2 - 1]).elementsType().id != 1) {
                return false;
            }
            for (int i = (n > n2 ? n2 : n) - 2; i >= 0; --i) {
                if (typeBindingArray[i] == typeBindingArray2[i] || typeBindingArray[i].isCompatibleWith(typeBindingArray2[i])) continue;
                return false;
            }
            if (this.parameterCompatibilityLevel(methodBinding, typeBindingArray2) == -1 && this.parameterCompatibilityLevel(methodBinding2, typeBindingArray) == 2) {
                return true;
            }
        }
        return false;
    }

    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, TypeBinding typeBinding2) {
        LookupEnvironment lookupEnvironment = this.environment();
        if (lookupEnvironment.globalOptions.sourceLevel < 0x310000L || typeBinding.isBaseType() == typeBinding2.isBaseType()) {
            return false;
        }
        TypeBinding typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding);
        return typeBinding3 == typeBinding2 || typeBinding3.isCompatibleWith(typeBinding2);
    }

    public final boolean isDefinedInField(FieldBinding fieldBinding) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != fieldBinding) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding methodBinding) {
        Scope scope = this;
        do {
            ReferenceContext referenceContext;
            if (!(scope instanceof MethodScope) || !((referenceContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)referenceContext).binding != methodBinding) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding referenceBinding) {
        Scope scope;
        ReferenceBinding referenceBinding2 = referenceBinding;
        while ((referenceBinding = referenceBinding2.enclosingType()) != null) {
            referenceBinding2 = referenceBinding;
        }
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        SourceTypeBinding[] sourceTypeBindingArray = ((CompilationUnitScope)scope2).topLevelTypes;
        int n = sourceTypeBindingArray.length;
        while (--n >= 0) {
            if (sourceTypeBindingArray[n] != referenceBinding2) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding referenceBinding) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).referenceContext.binding != referenceBinding) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (methodBinding == null || !methodBinding.isViewedAsDeprecated()) break;
                    return true;
                }
                SourceTypeBinding sourceTypeBinding = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if (sourceTypeBinding == null) break;
                sourceTypeBinding.initializeDeprecatedAnnotationTagBits();
                if (!sourceTypeBinding.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding sourceTypeBinding = ((ClassScope)this).referenceType().binding;
                if (sourceTypeBinding == null) break;
                ((Binding)sourceTypeBinding).initializeDeprecatedAnnotationTagBits();
                if (!sourceTypeBinding.isViewedAsDeprecated()) break;
                return true;
            }
            case 4: {
                SourceTypeBinding sourceTypeBinding;
                CompilationUnitDeclaration compilationUnitDeclaration = this.referenceCompilationUnit();
                if (compilationUnitDeclaration.types == null || compilationUnitDeclaration.types.length <= 0 || (sourceTypeBinding = compilationUnitDeclaration.types[0].binding) == null) break;
                sourceTypeBinding.initializeDeprecatedAnnotationTagBits();
                if (!sourceTypeBinding.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    private TypeBinding leastContainingInvocation(TypeBinding typeBinding, Set set, List list) {
        TypeBinding typeBinding2;
        if (set == null) {
            return typeBinding;
        }
        int n = set.size();
        Iterator iterator = set.iterator();
        if (n == 1) {
            return (TypeBinding)iterator.next();
        }
        int n2 = typeBinding.dimensions();
        int n3 = (typeBinding = typeBinding.leafComponentType()).typeVariables().length;
        if (n3 == 0) {
            return typeBinding;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n3];
        block5: while (iterator.hasNext()) {
            typeBinding2 = ((TypeBinding)iterator.next()).leafComponentType();
            switch (typeBinding2.kind()) {
                case 2052: {
                    TypeVariableBinding[] typeVariableBindingArray = typeBinding2.typeVariables();
                    for (int i = 0; i < n3; ++i) {
                        TypeBinding typeBinding3 = this.leastContainingTypeArgument(typeBindingArray[i], typeVariableBindingArray[i], (ReferenceBinding)typeBinding, i, list);
                        if (typeBinding3 == null) {
                            return null;
                        }
                        typeBindingArray[i] = typeBinding3;
                    }
                    continue block5;
                }
                case 260: {
                    ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding2;
                    for (int i = 0; i < n3; ++i) {
                        TypeBinding typeBinding4 = this.leastContainingTypeArgument(typeBindingArray[i], parameterizedTypeBinding.arguments[i], (ReferenceBinding)typeBinding, i, list);
                        if (typeBinding4 == null) {
                            return null;
                        }
                        typeBindingArray[i] = typeBinding4;
                    }
                    continue block5;
                }
                case 1028: {
                    return n2 == 0 ? typeBinding2 : this.environment().createArrayType(typeBinding2, n2);
                }
            }
        }
        typeBinding2 = this.environment().createParameterizedType((ReferenceBinding)typeBinding.erasure(), typeBindingArray, typeBinding.enclosingType());
        return n2 == 0 ? typeBinding2 : this.environment().createArrayType(typeBinding2, n2);
    }

    private TypeBinding leastContainingTypeArgument(TypeBinding typeBinding, TypeBinding typeBinding2, ReferenceBinding referenceBinding, int n, List list) {
        TypeBinding typeBinding3;
        if (typeBinding == null) {
            return typeBinding2;
        }
        if (typeBinding == typeBinding2) {
            return typeBinding;
        }
        if (typeBinding2.isWildcard()) {
            typeBinding3 = (WildcardBinding)typeBinding2;
            if (typeBinding.isWildcard()) {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        switch (typeBinding3.boundKind) {
                            case 1: {
                                TypeBinding typeBinding4 = this.lowerUpperBound(new TypeBinding[]{wildcardBinding.bound, typeBinding3.bound}, list);
                                if (typeBinding4 == null) {
                                    return null;
                                }
                                if (typeBinding4 == TypeBinding.INT) {
                                    return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                                }
                                return this.environment().createWildcard(referenceBinding, n, typeBinding4, null, 1);
                            }
                            case 2: {
                                if (wildcardBinding.bound == typeBinding3.bound) {
                                    return wildcardBinding.bound;
                                }
                                return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (wildcardBinding.boundKind != 2) break;
                        TypeBinding[] typeBindingArray = Scope.greaterLowerBound(new TypeBinding[]{wildcardBinding.bound, typeBinding3.bound});
                        if (typeBindingArray == null) {
                            return null;
                        }
                        return this.environment().createWildcard(referenceBinding, n, typeBindingArray[0], null, 2);
                    }
                }
            } else {
                switch (typeBinding3.boundKind) {
                    case 1: {
                        TypeBinding typeBinding5 = this.lowerUpperBound(new TypeBinding[]{typeBinding, typeBinding3.bound}, list);
                        if (typeBinding5 == null) {
                            return null;
                        }
                        if (typeBinding5 == TypeBinding.INT) {
                            return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                        }
                        return this.environment().createWildcard(referenceBinding, n, typeBinding5, null, 1);
                    }
                    case 2: {
                        TypeBinding[] typeBindingArray = Scope.greaterLowerBound(new TypeBinding[]{typeBinding, typeBinding3.bound});
                        if (typeBindingArray == null) {
                            return null;
                        }
                        return this.environment().createWildcard(referenceBinding, n, typeBindingArray[0], null, 2);
                    }
                }
            }
        } else if (typeBinding.isWildcard()) {
            typeBinding3 = (WildcardBinding)typeBinding;
            switch (typeBinding3.boundKind) {
                case 1: {
                    TypeBinding typeBinding6 = this.lowerUpperBound(new TypeBinding[]{typeBinding3.bound, typeBinding2}, list);
                    if (typeBinding6 == null) {
                        return null;
                    }
                    if (typeBinding6 == TypeBinding.INT) {
                        return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                    }
                    return this.environment().createWildcard(referenceBinding, n, typeBinding6, null, 1);
                }
                case 2: {
                    TypeBinding[] typeBindingArray = Scope.greaterLowerBound(new TypeBinding[]{typeBinding3.bound, typeBinding2});
                    if (typeBindingArray == null) {
                        return null;
                    }
                    return this.environment().createWildcard(referenceBinding, n, typeBindingArray[0], null, 2);
                }
            }
        }
        typeBinding3 = this.lowerUpperBound(new TypeBinding[]{typeBinding, typeBinding2}, list);
        if (typeBinding3 == null) {
            return null;
        }
        if (typeBinding3 == TypeBinding.INT) {
            return this.environment().createWildcard(referenceBinding, n, null, null, 0);
        }
        return this.environment().createWildcard(referenceBinding, n, typeBinding3, null, 1);
    }

    public TypeBinding lowerUpperBound(TypeBinding[] typeBindingArray) {
        int n = typeBindingArray.length;
        if (n == 1) {
            TypeBinding typeBinding = typeBindingArray[0];
            return typeBinding == null ? TypeBinding.VOID : typeBinding;
        }
        return this.lowerUpperBound(typeBindingArray, new ArrayList(1));
    }

    private TypeBinding lowerUpperBound(TypeBinding[] typeBindingArray, List list) {
        int n;
        int n2;
        TypeBinding typeBinding;
        int n3;
        int n4;
        TypeBinding[] typeBindingArray2;
        int n5 = typeBindingArray.length;
        if (n5 == 1) {
            TypeBinding typeBinding2 = typeBindingArray[0];
            return typeBinding2 == null ? TypeBinding.VOID : typeBinding2;
        }
        int n6 = list.size();
        block5: for (int i = 0; i < n6; ++i) {
            typeBindingArray2 = (TypeBinding[])list.get(i);
            n4 = typeBindingArray2.length;
            if (n4 < n5) continue;
            block6: for (n3 = 0; n3 < n5; ++n3) {
                typeBinding = typeBindingArray[n3];
                if (typeBinding == null) continue;
                for (n2 = 0; n2 < n4; ++n2) {
                    TypeBinding typeBinding3 = typeBindingArray2[n2];
                    if (typeBinding3 != null && (typeBinding3 == typeBinding || typeBinding3.isEquivalentTo(typeBinding))) continue block6;
                }
                continue block5;
            }
            return TypeBinding.INT;
        }
        list.add(typeBindingArray);
        HashMap hashMap = new HashMap(1);
        typeBindingArray2 = this.minimalErasedCandidates(typeBindingArray, hashMap);
        if (typeBindingArray2 == null) {
            return null;
        }
        n4 = typeBindingArray2.length;
        if (n4 == 0) {
            return TypeBinding.VOID;
        }
        n3 = 0;
        typeBinding = null;
        n2 = -1;
        for (int i = 0; i < n4; ++i) {
            TypeBinding typeBinding4 = typeBindingArray2[i];
            if (typeBinding4 == null) continue;
            if ((typeBinding4 = this.leastContainingInvocation(typeBinding4, (Set)hashMap.get(typeBinding4), list)) == null) {
                return null;
            }
            n = typeBinding4.dimensions();
            if (n2 == -1) {
                n2 = n;
            } else if (n != n2) {
                return null;
            }
            if (typeBinding == null && !typeBinding4.leafComponentType().isInterface()) {
                typeBinding = typeBinding4.leafComponentType();
            }
            typeBindingArray2[n3++] = typeBinding4;
        }
        switch (n3) {
            case 0: {
                return TypeBinding.VOID;
            }
            case 1: {
                return typeBindingArray2[0];
            }
            case 2: {
                if ((n2 == 0 ? typeBindingArray2[1].id : typeBindingArray2[1].leafComponentType().id) == 1) {
                    return typeBindingArray2[0];
                }
                if ((n2 == 0 ? typeBindingArray2[0].id : typeBindingArray2[0].leafComponentType().id) != 1) break;
                return typeBindingArray2[1];
            }
        }
        TypeBinding[] typeBindingArray3 = new TypeBinding[n3 - 1];
        int n7 = 0;
        for (n = 0; n < n3; ++n) {
            TypeBinding typeBinding5;
            TypeBinding typeBinding6 = typeBinding5 = n2 == 0 ? typeBindingArray2[n] : typeBindingArray2[n].leafComponentType();
            if (!typeBinding5.isInterface()) continue;
            typeBindingArray3[n7++] = typeBinding5;
        }
        WildcardBinding wildcardBinding = this.environment().createWildcard(null, 0, typeBinding, typeBindingArray3, 1);
        return n2 == 0 ? wildcardBinding : this.environment().createArrayType(wildcardBinding, n2);
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected TypeBinding[] minimalErasedCandidates(TypeBinding[] typeBindingArray, Map map) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashSet<Object> hashSet;
        TypeBinding[] typeBindingArray2;
        int n2;
        TypeBinding typeBinding;
        Object object5;
        int n3 = typeBindingArray.length;
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            object5 = typeBindingArray[i];
            if (object5 == null) continue;
            if (((TypeBinding)object5).isBaseType()) {
                return null;
            }
            if (n4 < 0) {
                n4 = i;
            }
            ++n5;
        }
        switch (n5) {
            case 0: {
                return Binding.NO_TYPES;
            }
            case 1: {
                return typeBindingArray;
            }
        }
        TypeBinding typeBinding2 = typeBindingArray[n4];
        if (typeBinding2.isBaseType()) {
            return null;
        }
        object5 = new ArrayList(5);
        int n6 = typeBinding2.dimensions();
        TypeBinding typeBinding3 = typeBinding2.leafComponentType();
        TypeBinding typeBinding4 = typeBinding = typeBinding3.isTypeVariable() || typeBinding3.isWildcard() ? typeBinding2 : typeBinding2.erasure();
        if (typeBinding != typeBinding2) {
            HashSet<TypeBinding> hashSet2 = new HashSet<TypeBinding>(1);
            hashSet2.add(typeBinding2);
            map.put(typeBinding, hashSet2);
        }
        ((ArrayList)object5).add(typeBinding2);
        int n7 = 1;
        block9: for (n2 = 0; n2 < n7; ++n2) {
            HashSet<Object> hashSet3;
            HashSet<Object> hashSet4;
            ReferenceBinding referenceBinding;
            Object object6;
            typeBindingArray2 = (TypeBinding[])((ArrayList)object5).get(n2);
            n6 = typeBindingArray2.dimensions();
            if (n6 > 0) {
                typeBinding3 = typeBindingArray2.leafComponentType();
                switch (typeBinding3.id) {
                    case 1: {
                        if (n6 > 1) {
                            object6 = ((ArrayBinding)typeBindingArray2).elementsType();
                            if (((ArrayList)object5).contains(object6)) continue block9;
                            ((ArrayList)object5).add(object6);
                            ++n7;
                            continue block9;
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        object6 = this.getJavaIoSerializable();
                        if (!((ArrayList)object5).contains(object6)) {
                            ((ArrayList)object5).add(object6);
                            ++n7;
                        }
                        if (!((ArrayList)object5).contains(object6 = this.getJavaLangCloneable())) {
                            ((ArrayList)object5).add(object6);
                            ++n7;
                        }
                        if (((ArrayList)object5).contains(object6 = this.getJavaLangObject())) continue block9;
                        ((ArrayList)object5).add(object6);
                        ++n7;
                        continue block9;
                    }
                    default: {
                        typeBindingArray2 = typeBinding3;
                    }
                }
            }
            if ((referenceBinding = (ReferenceBinding)typeBindingArray2).isCapture() && (object6 = ((CaptureBinding)referenceBinding).firstBound) != null && ((TypeBinding)object6).isArrayType()) {
                HashSet<Object> hashSet5 = hashSet = n6 == 0 ? object6 : this.environment().createArrayType((TypeBinding)object6, n6);
                if (((ArrayList)object5).contains(hashSet)) continue;
                ((ArrayList)object5).add(hashSet);
                ++n7;
                HashSet<Object> hashSet6 = object4 = ((TypeBinding)object6).isTypeVariable() || ((TypeBinding)object6).isWildcard() ? hashSet : ((TypeBinding)((Object)hashSet)).erasure();
                if (object4 == hashSet) continue;
                object3 = new HashSet<Object>(1);
                object3.add(hashSet);
                map.put(object4, object3);
                continue;
            }
            object6 = referenceBinding.superInterfaces();
            if (object6 != null) {
                int n8 = ((Object)object6).length;
                for (int i = 0; i < n8; ++i) {
                    object3 = object6[i];
                    HashSet<Object> hashSet7 = hashSet4 = n6 == 0 ? object3 : this.environment().createArrayType((TypeBinding)object3, n6);
                    if (((ArrayList)object5).contains(hashSet4)) continue;
                    ((ArrayList)object5).add(hashSet4);
                    ++n7;
                    Object object7 = object2 = ((TypeBinding)object3).isTypeVariable() || ((TypeBinding)object3).isWildcard() ? hashSet4 : ((TypeBinding)((Object)hashSet4)).erasure();
                    if (object2 == hashSet4) continue;
                    object = new HashSet(1);
                    object.add(hashSet4);
                    map.put(object2, object);
                }
            }
            if ((hashSet = referenceBinding.superclass()) == null) continue;
            HashSet<Object> hashSet8 = hashSet3 = n6 == 0 ? hashSet : this.environment().createArrayType((TypeBinding)((Object)hashSet), n6);
            if (((ArrayList)object5).contains(hashSet3)) continue;
            ((ArrayList)object5).add(hashSet3);
            ++n7;
            HashSet<Object> hashSet9 = object3 = ((TypeBinding)((Object)hashSet)).isTypeVariable() || ((TypeBinding)((Object)hashSet)).isWildcard() ? hashSet3 : ((TypeBinding)((Object)hashSet3)).erasure();
            if (object3 == hashSet3) continue;
            hashSet4 = new HashSet(1);
            hashSet4.add(hashSet3);
            map.put(object3, hashSet4);
        }
        n2 = ((ArrayList)object5).size();
        typeBindingArray2 = new TypeBinding[n2];
        int n9 = 0;
        hashSet = ((ArrayList)object5).iterator();
        while (hashSet.hasNext()) {
            object4 = (TypeBinding)hashSet.next();
            typeBinding3 = ((TypeBinding)object4).leafComponentType();
            typeBindingArray2[n9++] = typeBinding3.isTypeVariable() || typeBinding3.isWildcard() ? object4 : ((TypeBinding)object4).erasure();
        }
        int n10 = n2;
        for (n = n4 + 1; n < n3; ++n) {
            Set<Object> set;
            int n11;
            object3 = typeBindingArray[n];
            if (object3 == null) continue;
            if (((TypeBinding)object3).isArrayType()) {
                for (n11 = 0; n11 < n2; ++n11) {
                    object2 = typeBindingArray2[n11];
                    if (object2 == null || object2 == object3) continue;
                    object = ((TypeBinding)object3).findSuperTypeWithSameErasure((TypeBinding)object2);
                    if (object == null) {
                        typeBindingArray2[n11] = null;
                        if (--n10 != 0) continue;
                        return null;
                    }
                    set = (Set)map.get(object2);
                    if (set == null) {
                        set = new HashSet(1);
                    }
                    set.add(object);
                    map.put(object2, set);
                }
                continue;
            }
            for (n11 = 0; n11 < n2; ++n11) {
                object2 = typeBindingArray2[n11];
                if (object2 == null) continue;
                if (object2 == object3 || ((TypeBinding)object2).id == 1 && ((TypeBinding)object3).isInterface()) {
                    object = object2;
                } else {
                    object = ((TypeBinding)object2).isArrayType() ? null : ((TypeBinding)object3).findSuperTypeWithSameErasure((TypeBinding)object2);
                    if (object == null) {
                        typeBindingArray2[n11] = null;
                        if (--n10 != 0) continue;
                        return null;
                    }
                }
                set = (HashSet<Object>)map.get(object2);
                if (set == null) {
                    set = new HashSet<Object>(1);
                }
                set.add(object);
                map.put(object2, set);
            }
        }
        if (n10 > 1) {
            for (n = 0; n < n2; ++n) {
                object3 = typeBindingArray2[n];
                if (object3 == null) continue;
                for (int i = 0; i < n2; ++i) {
                    if (n == i || (object2 = typeBindingArray2[i]) == null) continue;
                    if (object3 instanceof ReferenceBinding) {
                        if (((TypeBinding)object2).id == 1 && ((TypeBinding)object3).isInterface() || ((TypeBinding)object3).findSuperTypeWithSameErasure((TypeBinding)object2) == null) continue;
                        typeBindingArray2[i] = null;
                        --n10;
                        continue;
                    }
                    if (!((TypeBinding)object3).isArrayType() || ((TypeBinding)object2).isArrayType() && ((TypeBinding)object2).leafComponentType().id == 1 && ((TypeBinding)object2).dimensions() == ((TypeBinding)object3).dimensions() && ((TypeBinding)object3).leafComponentType().isInterface() || ((TypeBinding)object3).findSuperTypeWithSameErasure((TypeBinding)object2) == null) continue;
                    typeBindingArray2[i] = null;
                    --n10;
                }
            }
        }
        return typeBindingArray2;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] methodBindingArray, int n, InvocationSite invocationSite) {
        MethodBinding methodBinding = null;
        MethodBinding methodBinding2 = null;
        block0: for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding3 = methodBindingArray[i];
            if (methodBinding2 != null && methodBinding3.declaringClass != methodBinding2.declaringClass) break;
            if (!methodBinding3.isStatic()) {
                methodBinding2 = methodBinding3;
            }
            for (int j = 0; j < n; ++j) {
                if (i != j && !methodBindingArray[j].areParametersCompatibleWith(methodBinding3.parameters)) continue block0;
            }
            this.compilationUnitScope().recordTypeReferences(methodBinding3.thrownExceptions);
            return methodBinding3;
        }
        if (methodBinding == null) {
            return new ProblemMethodBinding(methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
        }
        return methodBinding;
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] methodBindingArray, int n, InvocationSite invocationSite) {
        MethodBinding methodBinding = null;
        block0: for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding2 = methodBindingArray[i];
            for (int j = 0; j < n; ++j) {
                if (i != j && !methodBindingArray[j].areParametersCompatibleWith(methodBinding2.parameters)) continue block0;
            }
            this.compilationUnitScope().recordTypeReferences(methodBinding2.thrownExceptions);
            return methodBinding2;
        }
        if (methodBinding == null) {
            return new ProblemMethodBinding(methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
        }
        return methodBinding;
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] methodBindingArray, int n, TypeBinding[] typeBindingArray, InvocationSite invocationSite, ReferenceBinding referenceBinding) {
        Binding binding;
        MethodBinding methodBinding;
        MethodBinding methodBinding2;
        Object object;
        int n2;
        int n3;
        int[] nArray = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = this.parameterCompatibilityLevel(methodBindingArray[n3], typeBindingArray);
        }
        n3 = invocationSite.genericTypeArguments() == null ? 1 : 0;
        MethodBinding[] methodBindingArray2 = new MethodBinding[n];
        int n4 = 0;
        int n5 = 2;
        for (n2 = 0; n2 <= n5; ++n2) {
            block2: for (int i = 0; i < n; ++i) {
                if (nArray[i] != n2) continue;
                n5 = n2;
                object = methodBindingArray[i];
                methodBinding2 = ((MethodBinding)object).original();
                MethodBinding methodBinding3 = n3 != 0 ? ((MethodBinding)object).tiebreakMethod() : object;
                for (int j = 0; j < n; ++j) {
                    MethodBinding methodBinding4;
                    if (i == j || nArray[j] != n2) continue;
                    methodBinding = methodBindingArray[j];
                    if (methodBinding2 == methodBinding.original()) {
                        nArray[j] = -1;
                        continue;
                    }
                    binding = methodBinding;
                    if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                        methodBinding4 = (ParameterizedGenericMethodBinding)methodBinding;
                        if (!((ParameterizedGenericMethodBinding)methodBinding4).isRaw) {
                            binding = ((ParameterizedGenericMethodBinding)methodBinding4).originalMethod;
                        }
                    }
                    if ((methodBinding4 = this.computeCompatibleMethod((MethodBinding)binding, methodBinding3.parameters, invocationSite)) == null || !methodBinding4.isValidBinding() || !this.isAcceptableMethod(methodBinding3, methodBinding4) || ((MethodBinding)object).isBridge() && !methodBinding.isBridge() && methodBinding3.areParametersEqual(methodBinding4)) continue block2;
                }
                methodBindingArray2[i] = object;
                ++n4;
            }
        }
        if (n4 == 1) {
            for (n2 = 0; n2 < n; ++n2) {
                if (methodBindingArray2[n2] == null) continue;
                this.compilationUnitScope().recordTypeReferences(methodBindingArray[n2].thrownExceptions);
                return methodBindingArray[n2];
            }
        } else if (n4 == 0) {
            return new ProblemMethodBinding(methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
        }
        if (referenceBinding != null) {
            referenceBinding = referenceBinding instanceof CaptureBinding ? referenceBinding : (ReferenceBinding)referenceBinding.erasure();
        }
        block5: for (n2 = 0; n2 < n; ++n2) {
            MethodBinding methodBinding5 = methodBindingArray2[n2];
            if (methodBinding5 == null) continue;
            Object[] objectArray = null;
            object = null;
            methodBinding2 = methodBinding5.original();
            for (int i = 0; i < n; ++i) {
                int n6;
                MethodBinding methodBinding6 = methodBindingArray2[i];
                if (methodBinding6 == null || n2 == i) continue;
                methodBinding = methodBinding6.original();
                if (methodBinding2.declaringClass == methodBinding.declaringClass) break block5;
                if (!methodBinding2.isAbstract()) {
                    if (methodBinding.isAbstract()) continue;
                    binding = methodBinding2.declaringClass.findSuperTypeWithSameErasure(methodBinding.declaringClass.erasure());
                    if (binding == null) continue block5;
                    if (!methodBinding5.hasSubstitutedParameters() && methodBinding2.typeVariables == Binding.NO_TYPE_VARIABLES) continue;
                    if (methodBinding.declaringClass != binding) {
                        MethodBinding[] methodBindingArray3 = ((ReferenceBinding)binding).getMethods(methodBinding.selector);
                        int n7 = methodBindingArray3.length;
                        for (n6 = 0; n6 < n7; ++n6) {
                            if (methodBindingArray3[n6].original() != methodBinding) continue;
                            methodBinding = methodBindingArray3[n6];
                            break;
                        }
                    }
                    if (methodBinding2.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        methodBinding = methodBinding2.computeSubstitutedMethod(methodBinding, this.environment());
                    }
                    if (methodBinding != null && methodBinding2.areParametersEqual(methodBinding)) continue;
                    continue block5;
                }
                if (referenceBinding == null) continue;
                binding = referenceBinding.findSuperTypeWithSameErasure(methodBinding2.declaringClass.erasure());
                if (methodBinding2.declaringClass != binding && binding instanceof ReferenceBinding) {
                    MethodBinding[] methodBindingArray4 = ((ReferenceBinding)binding).getMethods(methodBinding2.selector);
                    int n8 = methodBindingArray4.length;
                    for (n6 = 0; n6 < n8; ++n6) {
                        if (methodBindingArray4[n6].original() != methodBinding2) continue;
                        methodBinding2 = methodBindingArray4[n6];
                        break;
                    }
                }
                if (methodBinding.declaringClass != (binding = referenceBinding.findSuperTypeWithSameErasure(methodBinding.declaringClass.erasure())) && binding instanceof ReferenceBinding) {
                    MethodBinding[] methodBindingArray5 = ((ReferenceBinding)binding).getMethods(methodBinding.selector);
                    int n9 = methodBindingArray5.length;
                    for (n6 = 0; n6 < n9; ++n6) {
                        if (methodBindingArray5[n6].original() != methodBinding) continue;
                        methodBinding = methodBindingArray5[n6];
                        break;
                    }
                }
                if (methodBinding2.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    methodBinding = methodBinding2.computeSubstitutedMethod(methodBinding, this.environment());
                }
                if (methodBinding == null || !methodBinding2.areParameterErasuresEqual(methodBinding) || !methodBinding2.returnType.isCompatibleWith(methodBinding.returnType)) continue block5;
                if (methodBinding2.thrownExceptions == methodBinding.thrownExceptions) continue;
                if (objectArray == null) {
                    objectArray = methodBinding2.thrownExceptions;
                }
                if (object == null) {
                    object = new SimpleSet(3);
                }
                int n10 = objectArray.length;
                n6 = methodBinding.thrownExceptions.length;
                SimpleSet simpleSet = new SimpleSet(n10);
                block10: for (int j = 0; j < n10; ++j) {
                    ReferenceBinding referenceBinding2 = objectArray[j];
                    for (int k = 0; k < n6; ++k) {
                        if (referenceBinding2.isCompatibleWith(methodBinding.thrownExceptions[k])) {
                            ((SimpleSet)object).add(methodBinding5);
                            simpleSet.add(referenceBinding2);
                            continue block10;
                        }
                        if (!methodBinding.thrownExceptions[k].isCompatibleWith(referenceBinding2)) continue;
                        ((SimpleSet)object).add(methodBinding6);
                        simpleSet.add(methodBinding.thrownExceptions[k]);
                        continue block10;
                    }
                }
                objectArray = simpleSet.elementSize == 0 ? Binding.NO_EXCEPTIONS : new ReferenceBinding[simpleSet.elementSize];
                simpleSet.asArray(objectArray);
            }
            if (objectArray != null) {
                Object[] objectArray2 = ((SimpleSet)object).values;
                int n11 = objectArray.length;
                int n12 = objectArray2.length;
                block12: for (int i = 0; i < n12; ++i) {
                    ReferenceBinding[] referenceBindingArray;
                    MethodBinding methodBinding7 = (MethodBinding)objectArray2[i];
                    if (methodBinding7 == null || (referenceBindingArray = methodBinding7.thrownExceptions).length != n11) continue;
                    block13: for (int j = 0; j < n11; ++j) {
                        ReferenceBinding referenceBinding3 = referenceBindingArray[j];
                        for (int k = 0; k < n11; ++k) {
                            if (referenceBinding3 == objectArray[k]) continue block13;
                        }
                        continue block12;
                    }
                    return methodBinding7;
                }
            }
            return methodBinding5;
        }
        return new ProblemMethodBinding(methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
    }

    public final ClassScope outerMostClassScope() {
        ClassScope classScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            classScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return classScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope methodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            methodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return methodScope;
    }

    protected int parameterCompatibilityLevel(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        TypeBinding[] typeBindingArray2 = methodBinding.parameters;
        int n = typeBindingArray2.length;
        int n2 = typeBindingArray.length;
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            if (n != n2) {
                return -1;
            }
            for (int i = 0; i < n2; ++i) {
                TypeBinding typeBinding3 = typeBindingArray[i];
                TypeBinding typeBinding4 = typeBindingArray2[i];
                if (typeBinding3 == typeBinding4 || typeBinding3.isCompatibleWith(typeBinding4)) continue;
                return -1;
            }
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        LookupEnvironment lookupEnvironment = this.environment();
        if (methodBinding.isVarargs()) {
            TypeBinding typeBinding5;
            n4 = n - 1;
            if (n == n2) {
                typeBinding5 = typeBindingArray2[n4];
                typeBinding2 = typeBindingArray[n4];
                if (typeBinding5 != typeBinding2 && (n3 = this.parameterCompatibilityLevel(typeBinding2, typeBinding5, lookupEnvironment)) == -1) {
                    if (this.parameterCompatibilityLevel(typeBinding2, typeBinding5 = ((ArrayBinding)typeBinding5).elementsType(), lookupEnvironment) == -1) {
                        return -1;
                    }
                    n3 = 2;
                }
            } else {
                if (n < n2) {
                    typeBinding5 = ((ArrayBinding)typeBindingArray2[n4]).elementsType();
                    for (int i = n4; i < n2; ++i) {
                        typeBinding = typeBindingArray[i];
                        if (typeBinding5 == typeBinding || this.parameterCompatibilityLevel(typeBinding, typeBinding5, lookupEnvironment) != -1) continue;
                        return -1;
                    }
                } else if (n4 != n2) {
                    return -1;
                }
                n3 = 2;
            }
        } else if (n != n2) {
            return -1;
        }
        for (int i = 0; i < n4; ++i) {
            typeBinding = typeBindingArray[i];
            typeBinding2 = typeBindingArray2[i];
            if (typeBinding == typeBinding2) continue;
            int n5 = this.parameterCompatibilityLevel(typeBinding, typeBinding2, lookupEnvironment);
            if (n5 == -1) {
                return -1;
            }
            if (n5 <= n3) continue;
            n3 = n5;
        }
        return n3;
    }

    private int parameterCompatibilityLevel(TypeBinding typeBinding, TypeBinding typeBinding2, LookupEnvironment lookupEnvironment) {
        TypeBinding typeBinding3;
        if (typeBinding.isCompatibleWith(typeBinding2)) {
            return 0;
        }
        if (typeBinding.isBaseType() != typeBinding2.isBaseType() && ((typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding)) == typeBinding2 || typeBinding3.isCompatibleWith(typeBinding2))) {
            return 1;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        return ((CompilationUnitScope)scope2).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 2: {
                    return ((MethodScope)scope).referenceContext;
                }
                case 3: {
                    return ((ClassScope)scope).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)scope).referenceContext;
                }
            }
        } while ((scope = scope.parent) != null);
        return null;
    }

    int startIndex() {
        return 0;
    }
}

