/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class ParameterizedTypeBinding
extends ReferenceBinding
implements Substitution {
    public ReferenceBinding type;
    public TypeBinding[] arguments;
    public LookupEnvironment environment;
    public char[] genericTypeSignature;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public FieldBinding[] fields;
    public ReferenceBinding[] memberTypes;
    public MethodBinding[] methods;
    private ReferenceBinding enclosingType;

    public ParameterizedTypeBinding(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.enclosingType = referenceBinding2;
        this.initialize(referenceBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this);
        }
        if (typeBindingArray != null) {
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(typeBindingArray[i] instanceof UnresolvedReferenceBinding)) continue;
                ((UnresolvedReferenceBinding)typeBindingArray[i]).addWrapper(this);
            }
        }
        this.tagBits |= 0x1000000L;
    }

    public void boundCheck(Scope scope, TypeReference[] typeReferenceArray) {
        if ((this.tagBits & 0x400000L) == 0L) {
            boolean bl = false;
            TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
            if (this.arguments != null && typeVariableBindingArray != null) {
                int n = typeVariableBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    if (typeVariableBindingArray[i].boundCheck(this, this.arguments[i]) == 0) continue;
                    bl = true;
                    scope.problemReporter().typeMismatchError(this.arguments[i], typeVariableBindingArray[i], this.type, typeReferenceArray[i]);
                }
            }
            if (!bl) {
                this.tagBits |= 0x400000L;
            }
        }
    }

    @Override
    public boolean canBeInstantiated() {
        return (this.tagBits & 0x40000000L) == 0L && super.canBeInstantiated();
    }

    @Override
    public int kind() {
        return 260;
    }

    @Override
    public TypeBinding capture(Scope scope, int n) {
        if ((this.tagBits & 0x40000000L) == 0L) {
            return this;
        }
        TypeBinding[] typeBindingArray = this.arguments;
        int n2 = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n2];
        ReferenceBinding referenceBinding = scope.enclosingSourceType();
        if (referenceBinding != null) {
            referenceBinding = referenceBinding.outermostEnclosingType();
        }
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            typeBindingArray2[i] = typeBinding.kind() == 516 && ((WildcardBinding)typeBinding).otherBounds == null ? new CaptureBinding((WildcardBinding)typeBinding, referenceBinding, n) : typeBinding;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment.createParameterizedType(this.type, typeBindingArray2, this.enclosingType());
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding = typeBindingArray2[i];
            if (!typeBinding.isCapture()) continue;
            ((CaptureBinding)typeBinding).initializeBounds(scope, parameterizedTypeBinding);
        }
        return parameterizedTypeBinding;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, Map map, int n) {
        TypeBinding[] typeBindingArray;
        TypeBinding[] typeBindingArray2;
        ReferenceBinding referenceBinding;
        TypeBinding typeBinding2;
        TypeBinding typeBinding3;
        if ((this.tagBits & 0x20000000L) == 0L) {
            return;
        }
        if (typeBinding == TypeBinding.NULL) {
            return;
        }
        if (!(typeBinding instanceof ReferenceBinding)) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                typeBinding3 = this;
                typeBinding2 = typeBinding.findSuperTypeWithSameErasure(this.type);
                if (typeBinding2 != null) break;
                return;
            }
            default: {
                typeBinding3 = this.findSuperTypeWithSameErasure(typeBinding);
                if (typeBinding3 == null) {
                    return;
                }
                typeBinding2 = typeBinding;
            }
        }
        if ((referenceBinding = typeBinding3.enclosingType()) != null) {
            referenceBinding.collectSubstitutes(scope, typeBinding2.enclosingType(), map, n);
        }
        if (this.arguments == null) {
            return;
        }
        switch (typeBinding3.kind()) {
            case 2052: {
                typeBindingArray2 = typeBinding3.typeVariables();
                break;
            }
            case 260: {
                typeBindingArray2 = ((ParameterizedTypeBinding)typeBinding3).arguments;
                break;
            }
            case 1028: {
                map.clear();
                return;
            }
            default: {
                return;
            }
        }
        switch (typeBinding2.kind()) {
            case 2052: {
                typeBindingArray = typeBinding2.typeVariables();
                break;
            }
            case 260: {
                typeBindingArray = ((ParameterizedTypeBinding)typeBinding2).arguments;
                break;
            }
            case 1028: {
                map.clear();
                if (n == 0) {
                    map.put(TypeBinding.VOID, Binding.NO_TYPES);
                }
                return;
            }
            default: {
                return;
            }
        }
        int n2 = typeBindingArray2.length;
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding4 = typeBindingArray2[i];
            TypeBinding typeBinding5 = typeBindingArray[i];
            if (typeBinding4.isWildcard()) {
                typeBinding4.collectSubstitutes(scope, typeBinding5, map, n);
                continue;
            }
            if (typeBinding5.isWildcard()) {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding5;
                if (wildcardBinding.otherBounds == null) {
                    if (n != 2) continue;
                    switch (wildcardBinding.boundKind) {
                        case 1: {
                            typeBinding4.collectSubstitutes(scope, wildcardBinding.bound, map, 2);
                            break;
                        }
                        case 2: {
                            typeBinding4.collectSubstitutes(scope, wildcardBinding.bound, map, 1);
                            break;
                        }
                    }
                    continue;
                }
            }
            typeBinding4.collectSubstitutes(scope, typeBinding5, map, 0);
        }
    }

    @Override
    public void computeId() {
        this.id = Integer.MAX_VALUE;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        int n;
        Object object;
        ReferenceBinding referenceBinding;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && ((referenceBinding = this.enclosingType()).isParameterizedType() || referenceBinding.isRawType())) {
            object = referenceBinding.computeUniqueKey(false);
            for (n = 0; n < ((Object)object).length - 1; ++n) {
                stringBuffer.append((char)object[n]);
            }
            stringBuffer.append('.').append(this.sourceName());
        } else if (this.type.isLocalType()) {
            ReferenceBinding referenceBinding2;
            object = (LocalTypeBinding)this.type;
            referenceBinding = ((NestedTypeBinding)object).enclosingType();
            while ((referenceBinding2 = referenceBinding.enclosingType()) != null) {
                referenceBinding = referenceBinding2;
            }
            cArray = referenceBinding.computeUniqueKey(false);
            for (int i = 0; i < cArray.length - 1; ++i) {
                stringBuffer.append(cArray[i]);
            }
            stringBuffer.append('$');
            stringBuffer.append(((LocalTypeBinding)object).sourceStart);
        } else {
            object = this.type.computeUniqueKey(false);
            for (int i = 0; i < ((Object)object).length - 1; ++i) {
                stringBuffer.append((char)object[i]);
            }
        }
        object = null;
        if (this.arguments != null) {
            stringBuffer.append('<');
            for (TypeBinding typeBinding : this.arguments) {
                stringBuffer.append(typeBinding.computeUniqueKey(false));
                if (!(typeBinding instanceof CaptureBinding)) continue;
                object = ((CaptureBinding)typeBinding).sourceType;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(';');
        if (object != null && object != this.type) {
            stringBuffer.insert(0, "&");
            stringBuffer.insert(0, ((ReferenceBinding)object).computeUniqueKey(false));
        }
        n = stringBuffer.length();
        cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] constantPoolName() {
        return this.type.constantPoolName();
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        return new ParameterizedMethodBinding(this, methodBinding);
    }

    @Override
    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.type.sourceName());
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[i].debugName());
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    @Override
    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public TypeBinding erasure() {
        return this.type.erasure();
    }

    @Override
    public int fieldCount() {
        return this.type.fieldCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldBinding[] fields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        try {
            FieldBinding[] fieldBindingArray = this.type.fields();
            int n = fieldBindingArray.length;
            FieldBinding[] fieldBindingArray2 = new FieldBinding[n];
            for (int i = 0; i < n; ++i) {
                fieldBindingArray2[i] = new ParameterizedFieldBinding(this, fieldBindingArray[i]);
            }
            this.fields = fieldBindingArray2;
        }
        finally {
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            this.tagBits |= 0x2000L;
        }
        return this.fields;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            int n;
            char[] cArray;
            StringBuffer stringBuffer = new StringBuffer(10);
            if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
                cArray = this.enclosingType().genericTypeSignature();
                for (n = 0; n < cArray.length - 1; ++n) {
                    stringBuffer.append(cArray[n]);
                }
                stringBuffer.append('.').append(this.sourceName());
            } else {
                cArray = this.type.signature();
                for (n = 0; n < cArray.length - 1; ++n) {
                    stringBuffer.append(cArray[n]);
                }
            }
            if (this.arguments != null) {
                stringBuffer.append('<');
                n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(this.arguments[i].genericTypeSignature());
                }
                stringBuffer.append('>');
            }
            stringBuffer.append(';');
            int n2 = stringBuffer.length();
            this.genericTypeSignature = new char[n2];
            stringBuffer.getChars(0, n2, this.genericTypeSignature, 0);
        }
        return this.genericTypeSignature;
    }

    @Override
    public long getAnnotationTagBits() {
        return this.type.getAnnotationTagBits();
    }

    @Override
    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        block5: {
            int n;
            block4: {
                n = typeBindingArray.length;
                if ((this.tagBits & 0x8000L) == 0L) break block4;
                long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
                if (l < 0L) break block5;
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding = this.methods[i];
                    if (methodBinding.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                    }
                    return methodBinding;
                }
                break block5;
            }
            MethodBinding[] methodBindingArray = this.getMethods(TypeConstants.INIT);
            int n3 = methodBindingArray.length;
            block2: while (--n3 >= 0) {
                MethodBinding methodBinding = methodBindingArray[n3];
                TypeBinding[] typeBindingArray3 = methodBinding.parameters;
                if (typeBindingArray3.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    if (typeBindingArray3[i] != typeBindingArray[i]) continue block2;
                }
                return methodBinding;
            }
        }
        return null;
    }

    @Override
    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n = typeBindingArray.length;
        boolean bl = true;
        MethodBinding methodBinding = null;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l >= 0L) {
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding2 = this.methods[i];
                    bl = false;
                    if (methodBinding2.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                    }
                    if (methodBinding != null) {
                        return null;
                    }
                    methodBinding = methodBinding2;
                }
            }
        } else {
            MethodBinding[] methodBindingArray = this.getMethods(cArray);
            bl = methodBindingArray == Binding.NO_METHODS;
            int n3 = methodBindingArray.length;
            block2: while (--n3 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n3];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    if (typeBindingArray3[i] != typeBindingArray[i]) continue block2;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        if (methodBinding != null) {
            if (methodBinding.hasSubstitutedParameters()) {
                return null;
            }
            return methodBinding;
        }
        if (bl && (this.arguments == null || this.arguments.length <= 1)) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    @Override
    public FieldBinding getField(char[] cArray, boolean bl) {
        this.fields();
        return ReferenceBinding.binarySearch(cArray, this.fields);
    }

    @Override
    public ReferenceBinding getMemberType(char[] cArray) {
        this.memberTypes();
        int n = cArray.length;
        int n2 = this.memberTypes.length;
        while (--n2 >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n2];
            if (referenceBinding.sourceName.length != n || !CharOperation.equals(referenceBinding.sourceName, cArray)) continue;
            return referenceBinding;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if (this.methods != null && (l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n2 = (int)(l >> 32) - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n2];
            System.arraycopy(this.methods, n, methodBindingArray, 0, n2);
            return methodBindingArray;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] methodBindingArray = null;
        try {
            int n;
            MethodBinding[] methodBindingArray2 = this.type.getMethods(cArray);
            int n3 = methodBindingArray2.length;
            if (n3 == 0) {
                MethodBinding[] methodBindingArray3 = Binding.NO_METHODS;
                return methodBindingArray3;
            }
            methodBindingArray = new MethodBinding[n3];
            for (n = 0; n < n3; ++n) {
                methodBindingArray[n] = this.createParameterizedMethod(methodBindingArray2[n]);
            }
            if (this.methods == null) {
                MethodBinding[] methodBindingArray4 = new MethodBinding[n3];
                System.arraycopy(methodBindingArray, 0, methodBindingArray4, 0, n3);
                this.methods = methodBindingArray4;
            } else {
                n = n3 + this.methods.length;
                MethodBinding[] methodBindingArray5 = new MethodBinding[n];
                System.arraycopy(methodBindingArray, 0, methodBindingArray5, 0, n3);
                System.arraycopy(this.methods, 0, methodBindingArray5, n3, this.methods.length);
                if (n > 1) {
                    ReferenceBinding.sortMethods(methodBindingArray5, 0, n);
                }
                this.methods = methodBindingArray5;
            }
            MethodBinding[] methodBindingArray6 = methodBindingArray;
            return methodBindingArray6;
        }
        finally {
            if (methodBindingArray == null) {
                methodBindingArray = Binding.NO_METHODS;
                this.methods = Binding.NO_METHODS;
            }
        }
    }

    @Override
    public boolean hasMemberTypes() {
        return this.type.hasMemberTypes();
    }

    @Override
    public boolean implementsMethod(MethodBinding methodBinding) {
        return this.type.implementsMethod(methodBinding);
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        this.type = referenceBinding;
        this.sourceName = referenceBinding.sourceName;
        this.compoundName = referenceBinding.compoundName;
        this.fPackage = referenceBinding.fPackage;
        this.fileName = referenceBinding.fileName;
        this.modifiers = referenceBinding.modifiers & 0xBFFFFFFF;
        if (typeBindingArray != null) {
            this.modifiers |= 0x40000000;
        } else if (this.enclosingType != null) {
            this.modifiers |= this.enclosingType.modifiers & 0x40000000;
            this.tagBits |= this.enclosingType.tagBits & 0x20000000L;
        }
        if (typeBindingArray != null) {
            this.arguments = typeBindingArray;
            for (TypeBinding typeBinding : typeBindingArray) {
                boolean bl = typeBinding.isWildcard();
                if (bl) {
                    this.tagBits |= 0x40000000L;
                }
                if (!bl || ((WildcardBinding)typeBinding).boundKind != 0) {
                    this.tagBits |= 0x800000L;
                }
                this.tagBits |= typeBinding.tagBits & 0x20000000L;
            }
        }
        this.tagBits |= referenceBinding.tagBits & 0x1CL;
        this.tagBits &= 0xFFFFFFFFFFFF5FFFL;
    }

    protected void initializeArguments() {
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: {
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                if (this.type != parameterizedTypeBinding.type) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                if (this.arguments == null) {
                    return parameterizedTypeBinding.arguments == null;
                }
                int n = this.arguments.length;
                typeBindingArray = parameterizedTypeBinding.arguments;
                if (typeBindingArray == null || typeBindingArray.length != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.arguments[i].isTypeArgumentContainedBy(typeBindingArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 1028: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    @Override
    public boolean isIntersectingWith(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 260: {
                int n;
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                if (this.type != parameterizedTypeBinding.type) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                int n2 = this.arguments == null ? 0 : this.arguments.length;
                typeBindingArray = parameterizedTypeBinding.arguments;
                int n3 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                if (n != n2) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    if (this.arguments[i].isTypeArgumentIntersecting(typeBindingArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 2052: {
                int n;
                ReferenceBinding referenceBinding;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)typeBinding;
                if (this.type != sourceTypeBinding) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    ReferenceBinding referenceBinding2 = sourceTypeBinding.enclosingType();
                    if (referenceBinding2 == null) {
                        return false;
                    }
                    if ((referenceBinding2.tagBits & 0x40000000L) == 0L ? referenceBinding != referenceBinding2 : !referenceBinding.isEquivalentTo(sourceTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                int n4 = this.arguments == null ? 0 : this.arguments.length;
                TypeVariableBinding[] typeVariableBindingArray = sourceTypeBinding.typeVariables();
                int n5 = n = typeVariableBindingArray == null ? 0 : typeVariableBindingArray.length;
                if (n != n4) {
                    return false;
                }
                for (int i = 0; i < n4; ++i) {
                    if (this.arguments[i].isTypeArgumentIntersecting(typeVariableBindingArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 1028: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    @Override
    public boolean isParameterizedType() {
        return true;
    }

    @Override
    public boolean isRawSubstitution() {
        return this.isRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceBinding[] memberTypes() {
        if (this.memberTypes == null) {
            try {
                ReferenceBinding[] referenceBindingArray = this.type.memberTypes();
                int n = referenceBindingArray.length;
                ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[n];
                for (int i = 0; i < n; ++i) {
                    referenceBindingArray2[i] = this.environment.createParameterizedType(referenceBindingArray[i], null, this);
                }
                this.memberTypes = referenceBindingArray2;
            }
            finally {
                if (this.memberTypes == null) {
                    this.memberTypes = Binding.NO_MEMBER_TYPES;
                }
            }
        }
        return this.memberTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodBinding[] methods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        try {
            MethodBinding[] methodBindingArray = this.type.methods();
            int n = methodBindingArray.length;
            MethodBinding[] methodBindingArray2 = new MethodBinding[n];
            for (int i = 0; i < n; ++i) {
                methodBindingArray2[i] = this.createParameterizedMethod(methodBindingArray[i]);
            }
            this.methods = methodBindingArray2;
        }
        finally {
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
            this.tagBits |= 0x8000L;
        }
        return this.methods;
    }

    @Override
    public char[] qualifiedSourceName() {
        return this.type.qualifiedSourceName();
    }

    @Override
    public char[] readableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.'));
        } else {
            stringBuffer.append(CharOperation.concatWith(this.type.compoundName, '.'));
        }
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].readableName());
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        ReferenceBinding referenceBinding = BinaryTypeBinding.resolveType(this.type, this.environment, false);
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                BinaryTypeBinding.resolveType(this.arguments[i], this.environment, this, i);
            }
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
                this.environment.problemReporter.nonGenericTypeCannotBeParameterized(null, referenceBinding, this.arguments);
                return this;
            }
            if (n != typeVariableBindingArray.length) {
                this.environment.problemReporter.incorrectArityForParameterizedType(null, referenceBinding, this.arguments);
                return this;
            }
        }
        return this;
    }

    @Override
    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.'));
        } else {
            stringBuffer.append(this.type.sourceName);
        }
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].shortReadableName());
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] signature() {
        if (this.signature == null) {
            this.signature = this.type.signature();
        }
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        return this.type.sourceName();
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        ParameterizedTypeBinding parameterizedTypeBinding = this;
        while (true) {
            ReferenceBinding referenceBinding;
            TypeVariableBinding[] typeVariableBindingArray;
            int n;
            if (typeVariableBinding.rank < (n = (typeVariableBindingArray = parameterizedTypeBinding.type.typeVariables()).length) && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
                if (parameterizedTypeBinding.arguments == null) {
                    parameterizedTypeBinding.initializeArguments();
                }
                if (parameterizedTypeBinding.arguments != null) {
                    return parameterizedTypeBinding.arguments[typeVariableBinding.rank];
                }
            }
            if (parameterizedTypeBinding.isStatic() || !((referenceBinding = parameterizedTypeBinding.enclosingType()) instanceof ParameterizedTypeBinding)) break;
            parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
        }
        return typeVariableBinding;
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            ReferenceBinding referenceBinding = this.type.superclass();
            if (referenceBinding == null) {
                return null;
            }
            this.superclass = (ReferenceBinding)Scope.substitute((Substitution)this, referenceBinding);
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            if (this.type.isHierarchyBeingConnected()) {
                return Binding.NO_SUPERINTERFACES;
            }
            this.superInterfaces = Scope.substitute((Substitution)this, this.type.superInterfaces());
        }
        return this.superInterfaces;
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.type == unresolvedReferenceBinding) {
            this.type = referenceBinding;
            bl = true;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            if (referenceBinding2 != null) {
                this.enclosingType = (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding2);
            }
        }
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.arguments[i] != unresolvedReferenceBinding) continue;
                this.arguments[i] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                bl = true;
            }
        }
        if (bl) {
            this.initialize(this.type, this.arguments);
        }
    }

    @Override
    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        return this.type.syntheticEnclosingInstanceTypes();
    }

    @Override
    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.type.syntheticOuterLocalVariables();
    }

    @Override
    public char[] qualifiedPackageName() {
        return this.type.qualifiedPackageName();
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.isDeprecated()) {
            stringBuffer.append("deprecated ");
        }
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isEnum()) {
            stringBuffer.append("enum ");
        } else if (this.isAnnotationType()) {
            stringBuffer.append("@interface ");
        } else if (this.isClass()) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append("interface ");
        }
        stringBuffer.append(this.debugName());
        stringBuffer.append("\n\textends ");
        stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                stringBuffer.append("\n\timplements : ");
                n2 = this.superInterfaces.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.superInterfaces[n] != null ? this.superInterfaces[n].debugName() : "NULL TYPE");
                }
            }
        } else {
            stringBuffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType() != null) {
            stringBuffer.append("\n\tenclosing type : ");
            stringBuffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                stringBuffer.append("\n/*   fields   */");
                n2 = this.fields.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('\n').append(this.fields[n] != null ? this.fields[n].toString() : "NULL FIELD");
                }
            }
        } else {
            stringBuffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                stringBuffer.append("\n/*   methods   */");
                n2 = this.methods.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('\n').append(this.methods[n] != null ? this.methods[n].toString() : "NULL METHOD");
                }
            }
        } else {
            stringBuffer.append("NULL METHODS");
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    @Override
    public TypeVariableBinding[] typeVariables() {
        if (this.arguments == null) {
            return this.type.typeVariables();
        }
        return Binding.NO_TYPE_VARIABLES;
    }
}

