/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public class MethodVerifier {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    ReferenceBinding runtimeException = null;
    ReferenceBinding errorException = null;
    LookupEnvironment environment;
    private boolean allowCompatibleReturnTypes;

    MethodVerifier(LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.allowCompatibleReturnTypes = lookupEnvironment.globalOptions.complianceLevel >= 0x310000L && lookupEnvironment.globalOptions.sourceLevel < 0x310000L;
    }

    boolean areMethodsEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.doesMethodOverride(methodBinding, methodBinding2) && this.areReturnTypesEqual(methodBinding, methodBinding2);
    }

    boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n = typeBindingArray.length;
        if (n != typeBindingArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areTypesEqual(typeBindingArray[i], typeBindingArray2[i])) continue;
            return false;
        }
        return true;
    }

    boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType == methodBinding2.returnType) {
            return true;
        }
        if (methodBinding.returnType.isBaseType()) {
            return false;
        }
        if (!methodBinding.declaringClass.isInterface()) {
            if (methodBinding.declaringClass.id == 1) {
                return methodBinding2.returnType.isCompatibleWith(methodBinding.returnType);
            }
            return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType);
        }
        if (methodBinding2.declaringClass.id == 1) {
            return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType);
        }
        if (methodBinding.declaringClass.implementsInterface(methodBinding2.declaringClass, true)) {
            return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType);
        }
        if (methodBinding2.declaringClass.implementsInterface(methodBinding.declaringClass, true)) {
            return methodBinding2.returnType.isCompatibleWith(methodBinding.returnType);
        }
        return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType) || methodBinding2.returnType.isCompatibleWith(methodBinding.returnType);
    }

    boolean areReturnTypesEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areTypesEqual(methodBinding.returnType, methodBinding2.returnType)) {
            return true;
        }
        return this.allowCompatibleReturnTypes && methodBinding.declaringClass instanceof BinaryTypeBinding && methodBinding2.declaringClass instanceof BinaryTypeBinding && this.areReturnTypesCompatible(methodBinding, methodBinding2);
    }

    boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)typeBinding).resolvedType == typeBinding2;
        }
        if (typeBinding2 instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)typeBinding2).resolvedType == typeBinding;
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && this.type.superclass().isAbstract()) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || methodBinding.declaringClass == methodBinding2.declaringClass;
    }

    void checkAbstractMethod(MethodBinding methodBinding) {
        if (this.mustImplementAbstractMethod(methodBinding.declaringClass)) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding);
                methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            }
        }
    }

    void checkAgainstInheritedMethods(MethodBinding methodBinding, MethodBinding[] methodBindingArray, int n, MethodBinding[] methodBindingArray2) {
        if (this.type.isAnnotationType()) {
            this.problemReporter().annotationCannotOverrideMethod(methodBinding, methodBindingArray[n - 1]);
            return;
        }
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        int n2 = n;
        block0: while (--n2 >= 0) {
            MethodBinding methodBinding2 = methodBindingArray[n2];
            if (methodBinding.isStatic() != methodBinding2.isStatic()) {
                this.problemReporter(methodBinding).staticAndInstanceConflict(methodBinding, methodBinding2);
                continue;
            }
            methodBinding.modifiers = methodBinding2.isAbstract() ? (methodBinding2.declaringClass.isInterface() ? (methodBinding.modifiers |= 0x20000000) : (methodBinding.modifiers |= 0x30000000)) : (methodBinding.modifiers |= 0x10000000);
            if (!this.areReturnTypesEqual(methodBinding, methodBinding2) && this.reportIncompatibleReturnTypeError(methodBinding, methodBinding2)) continue;
            if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                this.checkExceptions(methodBinding, methodBinding2);
            }
            if (methodBinding2.isFinal()) {
                this.problemReporter(methodBinding).finalMethodCannotBeOverridden(methodBinding, methodBinding2);
            }
            if (!this.isAsVisible(methodBinding, methodBinding2)) {
                this.problemReporter(methodBinding).visibilityConflict(methodBinding, methodBinding2);
            }
            if (compilerOptions.reportDeprecationWhenOverridingDeprecatedMethod && methodBinding2.isViewedAsDeprecated() && (!methodBinding.isViewedAsDeprecated() || compilerOptions.reportDeprecationInsideDeprecatedCode)) {
                ReferenceBinding referenceBinding = methodBinding2.declaringClass;
                if (referenceBinding.isInterface()) {
                    int n3 = n;
                    while (--n3 >= 0) {
                        if (n2 == n3 || !methodBindingArray[n3].declaringClass.implementsInterface(referenceBinding, false)) continue;
                        continue block0;
                    }
                }
                this.problemReporter(methodBinding).overridesDeprecatedMethod(methodBinding, methodBinding2);
            }
            this.checkForBridgeMethod(methodBinding, methodBinding2, methodBindingArray2);
        }
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        if (methodBinding.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, methodBinding, methodBindingArray);
        }
        if (!methodBinding.isPublic()) {
            this.problemReporter().inheritedMethodReducesVisibility(this.type, methodBinding, methodBindingArray);
        }
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            int n = methodBindingArray.length;
            while (--n >= 0) {
                this.checkExceptions(methodBinding, methodBindingArray[n]);
            }
        }
    }

    void checkExceptions(MethodBinding methodBinding, MethodBinding methodBinding2) {
        ReferenceBinding[] referenceBindingArray = this.resolvedExceptionTypesFor(methodBinding);
        ReferenceBinding[] referenceBindingArray2 = this.resolvedExceptionTypesFor(methodBinding2);
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = referenceBindingArray[n];
            int n2 = referenceBindingArray2.length;
            while (--n2 > -1 && !this.isSameClassOrSubclassOf(referenceBinding, referenceBindingArray2[n2])) {
            }
            if (n2 != -1 || referenceBinding.isUncheckedException(false)) continue;
            this.problemReporter(methodBinding).incompatibleExceptionInThrowsClause(this.type, methodBinding, methodBinding2, referenceBinding);
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        int n2;
        if (!this.checkInheritedReturnTypes(methodBindingArray, n)) {
            return;
        }
        MethodBinding methodBinding = null;
        if (!this.type.isInterface()) {
            n2 = n;
            while (--n2 >= 0) {
                if (methodBindingArray[n2].isAbstract()) continue;
                methodBinding = methodBindingArray[n2];
                break;
            }
        }
        if (methodBinding == null) {
            if (!this.type.isAbstract()) {
                n2 = n;
                while (--n2 >= 0) {
                    if (!this.mustImplementAbstractMethod(methodBindingArray[n2].declaringClass)) continue;
                    TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                    if (typeDeclaration != null) {
                        MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBindingArray[0]);
                        methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBindingArray[0]);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBindingArray[0]);
                    }
                    return;
                }
            }
            return;
        }
        MethodBinding[] methodBindingArray2 = new MethodBinding[n - 1];
        int n3 = 0;
        int n4 = n;
        while (--n4 >= 0) {
            if (methodBindingArray[n4] == methodBinding) continue;
            methodBindingArray2[n3++] = methodBindingArray[n4];
        }
        this.checkConcreteInheritedMethod(methodBinding, methodBindingArray2);
    }

    boolean checkInheritedReturnTypes(MethodBinding[] methodBindingArray, int n) {
        MethodBinding methodBinding = methodBindingArray[0];
        int n2 = n;
        while (--n2 > 0 && this.areReturnTypesEqual(methodBinding, methodBindingArray[n2])) {
        }
        if (n2 == 0) {
            return true;
        }
        if (this.type.isInterface()) {
            int n3 = n;
            while (--n3 >= 0) {
                if (methodBindingArray[n3].declaringClass.id != 1) continue;
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n);
        return false;
    }

    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            int n2;
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.currentMethods.get(cArray[n])) == null && bl2) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            if (methodBindingArray2.length == 1 && methodBindingArray == null) {
                if (!bl || !methodBindingArray2[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray2[0]);
                continue;
            }
            int n3 = -1;
            MethodBinding[] methodBindingArray3 = new MethodBinding[methodBindingArray2.length];
            if (methodBindingArray != null) {
                for (MethodBinding methodBinding : methodBindingArray) {
                    int n4 = methodBindingArray2.length;
                    for (n2 = 0; n2 < n4; ++n2) {
                        MethodBinding methodBinding2 = this.computeSubstituteMethod(methodBindingArray2[n2], methodBinding);
                        if (methodBinding2 == null || !this.doesMethodOverride(methodBinding, methodBinding2)) continue;
                        methodBindingArray3[++n3] = methodBinding2;
                        methodBindingArray2[n2] = null;
                    }
                    if (n3 < 0) continue;
                    this.checkAgainstInheritedMethods(methodBinding, methodBindingArray3, n3 + 1, methodBindingArray2);
                    while (n3 >= 0) {
                        methodBindingArray3[n3--] = null;
                    }
                }
            }
            int n5 = methodBindingArray2.length;
            for (int i = 0; i < n5; ++i) {
                MethodBinding methodBinding;
                methodBinding = methodBindingArray2[i];
                if (methodBinding == null) continue;
                methodBindingArray3[++n3] = methodBinding;
                for (n2 = i + 1; n2 < n5; ++n2) {
                    MethodBinding methodBinding3 = methodBindingArray2[n2];
                    if (this.canSkipInheritedMethods(methodBinding, methodBinding3) || (methodBinding3 = this.computeSubstituteMethod(methodBinding3, methodBinding)) == null || !this.doesMethodOverride(methodBinding, methodBinding3)) continue;
                    methodBindingArray3[++n3] = methodBinding3;
                    methodBindingArray2[n2] = null;
                }
                if (n3 == -1) continue;
                if (n3 > 0) {
                    this.checkInheritedMethods(methodBindingArray3, n3 + 1);
                } else if (bl && methodBindingArray3[0].isAbstract()) {
                    this.checkAbstractMethod(methodBindingArray3[0]);
                }
                while (n3 >= 0) {
                    methodBindingArray3[n3--] = null;
                }
            }
        }
    }

    void checkPackagePrivateAbstractMethod(MethodBinding methodBinding) {
        PackageBinding packageBinding = methodBinding.declaringClass.fPackage;
        if (packageBinding == this.type.fPackage) {
            return;
        }
        ReferenceBinding referenceBinding = this.type.superclass();
        char[] cArray = methodBinding.selector;
        do {
            if (!referenceBinding.isValidBinding()) {
                return;
            }
            if (!referenceBinding.isAbstract()) {
                return;
            }
            if (packageBinding != referenceBinding.fPackage) continue;
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
            int n = methodBindingArray.length;
            while (--n >= 0) {
                MethodBinding methodBinding2 = methodBindingArray[n];
                if (methodBinding2.isPrivate() || methodBinding2.isConstructor() || methodBinding2.isDefaultAbstract() || !this.areMethodsEqual(methodBinding2, methodBinding)) continue;
                return;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != methodBinding.declaringClass);
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, methodBinding);
    }

    void computeInheritedMethods() {
        ReferenceBinding referenceBinding = this.type.isInterface() ? this.type.scope.getJavaLangObject() : this.type.superclass();
        this.computeInheritedMethods(referenceBinding, this.type.superInterfaces());
    }

    void computeInheritedMethods(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2;
        MethodBinding[] methodBindingArray;
        Object object;
        int n3;
        ReferenceBinding referenceBinding2;
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        HashtableOfObject hashtableOfObject = new HashtableOfObject(3);
        boolean bl = true;
        for (referenceBinding2 = referenceBinding; referenceBinding2 != null && referenceBinding2.isValidBinding(); referenceBinding2 = referenceBinding2.superclass()) {
            if (bl) {
                if (referenceBinding2.isAbstract()) {
                    referenceBindingArray3 = referenceBinding2.superInterfaces();
                    if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                        if (referenceBindingArray2 == null) {
                            referenceBindingArray2 = referenceBindingArray3;
                            n4 = referenceBindingArray2.length;
                        } else {
                            int n5 = referenceBindingArray3.length;
                            if (n4 + n5 >= referenceBindingArray2.length) {
                                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                                referenceBindingArray2 = new ReferenceBinding[n4 + n5 + 5];
                                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
                            }
                            block1: for (n3 = 0; n3 < n5; ++n3) {
                                object = referenceBindingArray3[n3];
                                for (int i = 0; i < n4; ++i) {
                                    if (object == referenceBindingArray2[i]) continue block1;
                                }
                                referenceBindingArray2[n4++] = object;
                            }
                        }
                    }
                } else {
                    bl = false;
                }
            }
            methodBindingArray = referenceBinding2.unResolvedMethods();
            n3 = methodBindingArray.length;
            block3: while (--n3 >= 0) {
                MethodBinding[] methodBindingArray2;
                MethodBinding[] methodBindingArray3;
                int n6;
                object = methodBindingArray[n3];
                if (((MethodBinding)object).isPrivate() || ((MethodBinding)object).isConstructor() || ((MethodBinding)object).isDefaultAbstract()) continue;
                MethodBinding[] methodBindingArray4 = (MethodBinding[])this.inheritedMethods.get(((MethodBinding)object).selector);
                if (methodBindingArray4 != null) {
                    n6 = methodBindingArray4.length;
                    for (int i = 0; i < n6; ++i) {
                        if (methodBindingArray4[i].declaringClass == ((MethodBinding)object).declaringClass || !this.areMethodsEqual(methodBindingArray4[i], (MethodBinding)object)) continue;
                        if (!((MethodBinding)object).isDefault() || !((MethodBinding)object).isAbstract()) continue block3;
                        this.checkPackagePrivateAbstractMethod((MethodBinding)object);
                        continue block3;
                    }
                }
                if ((methodBindingArray3 = (MethodBinding[])hashtableOfObject.get(((MethodBinding)object).selector)) != null) {
                    n2 = methodBindingArray3.length;
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (this.areMethodsEqual(methodBindingArray3[n6], (MethodBinding)object)) continue block3;
                    }
                }
                if (!((MethodBinding)object).isDefault() || ((MethodBinding)object).declaringClass.fPackage == this.type.fPackage) {
                    if (methodBindingArray4 == null) {
                        methodBindingArray4 = new MethodBinding[]{object};
                    } else {
                        n6 = methodBindingArray4.length;
                        MethodBinding[] methodBindingArray5 = methodBindingArray4;
                        methodBindingArray4 = new MethodBinding[n6 + 1];
                        System.arraycopy(methodBindingArray5, 0, methodBindingArray4, 0, n6);
                        methodBindingArray4[n6] = object;
                    }
                    this.inheritedMethods.put(((MethodBinding)object).selector, methodBindingArray4);
                    continue;
                }
                if (methodBindingArray3 == null) {
                    methodBindingArray3 = new MethodBinding[]{object};
                } else {
                    n6 = methodBindingArray3.length;
                    MethodBinding[] methodBindingArray6 = methodBindingArray3;
                    methodBindingArray3 = new MethodBinding[n6 + 1];
                    System.arraycopy(methodBindingArray6, 0, methodBindingArray3, 0, n6);
                    methodBindingArray3[n6] = object;
                }
                hashtableOfObject.put(((MethodBinding)object).selector, methodBindingArray3);
                if (((MethodBinding)object).isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, (MethodBinding)object);
                }
                if ((methodBindingArray2 = (MethodBinding[])this.currentMethods.get(((MethodBinding)object).selector)) == null) continue;
                n = methodBindingArray2.length;
                for (n2 = 0; n2 < n; ++n2) {
                    if (!this.areMethodsEqual(methodBindingArray2[n2], (MethodBinding)object)) continue;
                    this.problemReporter().overridesPackageDefaultMethod(methodBindingArray2[n2], (MethodBinding)object);
                    continue block3;
                }
            }
        }
        if (n4 == 0) {
            return;
        }
        methodBindingArray = this.findSuperinterfaceCollisions(referenceBinding, referenceBindingArray);
        for (n3 = 0; n3 < n4; ++n3) {
            Binding binding;
            int n7;
            referenceBinding2 = referenceBindingArray2[n3];
            if (!referenceBinding2.isValidBinding() || methodBindingArray != null && methodBindingArray.includes(referenceBinding2)) continue;
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                int n8 = referenceBindingArray3.length;
                if (n4 + n8 >= referenceBindingArray2.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n4 + n8 + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
                }
                block8: for (n7 = 0; n7 < n8; ++n7) {
                    binding = referenceBindingArray3[n7];
                    for (int i = 0; i < n4; ++i) {
                        if (binding == referenceBindingArray2[i]) continue block8;
                    }
                    referenceBindingArray2[n4++] = binding;
                }
            }
            object = referenceBinding2.unResolvedMethods();
            n7 = ((MethodBinding[])object).length;
            block10: while (--n7 >= 0) {
                binding = object[n7];
                MethodBinding[] methodBindingArray7 = (MethodBinding[])this.inheritedMethods.get(binding.selector);
                if (methodBindingArray7 == null) {
                    methodBindingArray7 = new MethodBinding[]{binding};
                } else {
                    n2 = methodBindingArray7.length;
                    for (n = 0; n < n2; ++n) {
                        if (this.isInterfaceMethodImplemented((MethodBinding)binding, methodBindingArray7[n], referenceBinding2)) continue block10;
                    }
                    MethodBinding[] methodBindingArray8 = methodBindingArray7;
                    methodBindingArray7 = new MethodBinding[n2 + 1];
                    System.arraycopy(methodBindingArray8, 0, methodBindingArray7, 0, n2);
                    methodBindingArray7[n2] = binding;
                }
                this.inheritedMethods.put(binding.selector, methodBindingArray7);
            }
        }
    }

    void computeMethods() {
        MethodBinding[] methodBindingArray = this.type.methods();
        int n = methodBindingArray.length;
        this.currentMethods = new HashtableOfObject(n == 0 ? 1 : n);
        int n2 = n;
        while (--n2 >= 0) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (methodBinding.isConstructor() || methodBinding.isDefaultAbstract()) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(methodBinding.selector);
            if (methodBindingArray2 == null) {
                methodBindingArray2 = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray3 = methodBindingArray2;
                methodBindingArray2 = new MethodBinding[methodBindingArray2.length + 1];
                System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, methodBindingArray2.length - 1);
            }
            methodBindingArray2[methodBindingArray2.length - 1] = methodBinding;
            this.currentMethods.put(methodBinding.selector, methodBindingArray2);
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        return methodBinding;
    }

    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.areParametersEqual(methodBinding, methodBinding2);
    }

    boolean isAsVisible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.modifiers == methodBinding.modifiers) {
            return true;
        }
        if (methodBinding.isPublic()) {
            return true;
        }
        if (methodBinding2.isPublic()) {
            return false;
        }
        if (methodBinding.isProtected()) {
            return true;
        }
        if (methodBinding2.isProtected()) {
            return false;
        }
        return !methodBinding.isPrivate();
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        return this.areParametersEqual(methodBinding2, methodBinding) && methodBinding2.declaringClass.implementsInterface(referenceBinding, true);
    }

    boolean isSameClassOrSubclassOf(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        do {
            if (referenceBinding != referenceBinding2) continue;
            return true;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    boolean mustImplementAbstractMethod(ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2;
        if (referenceBinding.isClass()) {
            for (referenceBinding2 = this.type.superclass(); referenceBinding2.isAbstract() && referenceBinding2 != referenceBinding; referenceBinding2 = referenceBinding2.superclass()) {
            }
        } else {
            if (this.type.implementsInterface(referenceBinding, false)) {
                if (this.type.isAbstract()) {
                    return false;
                }
                if (!referenceBinding2.implementsInterface(referenceBinding, true)) {
                    return true;
                }
            }
            while (referenceBinding2.isAbstract() && !referenceBinding2.implementsInterface(referenceBinding, false)) {
                referenceBinding2 = referenceBinding2.superclass();
            }
        }
        return referenceBinding2.isAbstract();
    }

    boolean mustImplementAbstractMethods() {
        return !this.type.isInterface() && !this.type.isAbstract();
    }

    ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    ProblemReporter problemReporter(MethodBinding methodBinding) {
        ProblemReporter problemReporter = this.problemReporter();
        if (methodBinding.declaringClass == this.type && methodBinding.sourceMethod() != null) {
            problemReporter.referenceContext = methodBinding.sourceMethod();
        }
        return problemReporter;
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        return null;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        this.problemReporter(methodBinding).incompatibleReturnType(methodBinding, methodBinding2);
        return true;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding methodBinding) {
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return referenceBindingArray;
        }
        if (!(methodBinding.declaringClass instanceof BinaryTypeBinding)) {
            return Binding.NO_EXCEPTIONS;
        }
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            referenceBindingArray[n] = BinaryTypeBinding.resolveType(referenceBindingArray[n], this.environment, true);
        }
        return referenceBindingArray;
    }

    void verify(SourceTypeBinding sourceTypeBinding) {
        this.type = sourceTypeBinding;
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("MethodVerifier for type: ");
        stringBuffer.append(this.type.readableName());
        stringBuffer.append('\n');
        stringBuffer.append("\t-inherited methods: ");
        stringBuffer.append(this.inheritedMethods);
        return stringBuffer.toString();
    }
}

