/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int n = this.expressions.length;
            for (int i = 0; i < n; ++i) {
                flowInfo = this.expressions[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        int n2 = this.expressions == null ? 0 : this.expressions.length;
        codeStream.generateInlinedValue(n2);
        codeStream.newArray(this.binding);
        if (this.expressions != null) {
            int n3 = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            block5: for (int i = 0; i < n2; ++i) {
                Expression expression = this.expressions[i];
                if (expression.constant != Constant.NotAConstant) {
                    switch (n3) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 10: {
                            if (expression.constant.longValue() == 0L) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expression.generateCode(blockScope, codeStream, true);
                            codeStream.arrayAtPut(n3, false);
                            break;
                        }
                        case 8: 
                        case 9: {
                            double d = expression.constant.doubleValue();
                            if (d != -0.0 && d == 0.0) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expression.generateCode(blockScope, codeStream, true);
                            codeStream.arrayAtPut(n3, false);
                            break;
                        }
                        case 5: {
                            if (!expression.constant.booleanValue()) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expression.generateCode(blockScope, codeStream, true);
                            codeStream.arrayAtPut(n3, false);
                            break;
                        }
                        default: {
                            if (expression instanceof NullLiteral) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expression.generateCode(blockScope, codeStream, true);
                            codeStream.arrayAtPut(n3, false);
                            break;
                        }
                    }
                    continue;
                }
                if (expression instanceof NullLiteral) continue;
                codeStream.dup();
                codeStream.generateInlinedValue(i);
                expression.generateCode(blockScope, codeStream, true);
                codeStream.arrayAtPut(n3, false);
            }
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('{');
        if (this.expressions != null) {
            int n2 = 20;
            for (int i = 0; i < this.expressions.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                this.expressions[i].printExpression(0, stringBuffer);
                if (--n2 != 0) continue;
                stringBuffer.append('\n');
                ArrayInitializer.printIndent(n + 1, stringBuffer);
                n2 = 20;
            }
        }
        return stringBuffer.append('}');
    }

    @Override
    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        this.constant = Constant.NotAConstant;
        if (typeBinding instanceof ArrayBinding) {
            TypeBinding typeBinding2;
            if ((this.bits & 1) == 0 && !(typeBinding2 = typeBinding.leafComponentType()).isReifiable()) {
                blockScope.problemReporter().illegalGenericArray(typeBinding2, this);
            }
            this.binding = (ArrayBinding)typeBinding;
            this.resolvedType = this.binding;
            if (this.expressions == null) {
                return this.binding;
            }
            typeBinding2 = this.binding.elementsType();
            for (Expression expression : this.expressions) {
                TypeBinding typeBinding3;
                expression.setExpectedType(typeBinding2);
                TypeBinding typeBinding4 = typeBinding3 = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(blockScope, typeBinding2) : expression.resolveType(blockScope);
                if (typeBinding3 == null) {
                    return null;
                }
                if (typeBinding2 != typeBinding3) {
                    blockScope.compilationUnitScope().recordTypeConversion(typeBinding2, typeBinding3);
                }
                if (expression.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding2) || typeBinding2.isBaseType() && BaseTypeBinding.isWidening(typeBinding2.id, typeBinding3.id) || typeBinding3.isCompatibleWith(typeBinding2)) {
                    expression.computeConversion(blockScope, typeBinding2, typeBinding3);
                    continue;
                }
                if (blockScope.isBoxingCompatibleWith(typeBinding3, typeBinding2) || typeBinding3.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding2.isBaseType() && expression.isConstantValueOfTypeAssignableToType(typeBinding3, blockScope.environment().computeBoxingType(typeBinding2))) {
                    expression.computeConversion(blockScope, typeBinding2, typeBinding3);
                    continue;
                }
                blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding2, expression);
                return null;
            }
            return this.binding;
        }
        TypeBinding typeBinding5 = null;
        int n = 1;
        if (this.expressions == null) {
            typeBinding5 = blockScope.getJavaLangObject();
        } else {
            Expression expression = this.expressions[0];
            while (expression != null && expression instanceof ArrayInitializer) {
                ++n;
                Expression[] expressionArray = ((ArrayInitializer)expression).expressions;
                if (expressionArray == null) {
                    typeBinding5 = blockScope.getJavaLangObject();
                    expression = null;
                    break;
                }
                expression = ((ArrayInitializer)expression).expressions[0];
            }
            if (expression != null) {
                typeBinding5 = expression.resolveType(blockScope);
            }
            int n2 = this.expressions.length;
            for (int i = 1; i < n2; ++i) {
                expression = this.expressions[i];
                if (expression == null) continue;
                expression.resolveType(blockScope);
            }
        }
        if (typeBinding5 != null) {
            this.resolvedType = blockScope.createArrayType(typeBinding5, n);
            if (typeBinding != null) {
                blockScope.problemReporter().typeMismatchError(this.resolvedType, typeBinding, this);
            }
        }
        return null;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expressions != null) {
            int n = this.expressions.length;
            for (int i = 0; i < n; ++i) {
                this.expressions[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

