/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    private String[] attributeNames;
    private String[] propertyNames;
    private boolean ignoreMissingProperty = true;

    public SetPropertiesRule(Digester digester) {
        this();
    }

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String string, String string2) {
        this.attributeNames = new String[1];
        this.attributeNames[0] = string;
        this.propertyNames = new String[1];
        this.propertyNames[0] = string2;
    }

    public SetPropertiesRule(String[] stringArray, String[] stringArray2) {
        this.attributeNames = new String[stringArray.length];
        for (String this.attributeNames[var3_3] : stringArray) {
        }
        this.propertyNames = new String[stringArray2.length];
        for (String this.propertyNames[var3_3] : stringArray2) {
        }
    }

    @Override
    public void begin(Attributes attributes) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        if (this.attributeNames != null) {
            n = this.attributeNames.length;
        }
        int n2 = 0;
        if (this.propertyNames != null) {
            n2 = this.propertyNames.length;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object object;
            boolean bl;
            String string = attributes.getLocalName(i);
            if ("".equals(string)) {
                string = attributes.getQName(i);
            }
            String string2 = attributes.getValue(i);
            for (int j = 0; j < n; ++j) {
                if (!string.equals(this.attributeNames[j])) continue;
                if (j < n2) {
                    string = this.propertyNames[j];
                    break;
                }
                string = null;
                break;
            }
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + string + "' to '" + string2 + "'");
            }
            if (!this.ignoreMissingProperty && string != null && !(bl = PropertyUtils.isWriteable(object = this.digester.peek(), string))) {
                throw new NoSuchMethodException("Property " + string + " can't be set");
            }
            if (string == null) continue;
            hashMap.put(string, string2);
        }
        Object object = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            if (object != null) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set " + object.getClass().getName() + " properties");
            } else {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
            }
        }
        BeanUtils.populate(object, hashMap);
    }

    public void addAlias(String string, String string2) {
        if (this.attributeNames == null) {
            this.attributeNames = new String[1];
            this.attributeNames[0] = string;
            this.propertyNames = new String[1];
            this.propertyNames[0] = string2;
        } else {
            int n = this.attributeNames.length;
            String[] stringArray = new String[n + 1];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.attributeNames[i];
            }
            stringArray[n] = string;
            String[] stringArray2 = new String[n + 1];
            for (int i = 0; i < n && i < this.propertyNames.length; ++i) {
                stringArray2[i] = this.propertyNames[i];
            }
            stringArray2[n] = string2;
            this.propertyNames = stringArray2;
            this.attributeNames = stringArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SetPropertiesRule[");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isIgnoreMissingProperty() {
        return this.ignoreMissingProperty;
    }

    public void setIgnoreMissingProperty(boolean bl) {
        this.ignoreMissingProperty = bl;
    }
}

