/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class FloatArrayConverter
extends AbstractArrayConverter {
    private static float[] model = new float[0];

    public FloatArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public FloatArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                float[] fArray = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    fArray[i] = Float.parseFloat(stringArray[i]);
                }
                return fArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            float[] fArray = new float[list.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = Float.parseFloat((String)list.get(i));
            }
            return fArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

