/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRTemplateElement
implements JRStyleContainer,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Random randomId = new Random();
    private String key;
    private Byte mode = null;
    private Color forecolor = null;
    private Color backcolor = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle = null;
    private final String id;

    protected JRTemplateElement(JRDefaultStyleProvider jRDefaultStyleProvider) {
        this.defaultStyleProvider = jRDefaultStyleProvider;
        this.id = this.createId();
    }

    protected JRTemplateElement(JRElement jRElement) {
        this.setElement(jRElement);
        this.id = this.createId();
    }

    protected JRTemplateElement(String string) {
        this.id = string;
    }

    private String createId() {
        return System.identityHashCode(this) + "_" + System.currentTimeMillis() + "_" + randomId.nextInt();
    }

    protected void setElement(JRElement jRElement) {
        this.parentStyle = jRElement.getStyle();
        this.setKey(jRElement.getKey());
        this.mode = jRElement.getOwnMode();
        this.forecolor = jRElement.getOwnForecolor();
        this.backcolor = jRElement.getOwnBackcolor();
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    public Byte getOwnMode() {
        return this.mode;
    }

    protected void setMode(byte by) {
        this.mode = new Byte(by);
    }

    protected void setMode(Byte by) {
        this.mode = by;
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.forecolor;
    }

    protected void setForecolor(Color color) {
        this.forecolor = color;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    protected void setBackcolor(Color color) {
        this.backcolor = color;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }
}

