/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintText;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.fill.JRTemplateText;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillTextField
extends JRFillTextElement
implements JRTextField {
    private JRGroup evaluationGroup = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;

    protected JRFillTextField(JRBaseFiller jRBaseFiller, JRTextField jRTextField, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRTextField, jRFillObjectFactory);
        this.evaluationGroup = jRFillObjectFactory.getGroup(jRTextField.getEvaluationGroup());
    }

    protected JRFillTextField(JRFillTextField jRFillTextField, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillTextField, jRFillCloneFactory);
        this.evaluationGroup = jRFillTextField.evaluationGroup;
    }

    @Override
    public boolean isStretchWithOverflow() {
        return ((JRTextField)this.parent).isStretchWithOverflow();
    }

    @Override
    public void setStretchWithOverflow(boolean bl) {
    }

    @Override
    public byte getEvaluationTime() {
        return ((JRTextField)this.parent).getEvaluationTime();
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return ((JRTextField)this.parent).getOwnPattern();
    }

    @Override
    public void setPattern(String string) {
    }

    @Override
    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return ((JRTextField)this.parent).isOwnBlankWhenNull();
    }

    @Override
    public void setBlankWhenNull(boolean bl) {
    }

    @Override
    public void setBlankWhenNull(Boolean bl) {
    }

    @Override
    public byte getHyperlinkType() {
        return ((JRTextField)this.parent).getHyperlinkType();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRTextField)this.parent).getHyperlinkTarget();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return ((JRTextField)this.parent).getExpression();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRTextField)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRTextField)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRTextField)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRTextField)this.parent).getHyperlinkPageExpression();
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateText getJRTemplateText() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateText jRTemplateText = (JRTemplateText)this.getTemplate(jRStyle);
        if (jRTemplateText == null) {
            jRTemplateText = new JRTemplateText(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.setTemplatePattern(jRTemplateText);
            this.registerTemplate(jRStyle, jRTemplateText);
        }
        return jRTemplateText;
    }

    protected void setTemplatePattern(JRTemplateText jRTemplateText) {
        Class clazz;
        if (this.getExpression() != null && !String.class.equals((Object)(clazz = this.getExpression().getValueClass()))) {
            jRTemplateText.setValueClassName(clazz.getName());
            String string = this.getTemplatePattern();
            if (string != null) {
                jRTemplateText.setPattern(string);
            }
            if (!this.filler.hasMasterFormatFactory()) {
                jRTemplateText.setFormatFactoryClass(this.filler.getFormatFactory().getClass().getName());
            }
            if (!this.filler.hasMasterLocale()) {
                jRTemplateText.setLocaleCode(JRDataUtils.getLocaleCode(this.filler.getLocale()));
            }
            if (!this.filler.hasMasterTimeZone() && Date.class.isAssignableFrom(clazz)) {
                jRTemplateText.setTimeZoneId(JRDataUtils.getTimeZoneId(this.filler.getTimeZone()));
            }
        }
    }

    @Override
    protected void evaluate(byte by) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateText(by);
        }
    }

    protected void evaluateText(byte by) throws JRException {
        Object object;
        Object object2 = this.evaluateExpression(this.getExpression(), by);
        if (object2 == null) {
            if (this.isBlankWhenNull()) {
                object2 = "";
            }
        } else {
            object = this.getFormat();
            if (object != null) {
                object2 = ((Format)object).format(object2);
            }
        }
        object = String.valueOf(object2);
        String string = this.getRawText();
        this.setRawText((String)object);
        this.setTextStart(0);
        this.setTextEnd(0);
        this.setValueRepeating(string == null && object == null || string != null && string.equals(object));
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), by);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), by);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), by);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), by);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), by);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, by);
    }

    @Override
    protected boolean prepare(int n, boolean bl) throws JRException {
        boolean bl2 = false;
        super.prepare(n, bl);
        if (!this.isToPrint()) {
            return bl2;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        if (this.isEvaluateNow()) {
            if (bl) {
                if (this.getPositionType() == 3) {
                    this.setTextStart(0);
                    this.setTextEnd(0);
                }
                if ((this.getTextEnd() >= this.getText().length() || !this.isStretchWithOverflow() || this.getRotation() != 0) && this.isAlreadyPrinted()) {
                    if (this.isPrintWhenDetailOverflows()) {
                        this.setTextStart(0);
                        this.setTextEnd(0);
                        bl4 = true;
                    } else {
                        bl3 = false;
                    }
                }
                if (bl3 && this.isPrintWhenExpressionNull() && !this.isPrintRepeatedValues() && this.isValueRepeating()) {
                    bl3 = false;
                }
            } else if (!(!this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()))) {
                bl3 = false;
            }
            if (bl3) {
                if (n >= this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                    if (this.getTextEnd() < this.getText().length() || this.getTextEnd() == 0) {
                        if (this.isStretchWithOverflow() && this.getRotation() == 0) {
                            this.chopTextElement(n - this.getRelativeY() + this.getY() + this.getBandBottomY());
                            if (this.getTextEnd() < this.getText().length()) {
                                bl2 = true;
                            }
                        } else {
                            this.chopTextElement(0);
                        }
                    } else {
                        bl3 = false;
                    }
                } else {
                    bl3 = false;
                    bl2 = true;
                }
            }
            if (bl3 && this.isRemoveLineWhenBlank() && this.getText().substring(this.getTextStart(), this.getTextEnd()).trim().length() == 0) {
                bl3 = false;
            }
        } else {
            if (bl && this.isAlreadyPrinted()) {
                if (this.isPrintWhenDetailOverflows()) {
                    bl4 = true;
                } else {
                    bl3 = false;
                }
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
        }
        this.setToPrint(bl3);
        this.setReprinted(bl4);
        return bl2;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintText jRTemplatePrintText;
        JRRecordedValuesPrintText jRRecordedValuesPrintText;
        byte by = this.getEvaluationTime();
        if (this.isEvaluateAuto()) {
            jRRecordedValuesPrintText = new JRRecordedValuesPrintText(this.getJRTemplateText());
            jRTemplatePrintText = jRRecordedValuesPrintText;
        } else {
            jRTemplatePrintText = new JRTemplatePrintText(this.getJRTemplateText());
            jRRecordedValuesPrintText = null;
        }
        jRTemplatePrintText.setX(this.getX());
        jRTemplatePrintText.setY(this.getRelativeY());
        jRTemplatePrintText.setWidth(this.getWidth());
        if (this.getRotation() == 0) {
            jRTemplatePrintText.setHeight(this.getStretchHeight());
        } else {
            jRTemplatePrintText.setHeight(this.getHeight());
        }
        jRTemplatePrintText.setRunDirection(this.getRunDirection());
        if (this.isEvaluateNow()) {
            this.copy(jRTemplatePrintText);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(jRRecordedValuesPrintText);
        } else {
            this.filler.addBoundElement(this, jRTemplatePrintText, by, this.getEvaluationGroup(), this.band);
        }
        return jRTemplatePrintText;
    }

    protected void copy(JRPrintText jRPrintText) {
        jRPrintText.setLineSpacingFactor(this.getLineSpacingFactor());
        jRPrintText.setLeadingOffset(this.getLeadingOffset());
        jRPrintText.setTextHeight(this.getTextHeight());
        jRPrintText.setText(this.textChopper.chop(this, this.getTextStart(), this.getTextEnd()));
        jRPrintText.setAnchorName(this.getAnchorName());
        jRPrintText.setHyperlinkReference(this.getHyperlinkReference());
        jRPrintText.setHyperlinkAnchor(this.getHyperlinkAnchor());
        jRPrintText.setHyperlinkPage(this.getHyperlinkPage());
        jRPrintText.setHyperlinkTooltip(this.getHyperlinkTooltip());
        jRPrintText.setBookmarkLevel(this.getBookmarkLevel());
        jRPrintText.setHyperlinkParameters(this.hyperlinkParameters);
    }

    protected Format getFormat() {
        Format format = null;
        JRExpression jRExpression = this.getExpression();
        if (jRExpression != null) {
            Class clazz = jRExpression.getValueClass();
            if (Date.class.isAssignableFrom(clazz)) {
                format = this.filler.getDateFormat(this.getPattern());
            } else if (Number.class.isAssignableFrom(clazz)) {
                format = this.filler.getNumberFormat(this.getPattern());
            }
        }
        return format;
    }

    protected String getTemplatePattern() {
        String string = null;
        String string2 = this.getPattern();
        Format format = this.getFormat();
        JRExpression jRExpression = this.getExpression();
        if (format != null && jRExpression != null) {
            Class clazz = jRExpression.getValueClass();
            if (Date.class.isAssignableFrom(clazz)) {
                if (format instanceof SimpleDateFormat) {
                    string = ((SimpleDateFormat)format).toPattern();
                }
            } else if (Number.class.isAssignableFrom(clazz) && format instanceof DecimalFormat) {
                string = ((DecimalFormat)format).toPattern();
            }
        }
        if (string == null) {
            string = string2;
        }
        return string;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getTextField(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeTextField(this);
    }

    @Override
    protected void resolveElement(JRPrintElement jRPrintElement, byte by) throws JRException {
        this.evaluateText(by);
        this.chopTextElement(0);
        this.copy((JRPrintText)jRPrintElement);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRTextField)this.parent).getBookmarkLevel();
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return new JRFillTextField(this, jRFillCloneFactory);
    }

    @Override
    protected void collectDelayedEvaluations() {
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRTextField)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRTextField)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRTextField)this.parent).getHyperlinkTooltipExpression();
    }
}

