/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdk13Compiler
extends JRAbstractMultiClassCompiler {
    static final Log log = LogFactory.getLog(JRJdk13Compiler.class);
    private static final int MODERN_COMPILER_SUCCESS = 0;

    @Override
    public String compileClasses(File[] fileArray, String string) throws JRException {
        String[] stringArray = new String[fileArray.length + 2];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getPath();
        }
        stringArray[fileArray.length] = "-classpath";
        stringArray[fileArray.length + 1] = string;
        String string2 = null;
        try {
            Class clazz = JRClassLoader.loadClassForName("com.sun.tools.javac.Main");
            Object t = clazz.newInstance();
            try {
                Method method = clazz.getMethod("compile", String[].class, PrintWriter.class);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = (Integer)method.invoke(t, stringArray, new PrintWriter(byteArrayOutputStream));
                if (n != 0) {
                    string2 = byteArrayOutputStream.toString();
                } else if (log.isInfoEnabled() && byteArrayOutputStream.size() > 0) {
                    log.info(byteArrayOutputStream.toString());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Method method = clazz.getMethod("compile", String[].class);
                int n = (Integer)method.invoke(t, new Object[]{stringArray});
                if (n != 0) {
                    string2 = "See error messages above.";
                }
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(fileArray[i].getPath());
                stringBuffer.append(' ');
            }
            throw new JRException("Error compiling report java source files : " + stringBuffer, exception);
        }
        return string2;
    }
}

