/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRAbstractExporter
implements JRExporter {
    protected Map parameters = new HashMap();
    protected List jasperPrintList = null;
    protected JasperPrint jasperPrint = null;
    protected boolean isModeBatch = true;
    protected int startPageIndex = 0;
    protected int endPageIndex = 0;
    protected int globalOffsetX = 0;
    protected int globalOffsetY = 0;
    protected ClassLoader classLoader = null;
    protected boolean classLoaderSet = false;
    protected URLStreamHandlerFactory urlHandlerFactory = null;
    protected boolean urlHandlerFactorySet = false;
    private LinkedList elementOffsetStack = new LinkedList();
    private int elementOffsetX = this.globalOffsetX;
    private int elementOffsetY = this.globalOffsetY;
    private Map penBoxes = new HashMap();
    protected final JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected Map dateFormatCache = new HashMap();
    protected Map numberFormatCache = new HashMap();

    protected JRAbstractExporter() {
    }

    public void reset() {
        this.parameters = new HashMap();
        this.elementOffsetStack = new LinkedList();
        this.penBoxes = new HashMap();
    }

    @Override
    public void setParameter(JRExporterParameter jRExporterParameter, Object object) {
        this.parameters.put(jRExporterParameter, object);
    }

    @Override
    public Object getParameter(JRExporterParameter jRExporterParameter) {
        return this.parameters.get(jRExporterParameter);
    }

    @Override
    public void setParameters(Map map) {
        this.parameters = map;
    }

    @Override
    public Map getParameters() {
        return this.parameters;
    }

    @Override
    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        Integer n = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        this.globalOffsetX = n != null ? n : 0;
        Integer n2 = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y);
        this.globalOffsetY = n2 != null ? n2 : 0;
        this.elementOffsetX = this.globalOffsetX;
        this.elementOffsetY = this.globalOffsetY;
    }

    protected void setExportContext() {
        this.classLoaderSet = false;
        this.urlHandlerFactorySet = false;
        this.classLoader = (ClassLoader)this.parameters.get(JRExporterParameter.CLASS_LOADER);
        if (this.classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(this.classLoader);
            this.classLoaderSet = true;
        }
        this.urlHandlerFactory = (URLStreamHandlerFactory)this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY);
        if (this.urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
            this.urlHandlerFactorySet = true;
        }
    }

    protected void resetExportContext() {
        if (this.classLoaderSet) {
            JRResourcesUtil.resetClassLoader();
        }
        if (this.urlHandlerFactorySet) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
    }

    protected void setClassLoader() {
        this.setExportContext();
    }

    protected void resetClassLoader() {
        this.resetExportContext();
    }

    protected void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream inputStream = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (inputStream != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
                } else {
                    URL uRL = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (uRL != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(uRL);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String string = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (string != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject(string);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(0);
        }
    }

    protected void setPageRange() throws JRException {
        Integer n;
        int n2 = -1;
        if (this.jasperPrint.getPages() != null) {
            n2 = this.jasperPrint.getPages().size() - 1;
        }
        if ((n = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = n;
            if (this.startPageIndex < 0 || this.startPageIndex > n2) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + n2);
            }
        }
        Integer n3 = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (n3 == null) {
            this.endPageIndex = n2;
        } else {
            this.endPageIndex = n3;
            if (this.endPageIndex < this.startPageIndex || this.endPageIndex > n2) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " (" + this.startPageIndex + " : " + n2 + ")");
            }
        }
        Integer n4 = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (n4 != null) {
            int n5 = n4;
            if (n5 < 0 || n5 > n2) {
                throw new JRException("Page index out of range : " + n5 + " of " + n2);
            }
            this.startPageIndex = n5;
            this.endPageIndex = n5;
        }
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText, boolean bl) {
        JRStyledText jRStyledText = null;
        String string = jRPrintText.getText();
        if (string != null) {
            HashMap<TextAttribute, Color> hashMap = new HashMap<TextAttribute, Color>();
            hashMap.putAll(JRFontUtil.setAttributes(hashMap, jRPrintText));
            hashMap.put(TextAttribute.FOREGROUND, jRPrintText.getForecolor());
            if (bl && jRPrintText.getMode() == 1) {
                hashMap.put(TextAttribute.BACKGROUND, jRPrintText.getBackcolor());
            }
            if (jRPrintText.isStyledText()) {
                try {
                    jRStyledText = this.styledTextParser.parse(hashMap, string);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (jRStyledText == null) {
                jRStyledText = new JRStyledText();
                jRStyledText.append(string);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, 0, string.length()));
            }
        }
        return jRStyledText;
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText) {
        return this.getStyledText(jRPrintText, true);
    }

    protected void setOutput() {
    }

    protected int getOffsetX() {
        return this.elementOffsetX;
    }

    protected int getOffsetY() {
        return this.elementOffsetY;
    }

    protected void setFrameElementsOffset(JRPrintFrame jRPrintFrame, boolean bl) {
        if (bl) {
            this.setElementOffsets(0, 0);
        } else {
            int n = jRPrintFrame.getTopPadding();
            int n2 = jRPrintFrame.getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + jRPrintFrame.getX() + n2, this.getOffsetY() + jRPrintFrame.getY() + n);
        }
    }

    private void setElementOffsets(int n, int n2) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = n;
        this.elementOffsetY = n2;
    }

    protected void restoreElementOffsets() {
        int[] nArray = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = nArray[0];
        this.elementOffsetY = nArray[1];
    }

    protected JRBox getBox(JRPrintGraphicElement jRPrintGraphicElement) {
        byte by = jRPrintGraphicElement.getPen();
        Byte by2 = new Byte(by);
        JRBox jRBox = (JRBox)this.penBoxes.get(by2);
        if (jRBox == null) {
            jRBox = new JRBaseBox(by, jRPrintGraphicElement.getForecolor());
            this.penBoxes.put(by2, jRBox);
        }
        return jRBox;
    }

    protected String getTextFormatFactoryClass(JRPrintText jRPrintText) {
        String string = jRPrintText.getFormatFactoryClass();
        if (string == null) {
            string = this.jasperPrint.getFormatFactoryClass();
        }
        return string;
    }

    protected Locale getTextLocale(JRPrintText jRPrintText) {
        String string = jRPrintText.getLocaleCode();
        if (string == null) {
            string = this.jasperPrint.getLocaleCode();
        }
        return string == null ? null : JRDataUtils.getLocale(string);
    }

    protected TimeZone getTextTimeZone(JRPrintText jRPrintText) {
        String string = jRPrintText.getTimeZoneId();
        if (string == null) {
            string = this.jasperPrint.getTimeZoneId();
        }
        return string == null ? null : JRDataUtils.getTimeZone(string);
    }

    protected TextValue getTextValue(JRPrintText jRPrintText, String string) {
        TextValue textValue;
        if (jRPrintText.getValueClassName() == null) {
            textValue = this.getTextValueString(jRPrintText, string);
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForName(jRPrintText.getValueClassName());
                textValue = Number.class.isAssignableFrom(clazz) ? this.getNumberCellValue(jRPrintText, string) : (Date.class.isAssignableFrom(clazz) ? this.getDateCellValue(jRPrintText, string) : (Boolean.class.equals((Object)clazz) ? this.getBooleanCellValue(jRPrintText, string) : this.getTextValueString(jRPrintText, string)));
            }
            catch (ParseException parseException) {
                textValue = this.getTextValueString(jRPrintText, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                textValue = this.getTextValueString(jRPrintText, string);
            }
        }
        return textValue;
    }

    protected TextValue getTextValueString(JRPrintText jRPrintText, String string) {
        return new StringTextValue(string);
    }

    protected TextValue getBooleanCellValue(JRPrintText jRPrintText, String string) {
        Boolean bl = null;
        if (string != null || string.length() > 0) {
            bl = Boolean.valueOf(string);
        }
        return new BooleanTextValue(string, bl);
    }

    protected TextValue getDateCellValue(JRPrintText jRPrintText, String string) throws ParseException {
        TextValue textValue;
        String string2 = jRPrintText.getPattern();
        if (string2 == null || string2.trim().length() == 0) {
            textValue = this.getTextValueString(jRPrintText, string);
        } else {
            DateFormat dateFormat = this.getDateFormat(this.getTextFormatFactoryClass(jRPrintText), string2, this.getTextLocale(jRPrintText), this.getTextTimeZone(jRPrintText));
            Date date = null;
            if (string != null && string.length() > 0) {
                date = dateFormat.parse(string);
            }
            textValue = new DateTextValue(string, date, string2);
        }
        return textValue;
    }

    protected TextValue getNumberCellValue(JRPrintText jRPrintText, String string) throws ParseException, ClassNotFoundException {
        TextValue textValue;
        String string2 = jRPrintText.getPattern();
        if (string2 == null || string2.trim().length() == 0) {
            Number number;
            textValue = string != null && string.length() > 0 ? ((number = this.defaultParseNumber(string, JRClassLoader.loadClassForName(jRPrintText.getValueClassName()))) != null ? new NumberTextValue(string, number, null) : this.getTextValueString(jRPrintText, string)) : new NumberTextValue(string, null, null);
        } else {
            NumberFormat numberFormat = this.getNumberFormat(this.getTextFormatFactoryClass(jRPrintText), string2, this.getTextLocale(jRPrintText));
            Number number = null;
            if (string != null && string.length() > 0) {
                number = numberFormat.parse(string);
            }
            textValue = new NumberTextValue(string, number, string2);
        }
        return textValue;
    }

    protected Number defaultParseNumber(String string, Class clazz) {
        Number number = null;
        try {
            if (clazz.equals(Byte.class)) {
                number = Byte.valueOf(string);
            } else if (clazz.equals(Short.class)) {
                number = Short.valueOf(string);
            } else if (clazz.equals(Integer.class)) {
                number = Integer.valueOf(string);
            } else if (clazz.equals(Long.class)) {
                number = Long.valueOf(string);
            } else if (clazz.equals(Float.class)) {
                number = Float.valueOf(string);
            } else if (clazz.equals(Double.class)) {
                number = Double.valueOf(string);
            } else if (clazz.equals(BigInteger.class)) {
                number = new BigInteger(string);
            } else if (clazz.equals(BigDecimal.class)) {
                number = new BigDecimal(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    protected DateFormat getDateFormat(String string, String string2, Locale locale, TimeZone timeZone) {
        String string3 = string + "|" + string2 + "|" + JRDataUtils.getLocaleCode(locale) + "|" + JRDataUtils.getTimeZoneId(timeZone);
        DateFormat dateFormat = (DateFormat)this.dateFormatCache.get(string3);
        if (dateFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(string);
            dateFormat = formatFactory.createDateFormat(string2, locale, timeZone);
            this.dateFormatCache.put(string3, dateFormat);
        }
        return dateFormat;
    }

    protected NumberFormat getNumberFormat(String string, String string2, Locale locale) {
        String string3 = string + "|" + string2 + "|" + JRDataUtils.getLocaleCode(locale);
        NumberFormat numberFormat = (NumberFormat)this.numberFormatCache.get(string3);
        if (numberFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(string);
            numberFormat = formatFactory.createNumberFormat(string2, locale);
            this.dateFormatCache.put(string3, numberFormat);
        }
        return numberFormat;
    }
}

