/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeries;
import net.sf.jasperreports.charts.util.TimeSeriesLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JRFillTimeSeriesDataset
extends JRFillChartDataset
implements JRTimeSeriesDataset {
    protected JRFillTimeSeries[] timeSeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillTimeSeriesDataset(JRTimeSeriesDataset jRTimeSeriesDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRTimeSeriesDataset, jRFillObjectFactory);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            this.timeSeries = new JRFillTimeSeries[jRTimeSeriesArray.length];
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i] = (JRFillTimeSeries)jRFillObjectFactory.getTimeSeries(jRTimeSeriesArray[i]);
            }
        }
    }

    @Override
    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    @Override
    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    @Override
    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i].evaluate(jRCalculator);
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i = 0; i < this.timeSeries.length; ++i) {
                Map<RegularTimePeriod, String> map;
                JRFillTimeSeries jRFillTimeSeries = this.timeSeries[i];
                Comparable comparable = jRFillTimeSeries.getSeries();
                TimeSeries timeSeries = (TimeSeries)this.seriesMap.get(comparable);
                if (timeSeries == null) {
                    timeSeries = new TimeSeries(comparable.toString(), this.getTimePeriod());
                    this.seriesNames.add(comparable);
                    this.seriesMap.put(comparable, timeSeries);
                }
                RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance(this.getTimePeriod(), jRFillTimeSeries.getTimePeriod(), this.getTimeZone());
                timeSeries.addOrUpdate(regularTimePeriod, jRFillTimeSeries.getValue());
                if (jRFillTimeSeries.getLabelExpression() != null) {
                    map = (HashMap<RegularTimePeriod, String>)this.labelsMap.get(comparable);
                    if (map == null) {
                        map = new HashMap<RegularTimePeriod, String>();
                        this.labelsMap.put(comparable, map);
                    }
                    map.put(regularTimePeriod, jRFillTimeSeries.getLabel());
                }
                if (!jRFillTimeSeries.hasItemHyperlink()) continue;
                map = (Map)this.itemHyperlinks.get(comparable);
                if (map == null) {
                    map = new HashMap();
                    this.itemHyperlinks.put(comparable, map);
                }
                map.put(regularTimePeriod, (String)((Object)jRFillTimeSeries.getPrintItemHyperlink()));
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable comparable = (Comparable)this.seriesNames.get(i);
                timeSeriesCollection.addSeries((TimeSeries)this.seriesMap.get(comparable));
            }
        }
        return timeSeriesCollection;
    }

    @Override
    public Class getTimePeriod() {
        return ((JRTimeSeriesDataset)this.parent).getTimePeriod();
    }

    @Override
    public void setTimePeriod(Class clazz) {
    }

    @Override
    public byte getDatasetType() {
        return 6;
    }

    public TimeSeriesLabelGenerator getLabelGenerator() {
        return new TimeSeriesLabelGenerator(this.labelsMap);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean bl = false;
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i = 0; i < this.timeSeries.length && !bl; ++i) {
                bl = this.timeSeries[i].hasItemHyperlink();
            }
        }
        return bl;
    }

    @Override
    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

