/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJComExigibilidadeDependentes
extends Observador {
    private ColecaoRendPJComExigibilidadeDependente colecaoRendPJ = null;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendPJComExigibilidadeDependentes(ColecaoRendPJComExigibilidadeDependente colecaoRendPJComExigibilidadeDependente, DeclaracaoIRPF declaracaoIRPF) {
        this.colecaoRendPJ = colecaoRendPJComExigibilidadeDependente;
        this.declaracaoIRPF = declaracaoIRPF;
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("ObjetoInserido")) {
                RendPJComExigibilidadeDependente rendPJComExigibilidadeDependente = (RendPJComExigibilidadeDependente)object3;
                rendPJComExigibilidadeDependente.addObservador(this);
                this.calculaTotaisRendExigSuspensa();
                this.calculaTotaisDepositoJudicial();
            } else if (string.equals("ObjetoRemovido")) {
                RendPJComExigibilidadeDependente rendPJComExigibilidadeDependente = (RendPJComExigibilidadeDependente)object3;
                rendPJComExigibilidadeDependente.removeObservador(this);
                this.calculaTotaisRendExigSuspensa();
                this.calculaTotaisDepositoJudicial();
            } else if (string.equals("Rend. com Exigibilidade Suspensa")) {
                this.calculaTotaisRendExigSuspensa();
            } else if (string.equals("Dep\u00f3sito Judicial")) {
                this.calculaTotaisDepositoJudicial();
            }
        }
    }

    private void calculaTotaisDepositoJudicial() {
        Valor valor = new Valor();
        for (RendPJComExigibilidadeDependente rendPJComExigibilidadeDependente : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJComExigibilidadeDependente.getDepositoJudicial());
        }
        this.colecaoRendPJ.getTotaisDepositoJudicial().setConteudo(valor);
    }

    private void calculaTotaisRendExigSuspensa() {
        Valor valor = new Valor();
        for (RendPJComExigibilidadeDependente rendPJComExigibilidadeDependente : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJComExigibilidadeDependente.getRendExigSuspensa());
        }
        this.colecaoRendPJ.getTotaisRendRecebidoPJ().setConteudo(valor);
    }
}

