/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class DoubleArrayConverter
extends AbstractArrayConverter {
    private static double[] model = new double[0];

    public DoubleArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public DoubleArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                double[] dArray = new double[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    dArray[n] = Double.parseDouble(stringArray[n]);
                    ++n;
                }
                return dArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            double[] dArray = new double[list.size()];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = Double.parseDouble((String)list.get(n));
                ++n;
            }
            return dArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

