/* Bem - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.bens;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class Bem extends ObjetoNegocio
{
  public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
  public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
  private Codigo codigo = new Codigo (this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoBens ());
  private Codigo pais = new Codigo (this, "Localiza\u00e7\u00e3o(Pa\u00eds)", CadastroTabelasIRPF.recuperarPaises ());
  private Alfa discriminacao = new Alfa (this, "Discrimina\u00e7\u00e3o", 510);
  private Valor valorExercicioAnterior = new Valor (this, NOME_CAMPO_VALOR_ANTERIOR);
  private Valor valorExercicioAtual = new Valor (this, NOME_CAMPO_VALOR_ATUAL);
  private Alfa logradouro = new Alfa (this, "Logradouro", 40);
  private Alfa numero = new Alfa (this, "Número", 6);
  private Alfa complemento = new Alfa (this, "Número", 40);
  private Alfa bairro = new Alfa (this, "Bairro", 40);
  private Codigo uf = new Codigo (this, "UF", CadastroTabelasIRPF.recuperarUFs (1));
  private Codigo municipio = new Codigo (this, "Munic\u00edpio", new Vector ());
  private Alfa nomeMunicipio = new Alfa (this, "Município", 40);
  private Alfa cidade = new Alfa (this, "Cidade", 40);
  private CEP cep = new CEP (this, "CEP");
  private Alfa registrado = new Alfa (this, "Registrado", 1);
  private Alfa matricula = new Alfa (this, "Matrícula", 40);
  private Valor areaTotal = new Valor (this, "Área Total");
  private Alfa unidade = new Alfa (this, "Unidade da Área", 1);
  private Alfa nomeCartorio = new Alfa (this, "Nome do Cartório", 60);
  // FIXME: participacoesInventario = new ColecaoItemPercentualParticipacaoInventario (this);
  private Data dataAquisicao = new Data (this, "Data de aquisição");
  private Alfa IPTU = new Alfa (this, "Número do IPTU", 30);
  private Alfa NIRF = new Alfa (this, "Número do NIRF", 8);
  private Alfa Renavan = new Alfa (this, "Número do RENAVAN", 30);
  private Alfa RegAviaCivil = new Alfa (this, "Número do Registro na Aviação Civil", 30);
  private Alfa RegCapPortos = new Alfa (this, "Número do Registro na Capitania de Portos", 30);
  private Alfa agencia = new Alfa (this, "Número da Agência Bancária", 4);
  private Alfa conta = new Alfa (this, "Número da Conta Bancária", 13);
  private Alfa contaDV = new Alfa (this, "Dígito Verificador da Conta Bancária", 2);
  private NI CPFCNPJ = new NI (this, "CPF ou CNPJ");
  public static final String BRASIL = "0";
  public static final String EXTERIOR = "1";
  
  public Bem ()
  {
    getCodigo ().setColunaFiltro (1);
    getPais ().setColunaFiltro (1);
    getCodigo ().addValidador (new ValidadorNaoNulo ((byte) 3, tab.msg ("bem_codigo")));
    getDiscriminacao ().addValidador (new ValidadorNaoNulo ((byte) 3, tab.msg ("bem_discriminacao")));
    getPais ().addValidador (new ValidadorNaoNulo ((byte) 3, tab.msg ("bem_pais_branco")));
    getPais ().addValidador (new ValidadorDefault ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	if (getPais ().getConteudoFormatado ().equals ("105"))
	  {
	    if (getCodigo ().getConteudoAtual (0).equals ("62"))
	      return new RetornoValidacao (tab.msg ("bem_pais_imcompativel"), (byte) 3);
	  }
	else if (getCodigo ().getConteudoAtual (0).equals ("61"))
	  return new RetornoValidacao (tab.msg ("bem_pais_imcompativel"), (byte) 3);
	return null;
      }
    });
    getCPFCNPJ ().addValidador (new ValidadorNI ((byte) 3));
  }
  
  public boolean isVazio ()
  {
    Iterator iterator = recuperarCamposInformacao ().iterator ();
    while (iterator.hasNext ())
      {
	Informacao informacao = (Informacao) iterator.next ();
	if (! informacao.isVazio () && ! informacao.getNomeCampo ().equals ("Localiza\u00e7\u00e3o(Pa\u00eds)"))
	  return false;
      }
    return true;
  }
  
  public Codigo getCodigo ()
  {
    return codigo;
  }
  
  public Alfa getDiscriminacao ()
  {
    return discriminacao;
  }
  
  public Codigo getPais ()
  {
    return pais;
  }
  
  public Valor getValorExercicioAnterior ()
  {
    return valorExercicioAnterior;
  }
  
  public Valor getValorExercicioAtual ()
  {
    return valorExercicioAtual;
  }
  
  public Alfa getLogradouro ()
  {
    return logradouro;
  }

  public Alfa getNumero ()
  {
    return numero;
  }

  public Alfa getComplemento ()
  {
    return complemento;
  }

  public Alfa getBairro ()
  {
    return bairro;
  }

  public Codigo getUf ()
  {
    return uf;
  }

  public Codigo getMunicipio ()
  {
    return municipio;
  }

  public Alfa getNomeMunicipio ()
  {
    return nomeMunicipio;
  }

  public Alfa getCidade ()
  {
    return cidade;
  }

  public CEP getCep ()
  {
    return cep;
  }

  public Alfa getRegistrado ()
  {
    return registrado;
  }

  public Alfa getMatricula ()
  {
    return matricula;
  }

  public Valor getAreaTotal ()
  {
    return areaTotal;
  }

  public Alfa getUnidade ()
  {
    return unidade;
  }

  public Alfa getNomeCartorio ()
  {
    return nomeCartorio;
  }

  public Data getDataAquisicao ()
  {
    return dataAquisicao;
  }

  public Alfa getIPTU ()
  {
    return IPTU;
  }

  public Alfa getNIRF ()
  {
    return NIRF;
  }

  public Alfa getRenavan ()
  {
    return Renavan;
  }

  public Alfa getRegAviaCivil ()
  {
    return RegAviaCivil;
  }

  public Alfa getRegCapPortos ()
  {
    return RegCapPortos;
  }

  public Alfa getAgencia ()
  {
    return agencia;
  }

  public Alfa getConta ()
  {
    return conta;
  }

  public Alfa getContaDV ()
  {
    return contaDV;
  }

  public NI getCPFCNPJ ()
  {
    return CPFCNPJ;
  }

  protected List recuperarListaCamposPendencia ()
  {
    List retorno = super.recuperarListaCamposPendencia ();
    retorno.add (codigo);
    retorno.add (pais);
    retorno.add (discriminacao);
    retorno.add (valorExercicioAtual);
    retorno.add (valorExercicioAnterior);
    return retorno;
  }
  
  public List verificarPendencias (int numeroItem)
  {
    List retorno = super.verificarPendencias (numeroItem);
    if (getValorExercicioAtual ().isVazio () && getValorExercicioAnterior ().isVazio ())
      {
	Pendencia p = new Pendencia ((byte) 2, getValorExercicioAnterior (), getValorExercicioAnterior ().getNomeCampo (), tab.msg ("bem_valor_nao_informado"), numeroItem);
	retorno.add (p);
      }
    return retorno;
  }
}
