/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeySelectionCustomizado
implements JComboBox.KeySelectionManager {
    long ultimaVez = 0L;
    String filtro = "";
    int colunaFiltro;
    int maxDelayFiltroTecla = 500;

    public KeySelectionCustomizado(int n) {
        this.colunaFiltro = n;
        this.maxDelayFiltroTecla = Integer.parseInt(FabricaUtilitarios.getProperties().getProperty("maxDelayFiltroEditCodigo", "500"));
    }

    public void setColunaFiltro(int n) {
        this.colunaFiltro = n;
    }

    public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
        int n = -1;
        if (this.colunaFiltro >= 0) {
            long l = System.currentTimeMillis();
            long l2 = l - this.ultimaVez;
            if (l2 < (long)this.maxDelayFiltroTecla) {
                KeySelectionCustomizado keySelectionCustomizado = this;
                String string = keySelectionCustomizado.filtro;
                StringBuffer stringBuffer = new StringBuffer(string);
                keySelectionCustomizado.filtro = stringBuffer.append(c).toString();
                n = this.tentaSelecionar(comboBoxModel);
            } else {
                this.filtro = "";
                KeySelectionCustomizado keySelectionCustomizado = this;
                String string = keySelectionCustomizado.filtro;
                StringBuffer stringBuffer = new StringBuffer(string);
                keySelectionCustomizado.filtro = stringBuffer.append(c).toString();
                n = this.tentaSelecionar(comboBoxModel);
            }
            this.ultimaVez = l;
            if (this.filtro.length() > 100) {
                this.filtro = "";
            }
        }
        return n;
    }

    private synchronized int tentaSelecionar(ComboBoxModel comboBoxModel) {
        int n = comboBoxModel.getSize();
        int n2 = -1;
        String string = this.filtro.toUpperCase();
        int n3 = 0;
        while (n3 < n) {
            ElementoTabela elementoTabela = (ElementoTabela)comboBoxModel.getElementAt(n3);
            String string2 = UtilitariosString.removeAcentos(elementoTabela.getConteudo(this.colunaFiltro));
            if (string2.toUpperCase().startsWith(string)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }
}

