/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dependentes;

import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.ObservadorTotalizaDependentes;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Valor;

public class Dependentes
extends Colecao {
    public static final String DEDUCAO_DEPENDENTE = "2.156,52";
    private transient Valor totalDeducaoDependentes = new Valor(this, "Total de Redu\u00e7\u00e3o com Dependentes");
    private transient Contribuinte contribuinte;
    private ObservadorTotalizaDependentes obsTotalizaDep;

    public Dependentes(Contribuinte contribuinte) {
        super(Dependente.class.getName());
        this.setFicha("Dependentes");
        this.totalDeducaoDependentes.setReadOnly(true);
        this.totalDeducaoDependentes.setFicha(this.getFicha());
        this.totalDeducaoDependentes.setAtributoPersistente(false);
        this.contribuinte = contribuinte;
        this.obsTotalizaDep = new ObservadorTotalizaDependentes(this);
        this.addObservador(this.obsTotalizaDep);
    }

    public Valor getTotalDeducaoDependentes() {
        return this.totalDeducaoDependentes;
    }

    public void objetoInserido(Object object) {
        Dependente dependente = (Dependente)object;
        dependente.setContribuinte(this.contribuinte);
        dependente.addObservador(this.obsTotalizaDep);
    }

    public void objetoRemovido(Object object) {
        Dependente dependente = (Dependente)object;
        dependente.removeObservador(this.obsTotalizaDep);
    }

    public String getNomeDependenteByChave(String string) {
        for (Dependente dependente : this.recuperarLista()) {
            if (!dependente.getChave().equals(string)) continue;
            return dependente.getNome().getConteudoFormatado();
        }
        return null;
    }

    public Dependente getDependenteByCPF(CPF cPF) {
        String string = cPF.asString();
        if (string.equals("")) {
            return null;
        }
        for (Dependente dependente : this.recuperarLista()) {
            if (!dependente.getCpfDependente().asString().equals(string)) continue;
            return dependente;
        }
        return null;
    }

    public boolean isExisteNome(String string) {
        for (Dependente dependente : this.recuperarLista()) {
            if (!dependente.getNome().asString().equals(string)) continue;
            return true;
        }
        return false;
    }
}

