/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public class JRSingletonCache {
    private final ReferenceMap cache = new ReferenceMap();
    private final Class itf;

    public JRSingletonCache(Class clazz) {
        this.itf = clazz;
    }

    public synchronized Object getCachedInstance(String string) throws JRException {
        Object object = this.cache.get(string);
        if (object == null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(string);
                if (this.itf != null && !this.itf.isAssignableFrom(clazz)) {
                    throw new JRException("Class \"" + string + "\" should be compatible with \"" + this.itf.getName() + "\"");
                }
                object = clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRException("Class " + string + " not found.", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new JRException("Error instantiating class " + string + ".", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JRException("Error instantiating class " + string + ".", illegalAccessException);
            }
            this.cache.put(string, object);
        }
        return object;
    }
}

