/* ModeloDeclaracao - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class ModeloDeclaracao extends ObjetoNegocio
{
  public static final String LIMITE_ANUAL_27_MEIO_PORCENT = "53.565,72";
  public static final String LIMITE_ANUAL_22_MEIO_PORCENT = "42.869,16";
  public static final String LIMITE_ANUAL_15_PORCENT = "32.151,48";
  public static final String LIMITE_ANUAL_7_MEIO_PORCENT = "21.453,24";
  public static final String LIMITE_MENSAL_27_MEIO_PORCENT = "9.913,83";
  public static final String LIMITE_MENSAL_22_MEIO_PORCENT = "7.235,54";
  public static final String LIMITE_MENSAL_15_PORCENT = "4.020,35";
  public static final String LIMITE_MENSAL_7_MEIO_PORCENT = "1.608,99";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_27_MEIO_PORCENT = "826,1522";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_22_MEIO_PORCENT = "602,9617";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_15_PORCENT = "335,0295";
  public static final String FATOR_AJUSTE_ESPOLIO_SAIDA_7_MEIO_PORCENT = "134,0827";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_27_MEIO_PORCENT = "4.463,81";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_22_MEIO_PORCENT = "3.572,43";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_15_PORCENT = "2.679,29";
  public static final String LIMITE_MENSAL_ESPOLIO_SAIDA_7_MEIO_PORCENT = "1.787,77";
  public static final String NOME_TOTAL_REND_RECEB_MAIS_EXTERIOR = "Total de Rendimentos Recebidos";
  public static final String NOME_TOTAL_LIVRO_CAIXA_TIT_DEP = "Total Livro Caixa - TIT + DEP";
  protected DeclaracaoIRPF declaracaoIRPF = null;
  protected Valor impostoDevido = new Valor (this, "");
  protected Valor impostoDevidoII = new Valor (this, "");
  protected Valor baseCalculo = new Valor (this, "");
  protected Valor saldoImpostoPagar = new Valor (this, "");
  protected Valor impostoRestituir = new Valor (this, "");
  protected Valor rendRecebidoExterior = new Valor (this, "");
  protected Valor totalRendRecebidosMaisExterior = new Valor (this, "Total de Rendimentos Recebidos");
  protected Valor totalLivroCaixa = new Valor (this, "Total Livro Caixa - TIT + DEP");
  protected Valor totalDoacoesCampanhasEleitorais = new Valor (this, "");
  
  public ModeloDeclaracao (DeclaracaoIRPF dec)
  {
    declaracaoIRPF = dec;
    totalRendRecebidosMaisExterior.setReadOnly (true);
  }
  
  public Valor getTotalRendRecebidosMaisExterior ()
  {
    return totalRendRecebidosMaisExterior;
  }
  
  public Valor getTotalLivroCaixa ()
  {
    return totalLivroCaixa;
  }
  
  public Valor calculaImposto (Valor _baseCalculo)
  {
    Valor retorno = new Valor ();
    /* FIXME: cálculos para declaração de espólio e saída não usam
     * todos os meses.  */
    if (_baseCalculo.comparacao ("<=", LIMITE_ANUAL_7_MEIO_PORCENT))
      retorno.clear ();
    else if (_baseCalculo.comparacao ("<=", LIMITE_ANUAL_15_PORCENT))
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo.operacao ('*', "0,075"));
	imposto.append ('-', LIMITE_MENSAL_7_MEIO_PORCENT);
	retorno.setConteudo (imposto);
      }
    else if (_baseCalculo.comparacao ("<=", LIMITE_ANUAL_22_MEIO_PORCENT))
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo.operacao ('*', "0,15"));
	imposto.append ('-', LIMITE_MENSAL_15_PORCENT);
	retorno.setConteudo (imposto);
      }
    else if (_baseCalculo.comparacao ("<=", LIMITE_ANUAL_27_MEIO_PORCENT))
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo.operacao ('*', "0,225"));
	imposto.append ('-', LIMITE_MENSAL_22_MEIO_PORCENT);
	retorno.setConteudo (imposto);
      }
    else
      {
	Valor imposto = new Valor ();
	imposto.setConteudo (_baseCalculo);
	imposto.converteQtdCasasDecimais (3);
	imposto.setConteudo (imposto.operacao ('*', "0,275"));
	imposto.append ('-', LIMITE_MENSAL_27_MEIO_PORCENT);
	imposto.converteQtdCasasDecimais (2);
	retorno.setConteudo (imposto);
      }
    return retorno;
  }
  
  public Valor getImpostoDevido ()
  {
    return impostoDevido;
  }
  
  public Valor getBaseCalculo ()
  {
    return baseCalculo;
  }
  
  public Valor getSaldoImpostoPagar ()
  {
    return saldoImpostoPagar;
  }
  
  public Valor getImpostoRestituir ()
  {
    return impostoRestituir;
  }
  
  public Valor getRendRecebidoExterior ()
  {
    return rendRecebidoExterior;
  }
  
  public abstract void resumoRendimentosTributaveis ();
  
  public abstract void resumoCalculoImposto ();
  
  public abstract void resumoOutrasInformacoes ();
  
  public abstract void aplicaValoresNaDeclaracao ();
  
  public abstract Valor recuperarTotalRendimentosTributaveis ();
  
  public abstract Valor recuperarTotalImpostoPago ();
  
  public String recuperarCodInImpostoAntecipado ()
  {
    String string = "0";
    if (! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoRetidoFonteTitular ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoRetidoFonteDependentes ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoComplementar ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getCarneLeao ().isVazio () || ! declaracaoIRPF.getResumo ().getCalculoImposto ().getImpostoRetidoFonteLei11033 ().isVazio ())
      string = "1";
    return string;
  }
  
  public abstract String recuperarCodInImpostoPago ();
  
  public Valor getImpostoDevidoII ()
  {
    return impostoDevidoII;
  }
}
