/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.EventPump;
import foxtrot.JREVersion;
import foxtrot.Job;
import foxtrot.Task;
import foxtrot.WorkerThread;
import foxtrot.pumps.JDK13QueueEventPump;
import foxtrot.pumps.SunJDK140ConditionalEventPump;
import foxtrot.pumps.SunJDK141ConditionalEventPump;
import foxtrot.workers.DefaultWorkerThread;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;

public class Worker {
    private static EventPump eventPump;
    private static WorkerThread workerThread;
    static final boolean debug = false;

    private Worker() {
    }

    public static Object post(Task task) throws Exception {
        Worker.initializeWorkerThread();
        Worker.initializeEventPump();
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (!bl && !workerThread.isWorkerThread()) {
            throw new IllegalStateException("Worker.post() can be called only from the AWT Event Dispatch Thread or from another Task");
        }
        if (!workerThread.isAlive()) {
            workerThread.start();
        }
        if (bl) {
            workerThread.postTask(task);
            eventPump.pumpEvents(task);
        } else {
            workerThread.runTask(task);
        }
        try {
            Object object = task.getResultOrThrow();
            return object;
        }
        finally {
            task.reset();
        }
    }

    public static Object post(Job job) {
        try {
            return Worker.post((Task)job);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        catch (Error error) {
            throw error;
        }
    }

    public static EventPump getEventPump() {
        Worker.initializeEventPump();
        return eventPump;
    }

    public static void setEventPump(EventPump eventPump) {
        if (eventPump == null) {
            throw new IllegalArgumentException("EventPump cannot be null");
        }
        Worker.eventPump = eventPump;
    }

    public static WorkerThread getWorkerThread() {
        Worker.initializeWorkerThread();
        return workerThread;
    }

    public static void setWorkerThread(WorkerThread workerThread) {
        if (workerThread == null) {
            throw new IllegalArgumentException("WorkerThread cannot be null");
        }
        Worker.workerThread = workerThread;
    }

    private static void initializeWorkerThread() {
        if (workerThread != null) {
            return;
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("foxtrot.worker.thread");
            }
        });
        if (string == null) {
            workerThread = new DefaultWorkerThread();
        } else {
            ClassLoader classLoader = Worker.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                workerThread = (WorkerThread)classLoader.loadClass(string).newInstance();
            }
            catch (Throwable throwable) {
                workerThread = new DefaultWorkerThread();
            }
        }
    }

    private static void initializeEventPump() {
        if (eventPump != null) {
            return;
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("foxtrot.event.pump");
            }
        });
        if (string != null) {
            ClassLoader classLoader = Worker.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                eventPump = (EventPump)classLoader.loadClass(string).newInstance();
                return;
            }
            catch (Throwable throwable) {}
        }
        if (JREVersion.isJRE141()) {
            eventPump = new SunJDK141ConditionalEventPump();
        } else if (JREVersion.isJRE140()) {
            eventPump = new SunJDK140ConditionalEventPump();
        } else if (JREVersion.isJRE13() || JREVersion.isJRE12()) {
            eventPump = new JDK13QueueEventPump();
        } else {
            throw new Error("JDK 1.1 is not supported");
        }
    }
}

