/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class AnnotationMethodDeclaration
extends MethodDeclaration {
    public Expression defaultValue;
    public int extendedDimensions;

    public AnnotationMethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttribute(this.binding, this);
        classFile.completeMethodInfo(n, n2);
    }

    public boolean isAnnotationMethod() {
        return true;
    }

    public boolean isMethod() {
        return false;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        TypeParameter[] typeParameterArray;
        AnnotationMethodDeclaration.printIndent(n, stringBuffer);
        AnnotationMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AnnotationMethodDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        if ((typeParameterArray = this.typeParameters()) != null) {
            stringBuffer.append('<');
            n2 = typeParameterArray.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                typeParameterArray[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            typeParameterArray[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        this.printReturnType(0, stringBuffer).append(this.selector).append('(');
        if (this.arguments != null) {
            n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append(')');
        if (this.thrownExceptions != null) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.thrownExceptions.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.thrownExceptions[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        if (this.defaultValue != null) {
            stringBuffer.append(" default ");
            this.defaultValue.print(0, stringBuffer);
        }
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    public void resolveStatements() {
        block9: {
            Object object;
            TypeBinding typeBinding;
            block11: {
                block10: {
                    super.resolveStatements();
                    if (this.arguments != null) {
                        this.scope.problemReporter().annotationMembersCannotHaveParameters(this);
                    }
                    if (this.typeParameters != null) {
                        this.scope.problemReporter().annotationMembersCannotHaveTypeParameters(this);
                    }
                    if (this.extendedDimensions != 0) {
                        this.scope.problemReporter().illegalExtendedDimensions(this);
                    }
                    if (this.binding == null) {
                        return;
                    }
                    typeBinding = this.binding.returnType;
                    if (typeBinding == null) break block9;
                    object = typeBinding.leafComponentType();
                    if (typeBinding.dimensions() > 1) break block10;
                    switch (((TypeBinding)object).erasure().id) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 16: {
                            break block11;
                        }
                        default: {
                            if (((TypeBinding)object).isEnum() || ((TypeBinding)object).isAnnotationType()) break block11;
                        }
                    }
                }
                this.scope.problemReporter().invalidAnnotationMemberType(this);
            }
            if (this.defaultValue != null) {
                object = new MemberValuePair(this.selector, this.sourceStart, this.sourceEnd, this.defaultValue);
                ((MemberValuePair)object).binding = this.binding;
                ((MemberValuePair)object).resolveTypeExpecting(this.scope, typeBinding);
                this.binding.setDefaultValue(ElementValuePair.getValue(this.defaultValue));
            } else {
                this.binding.setDefaultValue(null);
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.defaultValue != null) {
                this.defaultValue.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

