/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DEREnumerated
extends ASN1Object {
    byte[] bytes;

    public static DEREnumerated getInstance(Object object) {
        if (object == null || object instanceof DEREnumerated) {
            return (DEREnumerated)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DEREnumerated(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DEREnumerated.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DEREnumerated getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DEREnumerated.getInstance(aSN1TaggedObject.getObject());
    }

    public DEREnumerated(int n) {
        this.bytes = BigInteger.valueOf(n).toByteArray();
    }

    public DEREnumerated(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DEREnumerated(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(10, this.bytes);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DEREnumerated)) {
            return false;
        }
        DEREnumerated dEREnumerated = (DEREnumerated)dERObject;
        if (this.bytes.length != dEREnumerated.bytes.length) {
            return false;
        }
        int n = 0;
        while (n != this.bytes.length) {
            if (this.bytes[n] != dEREnumerated.bytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

