/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.List;
import java.util.ListIterator;
import serpro.ppgd.negocio.Colecao;

class ListIteratorColecaoPPGD
implements ListIterator {
    private ListIterator implementacao;
    private Colecao owner;
    private List lista;
    private Object objetoCorrente;

    private void verificaTipoInserido(Object object) {
        if (this.owner.getTipoItens() != null && !this.owner.getTipoItens().isInstance(object)) {
            throw new IllegalArgumentException("Tentativa inv\u00e1lida de inser\u00e7\u00e3o do elemento " + object + " na cole\u00e7\u00e3o " + this.owner);
        }
    }

    private void verificaTamanho(int n) {
        if (this.owner.getTamanho() != 0 && n == this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
    }

    public ListIteratorColecaoPPGD(ListIterator listIterator, Colecao colecao, List list) {
        this.implementacao = listIterator;
        this.owner = colecao;
        this.lista = list;
    }

    public void add(Object object) {
        this.verificaTipoInserido(object);
        this.verificaTamanho(this.lista.size());
        this.implementacao.add(object);
        this.owner.objetoInserido(object);
    }

    public boolean hasNext() {
        return this.implementacao.hasNext();
    }

    public boolean hasPrevious() {
        return this.implementacao.hasPrevious();
    }

    public Object next() {
        this.objetoCorrente = this.implementacao.next();
        return this.objetoCorrente;
    }

    public int nextIndex() {
        return this.implementacao.nextIndex();
    }

    public Object previous() {
        this.objetoCorrente = this.implementacao.previous();
        return this.objetoCorrente;
    }

    public int previousIndex() {
        return this.implementacao.previousIndex();
    }

    public void remove() {
        this.owner.objetoARemover(this.objetoCorrente);
        this.implementacao.remove();
        this.owner.objetoRemovido(this.objetoCorrente);
    }

    public void set(Object object) {
        this.verificaTipoInserido(object);
        this.owner.objetoARemover(this.objetoCorrente);
        this.implementacao.set(object);
        this.owner.objetoRemovido(this.objetoCorrente);
        this.owner.objetoInserido(object);
    }
}

