/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.gui.DialogoOcupado;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.persistenciagenerica.RepositorioXMLDefault;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLIRPF {
    public static final String PATH_XML_ID_DECS = String.valueOf(IRPFUtil.DIR_DADOS) + "/" + "iddeclaracoes.xml";
    private IdentificadorDeclaracao identificadorDeclaracao = null;
    private DeclaracaoIRPF declaracaoIRPF = null;
    private ColecaoIdDeclaracao listaIdDeclaracoes = null;
    private RepositorioXMLDefault repositorioIds = new RepositorioXMLDefault();
    private RepositorioXMLDefault repositorioDeclaracoes = new RepositorioXMLDefault();

    public RepositorioXMLIRPF() {
        this.carregaIdDeclaracoes();
    }

    private void carregaIdDeclaracoes() {
        if (PlataformaPPGD.isEmDesign()) {
            this.listaIdDeclaracoes = new ColecaoIdDeclaracao();
        } else {
            try {
                RepositorioXMLIRPF.testaDiretorioDados();
                this.listaIdDeclaracoes = new ColecaoIdDeclaracao();
                if (new File(PATH_XML_ID_DECS).exists()) {
                    this.repositorioIds.preencheObjeto(this.listaIdDeclaracoes, PATH_XML_ID_DECS, true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void testaDiretorioDados() {
        String string = IRPFUtil.DIR_DADOS;
        String string2 = string;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public DeclaracaoIRPF recuperarDeclaracaoIRPF(String string) throws RepositorioXMLException {
        IdentificadorDeclaracao identificadorDeclaracao = this.getIdDeclaracao(string);
        DeclaracaoIRPF declaracaoIRPF = null;
        if (this.repositorioDeclaracoes.temObjetoNegocioEmCache(identificadorDeclaracao.getPathArquivo())) {
            declaracaoIRPF = (DeclaracaoIRPF)this.repositorioDeclaracoes.getObjeto(identificadorDeclaracao.getPathArquivo());
        } else {
            declaracaoIRPF = new DeclaracaoIRPF(identificadorDeclaracao);
            if (this.repositorioDeclaracoes.preencheObjeto(declaracaoIRPF, identificadorDeclaracao.getPathArquivo(), true) == null) {
                throw new RepositorioXMLException("A declara\u00e7\u00e3o solicitada nao existe");
            }
            declaracaoIRPF.adicionaObservadoresCalculosLate();
        }
        return declaracaoIRPF;
    }

    public void salvarDeclaracao(DeclaracaoIRPF declaracaoIRPF) throws RepositorioXMLException {
        IdentificadorDeclaracao identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.repositorioDeclaracoes.salvar(declaracaoIRPF, identificadorDeclaracao.getPathArquivo());
    }

    public void salvarDeclaracao(String string) {
        try {
            this.repositorioIds.salvar(this.getListaIdDeclaracoes(), PATH_XML_ID_DECS);
            IdentificadorDeclaracao identificadorDeclaracao = this.getIdDeclaracao(string);
            DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)this.repositorioDeclaracoes.getObjeto(identificadorDeclaracao.getPathArquivo());
            this.repositorioDeclaracoes.salvar(declaracaoIRPF, identificadorDeclaracao.getPathArquivo());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public void abreDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) throws RepositorioXMLException {
        this.identificadorDeclaracao = identificadorDeclaracao;
        if (this.repositorioDeclaracoes.temObjetoNegocioEmCache(identificadorDeclaracao.getPathArquivo())) {
            this.declaracaoIRPF = (DeclaracaoIRPF)this.repositorioDeclaracoes.getObjeto(identificadorDeclaracao.getPathArquivo());
        } else {
            DialogoOcupado dialogoOcupado = DialogoOcupado.exibeDialogo(0, 4, "Aguarde...");
            dialogoOcupado.atualiza("Abrindo declara\u00e7\u00e3o...");
            this.declaracaoIRPF = new DeclaracaoIRPF(this.identificadorDeclaracao);
            dialogoOcupado.atualiza();
            this.repositorioDeclaracoes.preencheObjeto(this.declaracaoIRPF, identificadorDeclaracao.getPathArquivo(), true);
            dialogoOcupado.atualiza();
            this.declaracaoIRPF.adicionaObservadoresCalculosLate();
            dialogoOcupado.atualiza();
            dialogoOcupado.finaliza();
        }
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public boolean existeDeclaracao(String string) {
        return this.getListaIdDeclaracoes().existeCPFCadastrado(string);
    }

    public ColecaoIdDeclaracao getListaIdDeclaracoes() {
        return this.listaIdDeclaracoes;
    }

    public void criarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        try {
            RepositorioXMLIRPF.testaDiretorioDados();
            this.listaIdDeclaracoes.recuperarLista().add(identificadorDeclaracao);
            this.repositorioIds.salvar(this.listaIdDeclaracoes, PATH_XML_ID_DECS);
            this.identificadorDeclaracao = identificadorDeclaracao;
            DeclaracaoIRPF declaracaoIRPF = new DeclaracaoIRPF(this.identificadorDeclaracao);
            declaracaoIRPF.adicionaObservadoresCalculosLate();
            this.repositorioDeclaracoes.salvar(declaracaoIRPF, identificadorDeclaracao.getPathArquivo());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void excluirDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        try {
            RepositorioXMLIRPF.testaDiretorioDados();
            this.listaIdDeclaracoes.removeCPF(identificadorDeclaracao);
            this.repositorioIds.salvar(this.listaIdDeclaracoes, PATH_XML_ID_DECS);
            this.repositorioDeclaracoes.excluir(identificadorDeclaracao.getPathArquivo());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void excluirDeclaracao(List list) {
        try {
            RepositorioXMLIRPF.testaDiretorioDados();
            this.listaIdDeclaracoes.removeCPF(list);
            this.repositorioIds.salvar(this.listaIdDeclaracoes, PATH_XML_ID_DECS);
            for (IdentificadorDeclaracao identificadorDeclaracao : list) {
                this.repositorioDeclaracoes.excluir(identificadorDeclaracao.getPathArquivo());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void salvaDeclaracaoAberta() {
        try {
            this.repositorioIds.salvar(this.getListaIdDeclaracoes(), PATH_XML_ID_DECS);
            this.repositorioDeclaracoes.salvar(this.declaracaoIRPF, this.identificadorDeclaracao.getPathArquivo());
        }
        catch (RepositorioException repositorioException) {
            repositorioException.printStackTrace();
        }
    }

    public void fechaDeclaracao() {
        this.declaracaoIRPF = null;
        this.identificadorDeclaracao = null;
    }

    public IdentificadorDeclaracao getIdDeclaracaoAberto() {
        return this.identificadorDeclaracao;
    }

    public DeclaracaoIRPF getDeclaracaoAberta() {
        return this.declaracaoIRPF;
    }

    public boolean existeDeclaracoes() {
        return this.getListaIdDeclaracoes().recuperarLista().size() > 0;
    }

    public IdentificadorDeclaracao getIdDeclaracao(String string) {
        Iterator iterator = this.getListaIdDeclaracoes().recuperarLista().iterator();
        while (iterator.hasNext()) {
            CPF cPF = new CPF();
            cPF.setConteudo(string);
            IdentificadorDeclaracao identificadorDeclaracao = (IdentificadorDeclaracao)iterator.next();
            if (!cPF.asString().equals(identificadorDeclaracao.getCpf().asString())) continue;
            return identificadorDeclaracao;
        }
        return null;
    }
}

