/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtilities;

public class TimeSeriesCollection
extends AbstractIntervalXYDataset
implements XYDataset,
IntervalXYDataset,
DomainInfo,
Serializable {
    private static final long serialVersionUID = 834149929022371137L;
    private List data;
    private Calendar workingCalendar;
    private TimePeriodAnchor xPosition;
    private boolean domainIsPointsInTime;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimeSeriesCollection(TimeSeries timeSeries) {
        this(timeSeries, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeSeries timeSeries, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.data = new ArrayList();
        if (timeSeries != null) {
            this.data.add(timeSeries);
            timeSeries.addChangeListener(this);
        }
        this.xPosition = TimePeriodAnchor.START;
        this.domainIsPointsInTime = true;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl) {
        this.domainIsPointsInTime = bl;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        if (timePeriodAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.xPosition = timePeriodAnchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimeSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("The 'series' argument is out of bounds (" + n + ").");
        }
        return (TimeSeries)this.data.get(n);
    }

    public TimeSeries getSeries(String string) {
        TimeSeries timeSeries = null;
        for (TimeSeries timeSeries2 : this.data) {
            Comparable comparable = timeSeries2.getKey();
            if (comparable == null || !comparable.equals(string)) continue;
            timeSeries = timeSeries2;
        }
        return timeSeries;
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public void addSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(timeSeries);
        timeSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.remove(timeSeries);
        timeSeries.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        TimeSeries timeSeries = this.getSeries(n);
        if (timeSeries != null) {
            this.removeSeries(timeSeries);
        }
    }

    public void removeAllSeries() {
        int n = 0;
        while (n < this.data.size()) {
            TimeSeries timeSeries = (TimeSeries)this.data.get(n);
            timeSeries.removeChangeListener(this);
            ++n;
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public double getXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
        return this.getX(regularTimePeriod);
    }

    public Number getX(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
        return new Long(this.getX(regularTimePeriod));
    }

    protected synchronized long getX(RegularTimePeriod regularTimePeriod) {
        long l = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l = regularTimePeriod.getFirstMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            l = regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l = regularTimePeriod.getLastMillisecond(this.workingCalendar);
        }
        return l;
    }

    public synchronized Number getStartX(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        return new Long(timeSeriesDataItem.getPeriod().getFirstMillisecond(this.workingCalendar));
    }

    public synchronized Number getEndX(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        return new Long(timeSeriesDataItem.getPeriod().getLastMillisecond(this.workingCalendar));
    }

    public Number getY(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        return timeSeriesDataItem.getValue();
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public int[] getSurroundingItems(int n, long l) {
        int[] nArray = new int[]{-1, -1};
        TimeSeries timeSeries = this.getSeries(n);
        int n2 = 0;
        while (n2 < timeSeries.getItemCount()) {
            Number number = this.getX(n, n2);
            long l2 = number.longValue();
            if (l2 <= l) {
                nArray[0] = n2;
            }
            if (l2 >= l) {
                nArray[1] = n2;
                break;
            }
            ++n2;
        }
        return nArray;
    }

    public double getDomainLowerBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getLowerBound();
        }
        return d;
    }

    public double getDomainUpperBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getUpperBound();
        }
        return d;
    }

    public Range getDomainBounds(boolean bl) {
        Range range = null;
        for (TimeSeries timeSeries : this.data) {
            int n = timeSeries.getItemCount();
            if (n <= 0) continue;
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(0);
            RegularTimePeriod regularTimePeriod2 = timeSeries.getTimePeriod(n - 1);
            Range range2 = !bl ? new Range(this.getX(regularTimePeriod), this.getX(regularTimePeriod2)) : new Range(regularTimePeriod.getFirstMillisecond(this.workingCalendar), regularTimePeriod2.getLastMillisecond(this.workingCalendar));
            range = Range.combine(range, range2);
        }
        return range;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeriesCollection)) {
            return false;
        }
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)object;
        if (this.xPosition != timeSeriesCollection.xPosition) {
            return false;
        }
        if (this.domainIsPointsInTime != timeSeriesCollection.domainIsPointsInTime) {
            return false;
        }
        return ObjectUtilities.equal(this.data, timeSeriesCollection.data);
    }

    public int hashCode() {
        int n = this.data.hashCode();
        n = 29 * n + (this.workingCalendar != null ? this.workingCalendar.hashCode() : 0);
        n = 29 * n + (this.xPosition != null ? this.xPosition.hashCode() : 0);
        n = 29 * n + (this.domainIsPointsInTime ? 1 : 0);
        return n;
    }
}

