/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.CampoReg;
import serpro.ppgd.formatosexternos.txt.CampoTXT;
import serpro.ppgd.formatosexternos.txt.MapeamentoTXT;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.util.PLong;

public class RegistroTxt {
    protected boolean fOpcional = false;
    protected Vector objListaCampos = new Vector();
    protected String fTipo;
    protected String tipoArquivo;
    protected int fPosicaoAtual = 0;
    protected boolean participaImportacao = true;
    protected boolean participaGravacao = true;

    public RegistroTxt() {
    }

    public RegistroTxt(String string, String string2) throws GeracaoTxtException {
        this();
        this.tipoArquivo = string;
        this.fTipo = string2;
        this.inicializaLista(string, MapeamentoTXT.getInstance().getRelacaoCamposRegistro(string, string2));
    }

    public RegistroTxt(String string, String string2, boolean bl) throws GeracaoTxtException {
        this(string, string2);
        this.fOpcional = bl;
    }

    protected void inicializaLista(String string, NodeList nodeList) throws GeracaoTxtException {
        this.setParticipaGravacao(MapeamentoTXT.getInstance().participaGravacao(this.tipoArquivo, this.getTipo()));
        this.setParticipaImportacao(MapeamentoTXT.getInstance().participaImportacao(this.tipoArquivo, this.getTipo()));
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element && node.getNodeName().equals("Campo")) {
                    Element element = (Element)nodeList.item(n);
                    String string2 = element.getAttribute("Decimais");
                    String string3 = element.getAttribute("CasasDecimais");
                    if (string3.trim().length() > 0) {
                        string2 = string3;
                    }
                    this.adicionaCampo(element.getAttribute("Nome"), element.getAttribute("Tipo"), element.getAttribute("Tamanho"), string2, element.getAttribute("atributoObjetoNegocio"), element.getAttribute("Conteudo"), element.getAttribute("ParticipaImportacao"), element.getAttribute("ParticipaGravacao"));
                }
                ++n;
            }
        }
    }

    protected void adicionaCampo(String string, String string2) throws GeracaoTxtException {
        CampoReg campoReg = new CampoReg(string, string2);
        this.objListaCampos.add(campoReg);
        campoReg.setPosicaoInicial(this.fPosicaoAtual);
        this.fPosicaoAtual += campoReg.getCampoTXT().getTamanho();
    }

    protected void adicionaCampo(String string, String string2, String string3) throws GeracaoTxtException {
        CampoReg campoReg = new CampoReg(string, string2.concat(string3));
        this.objListaCampos.add(campoReg);
        campoReg.setPosicaoInicial(this.fPosicaoAtual);
        this.fPosicaoAtual += campoReg.getCampoTXT().getTamanho();
    }

    protected void adicionaCampo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws GeracaoTxtException {
        CampoReg campoReg = string4.equals("") ? new CampoReg(string, string2.concat(string3)) : new CampoReg(string, string2.concat(string3).concat(",").concat(string4));
        if (string5 != null && string5.trim().length() != 0) {
            campoReg.setAtributoObjetoNegocio(string5);
        }
        if (string6 != null && string6.trim().length() != 0) {
            campoReg.setConteudoEstatico(string6);
        }
        if (string7 != null && string7.trim().equals("false")) {
            campoReg.setParticipaImportacao(false);
        }
        if (string8 != null && string8.trim().equals("false")) {
            campoReg.setParticipaGravacao(false);
        }
        this.objListaCampos.add(campoReg);
        campoReg.setPosicaoInicial(this.fPosicaoAtual);
        this.fPosicaoAtual += campoReg.getCampoTXT().getTamanho();
    }

    public int getTamanho() {
        int n = 0;
        Enumeration enumeration = this.objListaCampos.elements();
        while (enumeration.hasMoreElements()) {
            n += ((CampoReg)enumeration.nextElement()).getCampoTXT().getTamanho();
        }
        return n;
    }

    public String getLinha() throws GeracaoTxtException {
        StringBuffer stringBuffer = new StringBuffer("");
        Enumeration enumeration = this.objListaCampos.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((CampoReg)enumeration.nextElement()).getCampoTXT().asTxt());
        }
        return stringBuffer.toString();
    }

    public void setLinha(String string) throws GeracaoTxtException {
        if (string.length() != this.getTamanho()) {
            LogPPGD.debug("tamanho limite->" + this.getTamanho());
            LogPPGD.debug("Linha->" + string);
            LogPPGD.debug("tamanho linha->" + string.length());
            throw new GeracaoTxtException("Tamanho da linha diferente ( Registro ) " + this.getTipo() + ".");
        }
        Enumeration enumeration = this.objListaCampos.elements();
        while (enumeration.hasMoreElements()) {
            CampoReg campoReg = (CampoReg)enumeration.nextElement();
            int n = campoReg.getPosicaoInicial();
            int n2 = campoReg.getPosicaoFinal();
            campoReg.getCampoTXT().set(string.substring(n, n + (n2 - n) + 1));
        }
    }

    public String getTipo() {
        return this.fTipo;
    }

    public boolean estaPreenchido() throws NumberFormatException, GeracaoTxtException {
        Enumeration enumeration = this.objListaCampos.elements();
        while (enumeration.hasMoreElements()) {
            if (!((CampoReg)enumeration.nextElement()).getCampoTXT().estaPreenchido()) continue;
            return true;
        }
        return false;
    }

    public boolean opcional() {
        return this.fOpcional;
    }

    public CampoTXT fieldByName(String string) throws GeracaoTxtException {
        CampoReg campoReg = null;
        Enumeration enumeration = this.objListaCampos.elements();
        while (enumeration.hasMoreElements()) {
            campoReg = (CampoReg)enumeration.nextElement();
            if (!campoReg.getCampoTXT().getNome().equalsIgnoreCase(string)) continue;
            return campoReg.getCampoTXT();
        }
        if (campoReg == null) {
            throw new GeracaoTxtException("Campo n\u00e3o encontrado: " + string + " no Registro tipo " + this.fTipo + ".");
        }
        return null;
    }

    public void calculaCRCRegistro() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(UtilitariosString.retiraCaracteresEspeciais(this.getLinha().substring(0, this.getLinha().length() - 10)));
        crc32.CalcCrc32(stringBuffer.toString(), stringBuffer.toString().length(), pLong);
        this.fieldByName("NR_CONTROLE").set(crc32.getStrCrc32());
    }

    public String calculaCRCHeader(String string) throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(UtilitariosString.retiraCaracteresEspeciais(this.getLinha().substring(0, this.getLinha().length() - 10)));
        crc32.CalcCrc32(stringBuffer.toString(), stringBuffer.length(), pLong);
        return crc32.getStrCrc32();
    }

    public void validar() throws GeracaoTxtException {
        String string = this.fieldByName("NR_CONTROLE").asString();
        this.calculaCRCRegistro();
        if (!string.equals(this.fieldByName("NR_CONTROLE").asString())) {
            throw new GeracaoTxtException("N\u00famero de controle inv\u00e1lido no registro " + this.getTipo());
        }
    }

    public static void main(String[] stringArray) {
    }

    public boolean isParticipaGravacao() {
        return this.participaGravacao;
    }

    public void setParticipaGravacao(boolean bl) {
        this.participaGravacao = bl;
    }

    public boolean isParticipaImportacao() {
        return this.participaImportacao;
    }

    public void setParticipaImportacao(boolean bl) {
        this.participaImportacao = bl;
    }
}

