/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.swixml.Converter;
import org.swixml.converters.ActionConverter;
import org.swixml.converters.BorderConverter;
import org.swixml.converters.ColorConverter;
import org.swixml.converters.ComponentConverter;
import org.swixml.converters.DimensionConverter;
import org.swixml.converters.FontConverter;
import org.swixml.converters.ImageConverter;
import org.swixml.converters.ImageIconConverter;
import org.swixml.converters.InsetsConverter;
import org.swixml.converters.KeyStrokeConverter;
import org.swixml.converters.LayoutConverter;
import org.swixml.converters.LocaleConverter;
import org.swixml.converters.PointConverter;
import org.swixml.converters.PrimitiveConverter;
import org.swixml.converters.RectangleConverter;
import org.swixml.converters.StringConverter;

public class ConverterLibrary {
    private static ConverterLibrary instance = new ConverterLibrary();
    private Map<Class, Converter> converters = new HashMap<Class, Converter>();

    private ConverterLibrary() {
        this.registerConverters();
    }

    public static synchronized ConverterLibrary getInstance() {
        return instance;
    }

    public Map getConverters() {
        return this.converters;
    }

    private void registerConverters() {
        this.register(Action.class, new ActionConverter());
        this.register(Border.class, new BorderConverter());
        this.register(Color.class, new ColorConverter());
        this.register(Component.class, new ComponentConverter());
        this.register(Dimension.class, new DimensionConverter());
        this.register(Font.class, new FontConverter());
        this.register(Image.class, new ImageConverter());
        this.register(Icon.class, new ImageIconConverter());
        this.register(ImageIcon.class, new ImageIconConverter());
        this.register(Insets.class, new InsetsConverter());
        this.register(KeyStroke.class, new KeyStrokeConverter());
        this.register(LayoutManager.class, new LayoutConverter());
        this.register(Locale.class, new LocaleConverter());
        this.register(Point.class, new PointConverter());
        this.register(Rectangle.class, new RectangleConverter());
        this.register(String.class, new StringConverter());
        this.register(Boolean.TYPE, new PrimitiveConverter());
        this.register(Integer.TYPE, new PrimitiveConverter());
        this.register(Long.TYPE, new PrimitiveConverter());
        this.register(Float.TYPE, new PrimitiveConverter());
        this.register(Double.TYPE, new PrimitiveConverter());
    }

    public void register(Converter converter) {
        this.converters.put(converter.convertsTo(), converter);
    }

    public void register(Class clazz, Converter converter) {
        this.converters.put(clazz, converter);
    }

    public boolean hasConverter(Class clazz) {
        boolean bl = this.converters.keySet().contains(clazz);
        Iterator<Converter> iterator = this.converters.values().iterator();
        while (!bl && iterator != null && iterator.hasNext()) {
            bl = clazz.isAssignableFrom(iterator.next().convertsTo());
        }
        return bl;
    }

    public Converter getConverter(Class clazz) {
        return this.converters.get(clazz);
    }
}

