/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;

class DescendantIterator
implements Iterator {
    private Iterator iterator;
    private Iterator nextIterator;
    private List stack = new ArrayList();
    private static final String CVS_ID = "@(#) $RCSfile: DescendantIterator.java,v $ $Revision: 1.5 $ $Date: 2004/02/27 11:32:57 $ $Name: jdom_1_0 $";

    DescendantIterator(Parent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent parameter was null");
        }
        this.iterator = parent.getContent().iterator();
    }

    public boolean hasNext() {
        if (this.iterator != null && this.iterator.hasNext()) {
            return true;
        }
        if (this.nextIterator != null && this.nextIterator.hasNext()) {
            return true;
        }
        return this.stackHasAnyNext();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextIterator != null) {
            this.push(this.iterator);
            this.iterator = this.nextIterator;
            this.nextIterator = null;
        }
        while (!this.iterator.hasNext()) {
            if (this.stack.size() > 0) {
                this.iterator = this.pop();
                continue;
            }
            throw new NoSuchElementException("Somehow we lost our iterator");
        }
        Content content = (Content)this.iterator.next();
        if (content instanceof Element) {
            this.nextIterator = ((Element)content).getContent().iterator();
        }
        return content;
    }

    public void remove() {
        this.iterator.remove();
    }

    private Iterator pop() {
        int n = this.stack.size();
        if (n == 0) {
            throw new NoSuchElementException("empty stack");
        }
        return (Iterator)this.stack.remove(n - 1);
    }

    private void push(Iterator iterator) {
        this.stack.add(iterator);
    }

    private boolean stackHasAnyNext() {
        int n = this.stack.size();
        int n2 = 0;
        while (n2 < n) {
            Iterator iterator = (Iterator)this.stack.get(n2);
            if (iterator.hasNext()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

