/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.collection;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;

public class PdfCollectionSort
extends PdfDictionary {
    public PdfCollectionSort(String string) {
        super(PdfName.COLLECTIONSORT);
        this.put(PdfName.S, new PdfName(string));
    }

    public PdfCollectionSort(String[] stringArray) {
        super(PdfName.COLLECTIONSORT);
        PdfArray pdfArray = new PdfArray();
        int n = 0;
        while (n < stringArray.length) {
            pdfArray.add(new PdfName(stringArray[n]));
            ++n;
        }
        this.put(PdfName.S, pdfArray);
    }

    public void setSortOrder(boolean bl) {
        PdfObject pdfObject = this.get(PdfName.S);
        if (!(pdfObject instanceof PdfName)) {
            throw new IllegalArgumentException("You have to define a boolean array for this collection sort dictionary.");
        }
        this.put(PdfName.A, new PdfBoolean(bl));
    }

    public void setSortOrder(boolean[] blArray) {
        PdfArray pdfArray;
        PdfObject pdfObject = this.get(PdfName.S);
        if (pdfObject instanceof PdfArray) {
            if (((PdfArray)pdfObject).size() != blArray.length) {
                throw new IllegalArgumentException("The number of booleans in this array doesn't correspond with the number of fields.");
            }
            pdfArray = new PdfArray();
            int n = 0;
            while (n < blArray.length) {
                pdfArray.add(new PdfBoolean(blArray[n]));
                ++n;
            }
        } else {
            throw new IllegalArgumentException("You need a single boolean for this collection sort dictionary.");
        }
        this.put(PdfName.A, pdfArray);
    }
}

