/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.jdom.Document;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.swixml.Localizer;
import org.swixml.Parser;
import org.swixml.SwingTagLibrary;
import org.swixml.TagLibrary;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingEngine {
    public static final String MAC_OSX_OS_NAME = "mac os x";
    public static final String MAC_OSX_LOCALE_VARIANT = "mac";
    private static final String XML_ERROR_MSG = "Invalid SwiXML Descriptor.";
    private static final String IO_ERROR_MSG = "Resource could not be found ";
    private static final String MAPPING_ERROR_MSG = " could not be mapped to any Object and remained un-initialized.";
    public static boolean DEBUG_MODE = false;
    private static Frame appFrame;
    private static String default_resource_bundle_name;
    private static Locale default_locale;
    private static boolean MAC_OSX;
    private static boolean MAC_OSX_SUPPORTED;
    private Parser parser;
    private Object client;
    private Container root;
    private Map<String, Object> idmap;
    private Collection components;
    private Localizer localizer;
    private final TagLibrary taglib;
    protected ClassLoader cl;

    static {
        default_resource_bundle_name = null;
        default_locale = Locale.getDefault();
        MAC_OSX = false;
        MAC_OSX_SUPPORTED = true;
        System.out.println("SwixML @version@");
        try {
            MAC_OSX = System.getProperty("os.name").toLowerCase().startsWith(MAC_OSX_OS_NAME);
        }
        catch (Exception exception) {
            MAC_OSX = false;
        }
    }

    public SwingEngine() {
        this.parser = new Parser(this);
        this.idmap = new HashMap<String, Object>();
        this.components = null;
        this.localizer = new Localizer();
        this.taglib = SwingTagLibrary.getInstance();
        this.cl = this.getClass().getClassLoader();
        this.client = this;
        this.setLocale(default_locale);
        this.getLocalizer().setResourceBundle(default_resource_bundle_name);
        try {
            if (SwingEngine.isMacOSXSupported() && SwingEngine.isMacOSX()) {
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.showGrowBox", "true");
                System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            }
        }
        catch (AccessControlException accessControlException) {}
    }

    public SwingEngine(Object object) {
        this();
        this.client = object;
    }

    public SwingEngine(String string) {
        this(SwingEngine.class.getClassLoader(), string);
    }

    public SwingEngine(ClassLoader classLoader, String string) {
        block13: {
            Reader reader;
            block12: {
                this();
                this.setClassLoader(classLoader);
                reader = null;
                try {
                    try {
                        InputStream inputStream = classLoader.getResourceAsStream(string);
                        if (inputStream == null) {
                            throw new IOException(IO_ERROR_MSG + string);
                        }
                        reader = new InputStreamReader(inputStream);
                        this.render(reader);
                    }
                    catch (Exception exception) {
                        if (!DEBUG_MODE) break block12;
                        System.err.println(exception);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception exception) {}
                break block13;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public Container render(URL uRL) throws Exception {
        Reader reader = null;
        Container container = null;
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + uRL.toString());
            }
            reader = new InputStreamReader(inputStream);
            container = this.render(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Exception exception) {}
        return container;
    }

    public Container render(String string) throws Exception {
        Reader reader = null;
        Container container = null;
        try {
            InputStream inputStream = this.cl.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + string);
            }
            reader = new InputStreamReader(inputStream);
            container = this.render(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Exception exception) {}
        return container;
    }

    public Container render(File file) throws Exception {
        if (file == null) {
            throw new IOException();
        }
        return this.render(new FileReader(file));
    }

    public Container render(Reader reader) throws Exception {
        if (reader == null) {
            throw new IOException();
        }
        try {
            return this.render(new SAXBuilder().build(reader));
        }
        catch (SAXParseException sAXParseException) {
            System.err.println(sAXParseException);
        }
        catch (JDOMParseException jDOMParseException) {
            System.err.println(jDOMParseException);
        }
        throw new Exception(XML_ERROR_MSG);
    }

    public Container render(Document document) throws Exception {
        this.idmap.clear();
        try {
            this.root = (Container)this.parser.parse(document);
        }
        catch (Exception exception) {
            if (DEBUG_MODE) {
                System.err.println(exception);
            }
            throw exception;
        }
        this.components = null;
        this.mapMembers(this.client);
        if (Frame.class.isAssignableFrom(this.root.getClass())) {
            SwingEngine.setAppFrame((Frame)this.root);
        }
        return this.root;
    }

    public void insert(URL uRL, Container container) throws Exception {
        Reader reader = null;
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + uRL.toString());
            }
            reader = new InputStreamReader(inputStream);
            this.insert(reader, container);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Exception exception) {}
    }

    public void insert(Reader reader, Container container) throws Exception {
        if (reader == null) {
            throw new IOException();
        }
        this.insert(new SAXBuilder().build(reader), container);
    }

    public void insert(String string, Container container) throws Exception {
        Reader reader = null;
        try {
            InputStream inputStream = this.cl.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + string);
            }
            reader = new InputStreamReader(inputStream);
            this.insert(reader, container);
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {}
    }

    public void insert(Document document, Container container) throws Exception {
        this.root = container;
        try {
            this.parser.parse(document, container);
        }
        catch (Exception exception) {
            if (DEBUG_MODE) {
                System.err.println(exception);
            }
            throw exception;
        }
        this.components = null;
        this.mapMembers(this.client);
    }

    public static void setResourceBundleName(String string) {
        default_resource_bundle_name = string;
    }

    public static void setDefaultLocale(Locale locale) {
        default_locale = locale;
    }

    public static void setAppFrame(Frame frame) {
        if (frame != null && appFrame == null) {
            appFrame = frame;
        }
    }

    public static Frame getAppFrame() {
        return appFrame;
    }

    public Object getClient() {
        return this.client;
    }

    public Container getRootComponent() {
        return this.root;
    }

    public Iterator getAllComponentItertor() {
        if (this.components == null) {
            this.components = new ArrayList();
            SwingEngine.traverse(this.root, this.components);
        }
        return this.components.iterator();
    }

    public Iterator getIdComponentItertor() {
        return this.idmap.values().iterator();
    }

    public Map<String, Object> getIdMap() {
        return this.idmap;
    }

    public int cleanup() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.idmap.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            Object object = this.idmap.get(string);
            if (!(object instanceof Component) || ((Component)object).isDisplayable()) continue;
            arrayList.add(string);
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.idmap.remove(arrayList.get(n));
            ++n;
        }
        this.components = null;
        return arrayList.size();
    }

    public void forget(String string) {
        this.idmap.remove(string);
    }

    public Component find(String string) {
        Object object = this.idmap.get(string);
        if (object != null && !Component.class.isAssignableFrom(object.getClass())) {
            object = null;
        }
        return (Component)object;
    }

    public void setLocale(Locale locale) {
        if (SwingEngine.isMacOSXSupported() && SwingEngine.isMacOSX()) {
            locale = new Locale(locale.getLanguage(), locale.getCountry(), MAC_OSX_LOCALE_VARIANT);
        }
        this.localizer.setLocale(locale);
    }

    public void setResourceBundle(String string) {
        this.localizer.setResourceBundle(string);
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public TagLibrary getTaglib() {
        return this.taglib;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.cl = classLoader;
        this.localizer.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public boolean setActionListener(Component component, ActionListener actionListener) {
        boolean bl = false;
        if (component != null) {
            int n;
            Object object;
            if (Container.class.isAssignableFrom(component.getClass())) {
                object = ((Container)component).getComponents();
                Component[] componentArray = object;
                n = 0;
                int n2 = componentArray.length;
                while (n < n2) {
                    Component component2 = componentArray[n];
                    bl |= this.setActionListener(component2, actionListener);
                    ++n;
                }
            }
            if (!bl) {
                if (JMenu.class.isAssignableFrom(component.getClass())) {
                    object = (JMenu)component;
                    int n3 = ((JMenu)object).getItemCount();
                    n = 0;
                    while (n < n3) {
                        bl |= this.setActionListener(((JMenu)object).getItem(n), actionListener);
                        ++n;
                    }
                } else if (AbstractButton.class.isAssignableFrom(component.getClass())) {
                    ((AbstractButton)component).addActionListener(actionListener);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public Iterator getDescendants(Component component) {
        ArrayList arrayList = new ArrayList(12);
        SwingEngine.traverse(component, arrayList);
        return arrayList.iterator();
    }

    protected void mapMembers(Object object) {
        if (object != null) {
            this.mapMembers(object, object.getClass());
        }
    }

    private void mapMembers(Object object, Class clazz) {
        boolean bl = true;
        if (object != null && clazz != null && !Object.class.equals((Object)clazz)) {
            Field[] fieldArray = null;
            try {
                fieldArray = clazz.getDeclaredFields();
            }
            catch (AccessControlException accessControlException) {
                bl = false;
                fieldArray = clazz.getFields();
            }
            int n = 0;
            while (n < fieldArray.length) {
                Object object2 = this.idmap.get(fieldArray[n].getName());
                if (object2 != null && fieldArray[n].getType().isAssignableFrom(object2.getClass()) && !Modifier.isTransient(fieldArray[n].getModifiers())) {
                    try {
                        boolean bl2 = fieldArray[n].isAccessible();
                        fieldArray[n].setAccessible(true);
                        fieldArray[n].set(object, object2);
                        fieldArray[n].setAccessible(bl2);
                    }
                    catch (AccessControlException accessControlException) {
                        try {
                            bl = false;
                            fieldArray[n].set(object, object2);
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                if (fieldArray[n] == null) {
                    if (!DEBUG_MODE) {
                        try {
                            fieldArray[n].set(object, fieldArray[n].getType().newInstance());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InstantiationException instantiationException) {}
                    } else {
                        System.err.println(fieldArray[n].getType() + " : " + fieldArray[n].getName() + MAPPING_ERROR_MSG);
                    }
                }
                ++n;
            }
            if (bl) {
                this.mapMembers(object, clazz.getSuperclass());
            }
        }
    }

    protected static void traverse(Component component, Collection collection) {
        block2: {
            Component[] componentArray;
            block3: {
                if (component == null) break block2;
                collection.add(component);
                if (!(component instanceof JMenu)) break block3;
                JMenu jMenu = (JMenu)component;
                int n = jMenu.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    SwingEngine.traverse(jMenu.getItem(n2), collection);
                    ++n2;
                }
                break block2;
            }
            if (!(component instanceof Container)) break block2;
            Component[] componentArray2 = componentArray = ((Container)component).getComponents();
            int n = 0;
            int n3 = componentArray2.length;
            while (n < n3) {
                Component component2 = componentArray2[n];
                SwingEngine.traverse(component2, collection);
                ++n;
            }
        }
    }

    public static void setMacOSXSuport(boolean bl) {
        MAC_OSX_SUPPORTED = bl;
    }

    public static boolean isMacOSXSupported() {
        return MAC_OSX_SUPPORTED;
    }

    public static boolean isMacOSX() {
        return MAC_OSX;
    }

    public void test() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                System.exit(0);
            }
        };
        if (this.root != null) {
            if (JFrame.class.isAssignableFrom(this.root.getClass()) || JDialog.class.isAssignableFrom(this.root.getClass())) {
                ((Window)this.root).addWindowListener(windowAdapter);
                this.root.setVisible(true);
            } else {
                JFrame jFrame = new JFrame("SwiXml Test");
                jFrame.getContentPane().add(this.root);
                jFrame.pack();
                jFrame.addWindowListener(windowAdapter);
                jFrame.setVisible(true);
            }
        }
    }
}

